/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.SingleValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import javafx.scene.control.ToggleGroup;

public class ToggleGroupPropertyMetadata
extends SingleValuePropertyMetadata<String> {
    public ToggleGroupPropertyMetadata(PropertyName name, boolean readWrite, String defaultValue, InspectorPath inspectorPath) {
        super(name, String.class, readWrite, defaultValue, inspectorPath);
    }

    @Override
    public String makeValueFromString(String string) {
        String result;
        PrefixedValue pv = new PrefixedValue(string);
        if (pv.isExpression()) {
            result = pv.getSuffix();
        } else {
            assert (false) : "Unexpected prefixed value " + string;
            result = null;
        }
        return result;
    }

    @Override
    public String makeValueFromFxomInstance(FXOMInstance valueFxomInstance) {
        String result;
        if (valueFxomInstance.getDeclaredClass() == ToggleGroup.class) {
            result = valueFxomInstance.getFxId();
        } else {
            assert (false) : "unexpected declared class " + valueFxomInstance.getDeclaredClass().getSimpleName();
            result = null;
        }
        return result;
    }

    @Override
    public boolean canMakeStringFromValue(String value) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public String makeStringFromValue(String value) {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public FXOMInstance makeFxomInstanceFromValue(String value, FXOMDocument fxomDocument) {
        throw new UnsupportedOperationException("Should not be invoked");
    }
}

