/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;

class BeanPropertyIntrospector {
    private final Object object;
    private final PropertyDescriptor[] propertyDescriptors;

    public BeanPropertyIntrospector(Object object) {
        assert (object != null);
        this.object = object;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            this.propertyDescriptors = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException x) {
            throw new RuntimeException(x);
        }
    }

    public Object getValue(String propertyName) {
        Object result;
        PropertyDescriptor d = this.findDescriptor(propertyName);
        if (d != null) {
            try {
                result = d.getReadMethod().invoke(this.object, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException x) {
                throw new RuntimeException(x);
            }
        } else {
            throw new RuntimeException(propertyName + " not found");
        }
        return result;
    }

    public void setValue(String propertyName, Object value) {
        PropertyDescriptor d = this.findDescriptor(propertyName);
        if (d != null) {
            try {
                d.getWriteMethod().invoke(this.object, value);
            }
            catch (IllegalAccessException | InvocationTargetException x) {
                throw new RuntimeException(x);
            }
        } else {
            throw new RuntimeException(propertyName + " not found");
        }
    }

    private PropertyDescriptor findDescriptor(String propertyName) {
        int i;
        assert (this.propertyDescriptors != null);
        for (i = 0; i < this.propertyDescriptors.length && !this.propertyDescriptors[i].getName().equals(propertyName); ++i) {
        }
        return i < this.propertyDescriptors.length ? this.propertyDescriptors[i] : null;
    }
}

