/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.util;

import java.util.Objects;

public class InspectorPath
implements Comparable<InspectorPath> {
    private final String sectionTag;
    private final String subSectionTag;
    private final int subSectionIndex;
    public static final String CUSTOM_SECTION = "Properties";
    public static final String CUSTOM_SUB_SECTION = "Custom";
    public static final InspectorPath UNUSED = new InspectorPath("", "", 0);

    public InspectorPath(String sectionTag, String subSectionTag, int subSectionIndex) {
        assert (sectionTag != null);
        assert (subSectionTag != null);
        assert (subSectionIndex >= 0);
        this.sectionTag = sectionTag;
        this.subSectionTag = subSectionTag;
        this.subSectionIndex = subSectionIndex;
    }

    public String getSectionTag() {
        return this.sectionTag;
    }

    public String getSubSectionTag() {
        return this.subSectionTag;
    }

    public int getSubSectionIndex() {
        return this.subSectionIndex;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.sectionTag);
        hash = 97 * hash + Objects.hashCode(this.subSectionTag);
        hash = 97 * hash + this.subSectionIndex;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InspectorPath other = (InspectorPath)obj;
        if (!Objects.equals(this.sectionTag, other.sectionTag)) {
            return false;
        }
        if (!Objects.equals(this.subSectionTag, other.subSectionTag)) {
            return false;
        }
        return this.subSectionIndex == other.subSectionIndex;
    }

    @Override
    public int compareTo(InspectorPath o) {
        int result = this.sectionTag.compareTo(o.sectionTag);
        if (result == 0) {
            result = this.subSectionTag.compareTo(o.subSectionTag);
        }
        if (result == 0) {
            if (this.subSectionIndex < o.subSectionIndex) {
                result = -1;
            } else if (this.subSectionIndex > o.subSectionIndex) {
                result = 1;
            } else {
                assert (this.subSectionIndex == o.subSectionIndex);
                assert (result == 0);
            }
        }
        return result;
    }
}

