/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Arrays;
import org.fest.util.Sets;
import org.fest.util.ToString;

final class ArrayFormatter {
    private static final String NULL = "null";

    ArrayFormatter() {
    }

    @Nullable
    String format(@Nullable Object o) {
        if (o == null || !Arrays.isArray(o)) {
            return null;
        }
        return this.isObjectArray(o) ? this.formatObjectArray(o) : this.formatPrimitiveArray(o);
    }

    @Nonnull
    private String formatObjectArray(@Nonnull Object o) {
        Object[] array = (Object[])o;
        int size = array.length;
        if (size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(20 * (size - 1));
        HashSet<Object[]> alreadyFormatted = Sets.newHashSet();
        this.deepToString(array, buffer, alreadyFormatted);
        return buffer.toString();
    }

    private void deepToString(@Nullable Object[] array, @Nonnull StringBuilder buffer, @Nonnull Set<Object[]> alreadyFormatted) {
        if (array == null) {
            buffer.append(NULL);
            return;
        }
        alreadyFormatted.add(array);
        buffer.append('[');
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            Object element;
            if (i != 0) {
                buffer.append(", ");
            }
            if (!Arrays.isArray(element = array[i])) {
                buffer.append(element == null ? NULL : ToString.toStringOf(element));
                continue;
            }
            if (!this.isObjectArray(element)) {
                buffer.append(this.formatPrimitiveArray(element));
                continue;
            }
            if (alreadyFormatted.contains(element)) {
                buffer.append("[...]");
                continue;
            }
            this.deepToString((Object[])element, buffer, alreadyFormatted);
        }
        buffer.append(']');
        alreadyFormatted.remove(array);
    }

    private boolean isObjectArray(@Nullable Object o) {
        return o != null && Arrays.isArray(o) && !this.isArrayTypePrimitive(o);
    }

    private String formatPrimitiveArray(@Nullable Object o) {
        if (o == null || !Arrays.isArray(o)) {
            return null;
        }
        if (!this.isArrayTypePrimitive(o)) {
            String msg = String.format("<%s> is not an array of primitives", o);
            throw new IllegalArgumentException(msg);
        }
        int size = Array.getLength(o);
        if (size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        buffer.append(ToString.toStringOf(Array.get(o, 0)));
        for (int i = 1; i < size; ++i) {
            buffer.append(", ");
            buffer.append(ToString.toStringOf(Array.get(o, i)));
        }
        buffer.append("]");
        return buffer.toString();
    }

    private boolean isArrayTypePrimitive(@Nonnull Object o) {
        return o.getClass().getComponentType().isPrimitive();
    }
}

