/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Arrays;
import org.fest.util.Closeables;
import org.fest.util.Flushables;
import org.fest.util.IORuntimeException;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class Files {
    private Files() {
    }

    @Nonnull
    public static List<String> fileNamesIn(@Nonnull String dirName, boolean recurse) {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(String.format("%s is not a directory", Strings.quote(dirName)));
        }
        return Files.fileNamesIn(dir, recurse);
    }

    @Nonnull
    private static List<String> fileNamesIn(@Nonnull File dir, boolean recurse) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File[] existingFiles = dir.listFiles();
        if (existingFiles == null) {
            return fileNames;
        }
        for (File existingFile : existingFiles) {
            if (existingFile.isDirectory()) {
                if (!recurse) continue;
                fileNames.addAll(Files.fileNamesIn(existingFile, recurse));
                continue;
            }
            String filename = existingFile.getAbsolutePath();
            if (fileNames.contains(filename)) continue;
            fileNames.add(filename);
        }
        return fileNames;
    }

    @Nonnull
    public static File temporaryFolder() {
        File temp = new File(Files.temporaryFolderPath());
        if (!temp.isDirectory()) {
            throw new IORuntimeException("Unable to find temporary directory");
        }
        return temp;
    }

    @Nonnull
    public static String temporaryFolderPath() {
        String fileSeparator = Preconditions.checkNotNull(File.separator);
        String tmpDirPath = Preconditions.checkNotNull(System.getProperty("java.io.tmpdir"));
        return Strings.append(fileSeparator).to(tmpDirPath);
    }

    @Nonnull
    public static File newTemporaryFile() {
        String tempFileName = String.format("%d.%s", System.currentTimeMillis(), ".txt");
        return Files.newFile(Files.temporaryFolderPath() + tempFileName);
    }

    @Nonnull
    public static File newTemporaryFolder() {
        String tempFileName = String.valueOf(System.currentTimeMillis());
        return Files.newFolder(Files.temporaryFolderPath() + tempFileName);
    }

    @Nonnull
    public static File newFile(@Nonnull String path) {
        File file = new File(path);
        if (file.isDirectory() && !Arrays.isNullOrEmpty(file.list())) {
            throw Files.cannotCreateNewFile(path, "a non-empty directory was found with the same path");
        }
        try {
            if (!file.createNewFile()) {
                throw Files.cannotCreateNewFile(path, "a file was found with the same path");
            }
        }
        catch (IOException e) {
            throw Files.cannotCreateNewFile(path, e);
        }
        return file;
    }

    @Nonnull
    public static File newFolder(@Nonnull String path) {
        File file = new File(path);
        if (file.isDirectory() && !Arrays.isNullOrEmpty(file.list())) {
            throw Files.cannotCreateNewFile(path, "a non-empty directory was found with the same path");
        }
        if (!file.mkdir()) {
            throw Files.cannotCreateNewFile(path, "a file was found with the same path");
        }
        return file;
    }

    @Nonnull
    private static IORuntimeException cannotCreateNewFile(@Nonnull String path, @Nonnull String reason) {
        throw Files.cannotCreateNewFile(path, reason, null);
    }

    @Nonnull
    private static IORuntimeException cannotCreateNewFile(@Nonnull String path, @Nonnull IOException cause) {
        throw Files.cannotCreateNewFile(path, null, cause);
    }

    @Nonnull
    private static IORuntimeException cannotCreateNewFile(@Nonnull String path, @Nullable String reason, @Nullable IOException cause) {
        String message = String.format("Unable to create the new file %s", Strings.quote(path));
        if (!Strings.isNullOrEmpty(reason)) {
            message = String.format("%s: %s", message, reason);
        }
        return new IORuntimeException(Preconditions.checkNotNull(message), cause);
    }

    public static void flushAndClose(@Nullable Writer writer) {
        if (writer == null) {
            return;
        }
        Flushables.flushQuietly(writer);
        Closeables.closeQuietly(writer);
    }

    public static void flushAndClose(@Nullable OutputStream out) {
        if (out == null) {
            return;
        }
        Flushables.flushQuietly(out);
        Closeables.closeQuietly(out);
    }

    @Nonnull
    public static File currentFolder() {
        try {
            return Preconditions.checkNotNull(new File(".").getCanonicalFile());
        }
        catch (IOException e) {
            throw new IORuntimeException("Unable to get current directory", e);
        }
    }

    public static void delete(@Nonnull File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        for (File f : file.listFiles()) {
            Files.delete(Preconditions.checkNotNull(f));
        }
        file.delete();
    }

    @Nonnull
    public static String contentOf(@Nonnull File file, @Nonnull String charsetName) {
        if (!Charset.isSupported(charsetName)) {
            throw new IllegalArgumentException(String.format("Charset:<'%s'> is not supported on this system", charsetName));
        }
        return Files.contentOf(file, Preconditions.checkNotNull(Charset.forName(charsetName)));
    }

    @Nonnull
    public static String contentOf(@Nonnull File file, @Nonnull Charset charset) {
        Preconditions.checkNotNull(charset);
        try {
            return Files.loadContents(file, charset);
        }
        catch (IOException e) {
            throw new IORuntimeException("Unable to read " + file.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static String loadContents(@Nonnull File file, @Nonnull Charset charset) throws IOException {
        String string;
        BufferedReader reader = null;
        try {
            int c;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            StringWriter writer = new StringWriter();
            while ((c = reader.read()) != -1) {
                writer.write(c);
            }
            string = Preconditions.checkNotNull(writer.toString());
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(reader);
            throw throwable;
        }
        Closeables.closeQuietly(reader);
        return string;
    }
}

