/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionsAreaImpl
implements ExtensionsArea {
    private static final Logger LOG = Logger.getInstance(ExtensionsAreaImpl.class);
    public static final String ATTRIBUTE_AREA = "area";
    private static final boolean DEBUG_REGISTRATION = Boolean.FALSE;
    private final ComponentManager myComponentManager;
    private final Map<String, ExtensionPointImpl<?>> myExtensionPoints;
    private final Map<String, Throwable> myEPTraces;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(0);
        }
        this.myExtensionPoints = ContainerUtil.newConcurrentMap();
        this.myEPTraces = DEBUG_REGISTRATION ? new THashMap() : null;
        this.myComponentManager = componentManager;
    }

    public final void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        THashSet processedEPs = new THashSet();
        for (ExtensionPointImpl<?> point : this.myExtensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.getName());
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.myExtensionPoints.values()) {
            if (processedEPs.contains(point.getName())) continue;
            point.notifyAreaReplaced(this);
        }
    }

    public void registerExtensionPoints(@NotNull PluginDescriptor pluginDescriptor, @NotNull List<? extends Element> extensionPointElements) {
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(1);
        }
        if (extensionPointElements == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(2);
        }
        for (Element element : extensionPointElements) {
            this.registerExtensionPoint(pluginDescriptor, element);
        }
    }

    private void registerExtensionPoint(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionPointElement) {
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(3);
        }
        if (extensionPointElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(4);
        }
        String pointName = this.getExtensionPointName(extensionPointElement, pluginDescriptor);
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw this.myComponentManager.createError("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw this.myComponentManager.createError("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
        }
        boolean dynamic = Boolean.parseBoolean(extensionPointElement.getAttributeValue("dynamic"));
        String className = interfaceClassName == null ? beanClassName : interfaceClassName;
        this.doRegisterExtensionPoint(pointName, className, pluginDescriptor, interfaceClassName != null, dynamic);
    }

    @NotNull
    private String getExtensionPointName(@NotNull Element extensionPointElement, @NotNull PluginDescriptor pluginDescriptor) {
        String pointName;
        if (extensionPointElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(5);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(6);
        }
        if ((pointName = extensionPointElement.getAttributeValue("qualifiedName")) == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw this.myComponentManager.createError("'name' attribute not specified for extension point in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
            }
            assert (pluginDescriptor.getPluginId() != null);
            pointName = pluginDescriptor.getPluginId().getIdString() + '.' + name;
        }
        String string = pointName;
        if (string == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public void registerExtension(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement, String extensionNs) {
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(8);
        }
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(9);
        }
        String epName = ExtensionsAreaImpl.extractPointName(extensionElement, extensionNs);
        this.registerExtension(this.getExtensionPoint(epName), pluginDescriptor, extensionElement);
    }

    @Override
    public void registerExtension(@NotNull ExtensionPoint<?> extensionPoint, @NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement) {
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(10);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(11);
        }
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(12);
        }
        ((ExtensionPointImpl)extensionPoint).createAndRegisterAdapter(extensionElement, pluginDescriptor, this.myComponentManager);
    }

    @NotNull
    public static String extractPointName(@NotNull Element extensionElement, @Nullable String ns) {
        String epName;
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(13);
        }
        if ((epName = extensionElement.getAttributeValue("point")) == null) {
            if (ns == null) {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            } else {
                epName = ns + '.' + extensionElement.getName();
            }
        }
        String string = epName;
        if (string == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(15);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(16);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(17);
        }
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
    }

    public void registerExtensionPoint(@NotNull BaseExtensionPointName<?> extensionPoint, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, @NotNull Disposable parentDisposable) {
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(18);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(19);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(20);
        }
        if (parentDisposable == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(21);
        }
        String extensionPointName = extensionPoint.getName();
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
        Disposer.register((Disposable)parentDisposable, () -> this.unregisterExtensionPoint(extensionPointName));
    }

    void doRegisterExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(22);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(23);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(24);
        }
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId("FakeIdForTests"));
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, pluginDescriptor, kind == ExtensionPoint.Kind.INTERFACE, false);
    }

    public <T> ExtensionPointImpl<T> registerPoint(@NotNull String name, @NotNull Class<T> extensionClass, @NotNull PluginDescriptor pluginDescriptor) {
        if (name == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(25);
        }
        if (extensionClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(26);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(27);
        }
        return this.doRegisterExtensionPoint(name, extensionClass.getName(), pluginDescriptor, extensionClass.isInterface() || (extensionClass.getModifiers() & 0x400) != 0, false);
    }

    @NotNull
    private <T> ExtensionPointImpl<T> doRegisterExtensionPoint(@NotNull String name, @NotNull String extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isInterface, boolean dynamic) {
        if (name == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(28);
        }
        if (extensionClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(29);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(30);
        }
        ExtensionPointImpl point = isInterface ? new InterfaceExtensionPoint(name, extensionClass, pluginDescriptor, dynamic) : new BeanExtensionPoint(name, extensionClass, pluginDescriptor, dynamic);
        point.setComponentManager(this.myComponentManager);
        this.registerExtensionPoint(point);
        ExtensionPointImpl extensionPointImpl = point;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(31);
        }
        return extensionPointImpl;
    }

    public <T> ExtensionPointImpl<T> registerFakeBeanPoint(@NotNull String name, @NotNull PluginDescriptor pluginDescriptor) {
        if (name == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(32);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(33);
        }
        return this.doRegisterExtensionPoint(name, Object.class.getName(), pluginDescriptor, false, false);
    }

    private void checkThatPointNotDuplicated(@NotNull String pointName, @NotNull PluginDescriptor pluginDescriptor) {
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(34);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(35);
        }
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        PluginId id1 = ((ExtensionPointImpl)this.getExtensionPoint(pointName)).getDescriptor().getPluginId();
        PluginId id2 = pluginDescriptor.getPluginId();
        String message = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        if (DEBUG_REGISTRATION) {
            LOG.error(message, this.myEPTraces.get(pointName));
        }
        throw this.myComponentManager.createError(message, pluginDescriptor.getPluginId());
    }

    private void registerExtensionPoint(@NotNull ExtensionPointImpl<?> point) {
        if (point == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(36);
        }
        String name = point.getName();
        this.checkThatPointNotDuplicated(name, point.getDescriptor());
        this.myExtensionPoints.put(name, point);
        if (DEBUG_REGISTRATION) {
            this.myEPTraces.put(name, new Throwable("Original registration for " + name));
        }
    }

    @ApiStatus.Internal
    public void registerExtensionPoints(@NotNull List<? extends ExtensionPointImpl<?>> points, boolean clonePoint) {
        if (points == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(37);
        }
        ComponentManager componentManager = this.myComponentManager;
        Map<String, ExtensionPointImpl<?>> map = this.myExtensionPoints;
        for (ExtensionPointImpl<?> point : points) {
            ExtensionPointImpl<?> old;
            if (clonePoint) {
                point = point.cloneFor(componentManager);
            } else {
                point.setComponentManager(componentManager);
            }
            if ((old = map.put(point.getName(), point)) == null) continue;
            map.put(point.getName(), old);
            throw this.myComponentManager.createError("Duplicate registration for EP '" + point.getName() + "': first in " + old.getDescriptor() + ", second in " + point.getDescriptor(), point.getDescriptor().getPluginId());
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl<?> extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(38);
        }
        if ((extensionPoint = this.myExtensionPoints.get(extensionPointName)) == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.myComponentManager);
        }
        ExtensionPointImpl<?> extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(39);
        }
        return extensionPointImpl;
    }

    @ApiStatus.Internal
    public boolean registerExtensions(@NotNull String pointName, @NotNull List<? extends Element> extensions, @NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, @Nullable List<Runnable> listenerCallbacks) {
        ExtensionPointImpl<?> point;
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(40);
        }
        if (extensions == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(41);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(42);
        }
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(43);
        }
        if ((point = this.myExtensionPoints.get(pointName)) == null) {
            return false;
        }
        point.registerExtensions(extensions, pluginDescriptor, componentManager, listenerCallbacks);
        return true;
    }

    @Override
    @Nullable
    public <T> ExtensionPoint<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(44);
        }
        ExtensionPointImpl<?> extensionPoint = this.myExtensionPoints.get(extensionPointName);
        return extensionPoint;
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(45);
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName.getName());
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(46);
        }
        return extensionPoint;
    }

    public ExtensionPointImpl<?> @NotNull [] getExtensionPoints() {
        ExtensionPointImpl[] extensionPointImplArray = this.myExtensionPoints.values().toArray(new ExtensionPointImpl[0]);
        if (extensionPointImplArray == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(47);
        }
        return extensionPointImplArray;
    }

    @Nullable
    @ApiStatus.Internal
    public <T> T findExtensionByClass(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(48);
        }
        if (aClass.getName().equals("com.intellij.execution.executors.DefaultDebugExecutor")) {
            return this.myExtensionPoints.get("com.intellij.executor").findExtension(aClass, false, ThreeState.YES);
        }
        for (ExtensionPointImpl<?> point : this.myExtensionPoints.values()) {
            if (!(point instanceof InterfaceExtensionPoint)) continue;
            try {
                T extension;
                Class<T> extensionClass = point.getExtensionClass();
                if (!extensionClass.isAssignableFrom(aClass) || (extension = point.findExtension(aClass, false, ThreeState.YES)) == null) continue;
                return extension;
            }
            catch (Throwable e) {
                LOG.warn("error during findExtensionPointByClass", e);
            }
        }
        return null;
    }

    @Override
    public void unregisterExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPoint extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(49);
        }
        if ((extensionPoint = (ExtensionPoint)this.myExtensionPoints.get(extensionPointName)) != null) {
            extensionPoint.reset();
            this.myExtensionPoints.remove(extensionPointName);
        }
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(50);
        }
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(51);
        }
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    public String toString() {
        return this.myComponentManager.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 14: 
            case 31: 
            case 39: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 14: 
            case 31: 
            case 39: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 27: 
            case 30: 
            case 33: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElement";
                break;
            }
            case 7: 
            case 14: 
            case 31: 
            case 39: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 15: 
            case 22: 
            case 38: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointBeanClass";
                break;
            }
            case 17: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 25: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPointName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPointName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "doRegisterExtensionPoint";
                break;
            }
            case 39: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoint";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoints";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointName";
                break;
            }
            case 7: 
            case 14: 
            case 31: 
            case 39: 
            case 46: 
            case 47: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractPointName";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtensionPoint";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerPoint";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "registerFakeBeanPoint";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkThatPointNotDuplicated";
                break;
            }
            case 38: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPoint";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointIfRegistered";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionByClass";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoint";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "hasExtensionPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 14: 
            case 31: 
            case 39: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

