/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public abstract class BaseInspectionVisitor
extends GroovyElementVisitor {
    private BaseInspection inspection = null;
    private ProblemsHolder problemsHolder = null;
    private boolean onTheFly = false;

    void initialize(BaseInspection inspection, ProblemsHolder problemsHolder, boolean onTheFly) {
        this.inspection = inspection;
        this.problemsHolder = problemsHolder;
        this.onTheFly = onTheFly;
    }

    protected void registerStatementError(GrStatement statement, Object ... args) {
        PsiElement statementToken = statement.getFirstChild();
        this.registerError(statementToken, args);
    }

    protected void registerError(PsiElement location) {
        if (location == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(location);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(location));
        this.registerError(location, description, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerMethodError(GrMethod method, Object ... args) {
        if (method == null) {
            return;
        }
        LocalQuickFix[] fixes = this.createFixes(method);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(method.getNameIdentifierGroovy(), description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerVariableError(GrVariable variable, Object ... args) {
        if (variable == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(variable);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(variable.getNameIdentifierGroovy(), description, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerMethodCallError(GrMethodCall method, Object ... args) {
        if (method == null) {
            return;
        }
        LocalQuickFix[] fixes = this.createFixes(method);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        GrExpression invoked = method.getInvokedExpression();
        PsiElement nameElement = ((GrReferenceExpression)invoked).getReferenceNameElement();
        assert (nameElement != null);
        this.registerError(nameElement, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerError(@NotNull PsiElement location, @NotNull String description, LocalQuickFix @Nullable [] fixes, ProblemHighlightType highlightType) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(0);
        }
        if (description == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(1);
        }
        this.problemsHolder.registerProblem(location, description, highlightType, fixes);
    }

    protected void registerError(@NotNull PsiElement location, Object ... args) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(2);
        }
        this.registerError(location, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, args);
    }

    protected void registerError(@NotNull PsiElement location, ProblemHighlightType highlightType, Object ... args) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(3);
        }
        LocalQuickFix[] fix = this.createFixes(location);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(location, description, fix, highlightType);
    }

    private LocalQuickFix @Nullable [] createFixes(@NotNull PsiElement location) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(4);
        }
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            return null;
        }
        GroovyFix fix = this.inspection.buildFix(location);
        if (fix == null) {
            return null;
        }
        return new GroovyFix[]{fix};
    }

    public int getErrorCount() {
        return this.problemsHolder.getResultCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerError";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createFixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

