/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.SuppressByGroovyCommentFix;
import org.jetbrains.plugins.groovy.codeInspection.SuppressForMemberFix;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GroovySuppressableInspectionTool
extends LocalInspectionTool {
    public static SuppressQuickFix @NotNull [] getSuppressActions(@NotNull String toolId) {
        if (toolId == null) {
            GroovySuppressableInspectionTool.$$$reportNull$$$0(0);
        }
        if ("GroovyUnusedDeclaration".equals(toolId)) {
            toolId = "unused";
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SuppressByGroovyCommentFix(toolId), new SuppressForMemberFix(toolId, false), new SuppressForMemberFix(toolId, true)};
        if (suppressQuickFixArray == null) {
            GroovySuppressableInspectionTool.$$$reportNull$$$0(1);
        }
        return suppressQuickFixArray;
    }

    public static boolean isElementToolSuppressedIn(PsiElement place, @NotNull String toolId) {
        if (toolId == null) {
            GroovySuppressableInspectionTool.$$$reportNull$$$0(2);
        }
        return GroovySuppressableInspectionTool.getElementToolSuppressedIn(place, toolId) != null;
    }

    @Nullable
    public static PsiElement getElementToolSuppressedIn(PsiElement place, @NotNull String toolId) {
        PsiElement forUnused;
        if (toolId == null) {
            GroovySuppressableInspectionTool.$$$reportNull$$$0(3);
        }
        if (place == null) {
            return null;
        }
        if ("GroovyUnusedDeclaration".equals(toolId) && (forUnused = GroovySuppressableInspectionTool.getElementToolSuppressedIn(place, "unused")) != null) {
            return forUnused;
        }
        return (PsiElement)ReadAction.compute(() -> {
            GrDocCommentOwner owner;
            GrStatement statement = PsiUtil.findEnclosingStatement(place);
            if (statement != null) {
                String text;
                Matcher matcher;
                PsiElement prev;
                for (prev = statement.getPrevSibling(); prev != null && StringUtil.isEmpty((String)prev.getText().trim()); prev = prev.getPrevSibling()) {
                }
                if (prev instanceof PsiComment && (matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text = prev.getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId)) {
                    return prev;
                }
            }
            GrMember member = null;
            GrDocComment docComment = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)place, GrDocComment.class);
            if (docComment != null && (owner = docComment.getOwner()) instanceof GrMember) {
                member = (GrMember)((Object)owner);
            }
            if (member == null) {
                member = (GrMember)PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{GrMember.class});
            }
            while (member != null) {
                GrModifierList modifierList = member.getModifierList();
                for (String ids : GroovySuppressableInspectionTool.getInspectionIdsSuppressedInAnnotation(modifierList)) {
                    if (!SuppressionUtil.isInspectionToolIdMentioned((String)ids, (String)toolId)) continue;
                    return modifierList;
                }
                member = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)member, GrMember.class);
            }
            return null;
        });
    }

    @NotNull
    private static Collection<String> getInspectionIdsSuppressedInAnnotation(GrModifierList modifierList) {
        if (modifierList == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GroovySuppressableInspectionTool.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiAnnotation annotation = modifierList.findAnnotation("java.lang.SuppressWarnings");
        if (annotation == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GroovySuppressableInspectionTool.$$$reportNull$$$0(5);
            }
            return list;
        }
        GrAnnotationMemberValue attributeValue = (GrAnnotationMemberValue)annotation.findAttributeValue(null);
        ArrayList<String> result2 = new ArrayList<String>();
        if (attributeValue instanceof GrAnnotationArrayInitializer) {
            for (GrAnnotationMemberValue annotationMemberValue : ((GrAnnotationArrayInitializer)attributeValue).getInitializers()) {
                String id = GroovySuppressableInspectionTool.getInspectionIdSuppressedInAnnotationAttribute(annotationMemberValue);
                if (id == null) continue;
                result2.add(id);
            }
        } else {
            String id = GroovySuppressableInspectionTool.getInspectionIdSuppressedInAnnotationAttribute(attributeValue);
            if (id != null) {
                result2.add(id);
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            GroovySuppressableInspectionTool.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    private static String getInspectionIdSuppressedInAnnotationAttribute(GrAnnotationMemberValue element) {
        Object value;
        if (element instanceof GrLiteral && (value = ((GrLiteral)element).getValue()) instanceof String) {
            return (String)value;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/GroovySuppressableInspectionTool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/GroovySuppressableInspectionTool";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionIdsSuppressedInAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isElementToolSuppressedIn";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementToolSuppressedIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

