/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformations;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class ChangeToOperatorInspection
extends BaseInspection {
    public boolean useDoubleNegation = true;
    public boolean shouldChangeCompareToEqualityToEquals = true;
    public boolean withoutAdditionalParentheses = false;

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCall) {
                GrExpression invokedExpression;
                if (methodCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((invokedExpression = methodCall.getInvokedExpression()) instanceof GrReferenceExpression)) {
                    return;
                }
                GrReferenceExpression referenceExpression = (GrReferenceExpression)invokedExpression;
                if (referenceExpression.getDotTokenType() != GroovyTokenTypes.mDOT) {
                    return;
                }
                PsiElement highlightElement = referenceExpression.getReferenceNameElement();
                if (highlightElement == null) {
                    return;
                }
                String methodName = ChangeToOperatorInspection.this.getMethodName(methodCall);
                if (methodName == null) {
                    return;
                }
                Transformation transformation = Transformations.TRANSFORMATIONS.get(methodName);
                if (transformation == null) {
                    return;
                }
                if (transformation.couldApply(methodCall, ChangeToOperatorInspection.this.getOptions())) {
                    this.registerError(highlightElement, GroovyInspectionBundle.message("replace.with.operator.message", methodName), new LocalQuickFix[]{ChangeToOperatorInspection.this.getFix(transformation, methodName)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    @Nullable
    protected GroovyFix getFix(final @NotNull Transformation transformation, final @NotNull String methodName) {
        if (transformation == null) {
            ChangeToOperatorInspection.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            ChangeToOperatorInspection.$$$reportNull$$$0(1);
        }
        return new GroovyFix(){

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = GroovyInspectionBundle.message("replace.with.operator.fix", methodName);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
                PsiElement call;
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((call = descriptor2.getPsiElement().getParent()) == null) {
                    return;
                }
                if (!((call = call.getParent()) instanceof GrMethodCall)) {
                    return;
                }
                GrMethodCall methodCall = (GrMethodCall)call;
                GrExpression invokedExpression = methodCall.getInvokedExpression();
                if (!(invokedExpression instanceof GrReferenceExpression)) {
                    return;
                }
                Options options2 = ChangeToOperatorInspection.this.getOptions();
                if (!transformation.couldApply(methodCall, options2)) {
                    return;
                }
                transformation.apply(methodCall, options2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "doFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Nullable
    public String getMethodName(@NotNull GrMethodCall methodCall) {
        PsiMethod method;
        if (methodCall == null) {
            ChangeToOperatorInspection.$$$reportNull$$$0(2);
        }
        if ((method = methodCall.resolveMethod()) == null || method.hasModifierProperty("static")) {
            return null;
        }
        return method.getName();
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("replace.with.operator.double.negation.option", new Object[0]), "useDoubleNegation");
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("replace.with.operator.compareTo.equality.option", new Object[0]), "shouldChangeCompareToEqualityToEquals");
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("replace.with.operator.parentheses", new Object[0]), "withoutAdditionalParentheses");
        return optionsPanel;
    }

    private Options getOptions() {
        return new Options(this.useDoubleNegation, this.shouldChangeCompareToEqualityToEquals, this.withoutAdditionalParentheses);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Options {
        private final boolean useDoubleNegation;
        private final boolean shouldChangeCompareToEqualityToEquals;
        private final boolean withoutAdditionalParentheses;

        public Options(boolean useDoubleNegation, boolean shouldChangeCompareToEqualityToEquals, boolean withoutAdditionalParentheses) {
            this.useDoubleNegation = useDoubleNegation;
            this.shouldChangeCompareToEqualityToEquals = shouldChangeCompareToEqualityToEquals;
            this.withoutAdditionalParentheses = withoutAdditionalParentheses;
        }

        public boolean useDoubleNegation() {
            return this.useDoubleNegation;
        }

        public boolean shouldChangeCompareToEqualityToEquals() {
            return this.shouldChangeCompareToEqualityToEquals;
        }

        public boolean withoutAdditionalParentheses() {
            return this.withoutAdditionalParentheses;
        }
    }
}

