/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;

public class GroovySwitchStatementWithNoDefaultInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "#ref statement with no default branch#loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
            GrCaseSection[] caseSections;
            if (switchStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(switchStatement);
            for (GrCaseSection caseSection : caseSections = switchStatement.getCaseSections()) {
                if (!caseSection.isDefault()) continue;
                return;
            }
            this.registerError(switchStatement.getFirstChild());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovySwitchStatementWithNoDefaultInspection$Visitor", "visitSwitchStatement"));
        }
    }
}

