/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control.finalVar;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.control.finalVar.InvalidWriteAccessSearcher;
import org.jetbrains.plugins.groovy.codeInspection.control.finalVar.VariableInitializationChecker;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrFieldControlFlowPolicy;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ResolvedVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;

public class GrFinalVariableAccessInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitMethod(@NotNull GrMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethod(method);
                GrOpenBlock block = method.getBlock();
                if (block != null) {
                    this.processLocalVars(block);
                }
                if (method.isConstructor()) {
                    this.processFieldsInConstructors(method);
                }
            }

            @Override
            public void visitFile(@NotNull GroovyFileBase file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitFile(file);
                if (file instanceof GroovyFile && file.isScript()) {
                    this.processLocalVars(file);
                }
            }

            @Override
            public void visitField(@NotNull GrField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitField(field);
                GrExpression initializer = field.getInitializerGroovy();
                if (initializer != null) {
                    this.processLocalVars(initializer);
                }
                if (field.hasModifierProperty("final") && !GrFinalVariableAccessInspection.isFieldInitialized(field)) {
                    this.registerError(field.getNameIdentifierGroovy(), GroovyBundle.message("variable.0.might.not.have.been.initialized", field.getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression ref) {
                if (ref == null) {
                    1.$$$reportNull$$$0(3);
                }
                super.visitReferenceExpression(ref);
                PsiElement resolved = ref.resolve();
                if (resolved instanceof GrField && ((GrField)resolved).hasModifierProperty("final")) {
                    GrField field = (GrField)resolved;
                    PsiClass containingClass = field.getContainingClass();
                    if (PsiUtil.isLValue(ref)) {
                        if (containingClass == null || !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)ref, (boolean)true)) {
                            this.registerError((PsiElement)ref, GroovyBundle.message("cannot.assign.a.value.to.final.field.0", field.getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                        }
                    } else if (PsiUtil.isUsedInIncOrDec(ref) && (containingClass == null || !GrFinalVariableAccessInspection.isInsideConstructorOrInitializer(containingClass, ref, field.hasModifierProperty("static")))) {
                        this.registerError((PsiElement)ref, GroovyBundle.message("cannot.assign.a.value.to.final.field.0", field.getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    }
                } else if (resolved instanceof GrParameter && ((GrParameter)resolved).getDeclarationScope() instanceof GrMethod && ((GrParameter)resolved).hasModifierProperty("final") && PsiUtil.isUsedInIncOrDec(ref)) {
                    this.registerError((PsiElement)ref, GroovyBundle.message("cannot.assign.a.value.to.final.parameter.0", ((GrParameter)resolved).getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            @Override
            public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
                if (initializer == null) {
                    1.$$$reportNull$$$0(4);
                }
                super.visitClassInitializer(initializer);
                this.processLocalVars(initializer.getBlock());
                this.processFieldsInClassInitializer(initializer);
            }

            private void processFieldsInConstructors(@NotNull GrMethod constructor) {
                GrOpenBlock block;
                if (constructor == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((block = constructor.getBlock()) == null) {
                    return;
                }
                GrTypeDefinition clazz = (GrTypeDefinition)constructor.getContainingClass();
                if (clazz == null) {
                    return;
                }
                GrClassInitializer[] initializers = clazz.getInitializers();
                List fields = GrFinalVariableAccessInspection.getFinalFields(clazz);
                HashSet<GrVariable> initializedFields = new HashSet<GrVariable>();
                GrFinalVariableAccessInspection.appendFieldInitializedInDeclaration(false, fields, initializedFields);
                GrFinalVariableAccessInspection.appendFieldsInitializedInClassInitializer(initializers, null, false, fields, initializedFields);
                GrFinalVariableAccessInspection.appendInitializationFromChainedConstructors(constructor, fields, initializedFields);
                Instruction[] flow = GrFinalVariableAccessInspection.buildFlowForField(block);
                Set variables = GrFinalVariableAccessInspection.buildVarSet(fields, false);
                this.highlightInvalidWriteAccess(flow, variables, initializedFields);
            }

            private void processFieldsInClassInitializer(@NotNull GrClassInitializer initializer) {
                GrTypeDefinition clazz;
                if (initializer == null) {
                    1.$$$reportNull$$$0(6);
                }
                if ((clazz = (GrTypeDefinition)initializer.getContainingClass()) == null) {
                    return;
                }
                boolean isStatic = initializer.isStatic();
                GrClassInitializer[] initializers = clazz.getInitializers();
                List fields = GrFinalVariableAccessInspection.getFinalFields(clazz);
                HashSet<GrVariable> initializedFields = new HashSet<GrVariable>();
                GrFinalVariableAccessInspection.appendFieldInitializedInDeclaration(isStatic, fields, initializedFields);
                GrFinalVariableAccessInspection.appendFieldsInitializedInClassInitializer(initializers, initializer, isStatic, fields, initializedFields);
                Instruction[] flow = GrFinalVariableAccessInspection.buildFlowForField(initializer.getBlock());
                Set variables = GrFinalVariableAccessInspection.buildVarSet(fields, isStatic);
                this.highlightInvalidWriteAccess(flow, variables, initializedFields);
            }

            private void processLocalVars(@NotNull GroovyPsiElement scope) {
                if (scope == null) {
                    1.$$$reportNull$$$0(7);
                }
                MultiMap scopes = GrFinalVariableAccessInspection.collectVariables(scope);
                for (Map.Entry entry : scopes.entrySet()) {
                    PsiElement scopeToProcess = (PsiElement)entry.getKey();
                    HashSet<GrVariable> forInParameters = new HashSet<GrVariable>();
                    HashSet<GrVariable> variables = new HashSet<GrVariable>();
                    for (GrVariable var : (Collection)entry.getValue()) {
                        variables.add(var);
                        if (!(var instanceof GrParameter) || !(((GrParameter)var).getDeclarationScope() instanceof GrForStatement)) continue;
                        forInParameters.add(var);
                    }
                    Instruction[] flow = GrFinalVariableAccessInspection.getFlow(scopeToProcess);
                    this.highlightInvalidWriteAccess(flow, variables, forInParameters);
                }
            }

            private void highlightInvalidWriteAccess(Instruction @NotNull [] flow, @NotNull Set<GrVariable> variables, @NotNull Set<GrVariable> initializedVariables) {
                List<ReadWriteVariableInstruction> result2;
                if (variables == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (initializedVariables == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (flow == null) {
                    1.$$$reportNull$$$0(10);
                }
                if ((result2 = InvalidWriteAccessSearcher.findInvalidWriteAccess(flow, variables, initializedVariables)) == null) {
                    return;
                }
                for (ReadWriteVariableInstruction instruction : result2) {
                    VariableDescriptor descriptor2 = instruction.getDescriptor();
                    if (!(descriptor2 instanceof ResolvedVariableDescriptor)) continue;
                    PsiElement element = instruction.getElement();
                    if (!variables.contains(((ResolvedVariableDescriptor)descriptor2).getVariable()) || element == null) continue;
                    this.registerError(element, GroovyBundle.message("cannot.assign.a.value.to.final.field.0", descriptor2), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ref";
                        break;
                    }
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializer";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "constructor";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variables";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializedVariables";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flow";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassInitializer";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFieldsInConstructors";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFieldsInClassInitializer";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processLocalVars";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "highlightInvalidWriteAccess";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isInsideConstructorOrInitializer(@NotNull PsiClass containingClass, @NotNull GrReferenceExpression place, boolean isStatic) {
        if (containingClass == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(0);
        }
        if (place == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(1);
        }
        GrControlFlowOwner container = ControlFlowUtils.findControlFlowOwner(place);
        PsiClass aClass = null;
        if (!isStatic && container instanceof GrMethod && ((GrMethod)((Object)container)).isConstructor()) {
            aClass = ((GrMethod)((Object)container)).getContainingClass();
        } else if (container instanceof GrClassInitializer && ((GrClassInitializer)((Object)container)).isStatic() == isStatic) {
            aClass = ((GrClassInitializer)((Object)container)).getContainingClass();
        }
        return aClass != null && containingClass.getManager().areElementsEquivalent(aClass, (PsiElement)containingClass);
    }

    @NotNull
    private static List<GrField> getFinalFields(@NotNull GrTypeDefinition clazz) {
        if (clazz == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(2);
        }
        Object[] fields = clazz.getCodeFields();
        List list = ContainerUtil.filter((Object[])fields, field -> {
            GrModifierList list = field.getModifierList();
            return list != null && list.hasModifierProperty("final");
        });
        if (list == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static void appendFieldInitializedInDeclaration(boolean isStatic, @NotNull List<? extends GrField> fields, @NotNull Set<? super GrVariable> initializedFields) {
        if (fields == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(4);
        }
        if (initializedFields == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(5);
        }
        for (GrField grField : fields) {
            if (grField.hasModifierProperty("static") != isStatic || grField.getInitializerGroovy() == null) continue;
            initializedFields.add(grField);
        }
    }

    private static void appendFieldsInitializedInClassInitializer(GrClassInitializer @NotNull [] initializers, @Nullable GrClassInitializer initializerToStop, boolean isStatic, @NotNull List<? extends GrField> fields, @NotNull Set<? super GrVariable> initializedFields) {
        if (fields == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(6);
        }
        if (initializedFields == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(7);
        }
        if (initializers == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(8);
        }
        for (GrClassInitializer curInit : initializers) {
            if (curInit.isStatic() != isStatic) continue;
            if (curInit == initializerToStop) break;
            GrOpenBlock block = curInit.getBlock();
            Instruction[] flow = GrFinalVariableAccessInspection.buildFlowForField(block);
            for (GrField grField : fields) {
                if (grField.hasModifierProperty("static") != isStatic || initializedFields.contains(grField) || !VariableInitializationChecker.isVariableDefinitelyInitializedCached(grField, block, flow)) continue;
                initializedFields.add(grField);
            }
        }
    }

    private static void appendInitializationFromChainedConstructors(@NotNull GrMethod constructor, @NotNull List<? extends GrField> fields, @NotNull Set<? super GrVariable> initializedFields) {
        if (constructor == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(9);
        }
        if (fields == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(10);
        }
        if (initializedFields == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(11);
        }
        List<GrMethod> chained = GrFinalVariableAccessInspection.getChainedConstructors(constructor);
        chained.remove(0);
        for (GrMethod method : chained) {
            GrOpenBlock block = method.getBlock();
            if (block == null) continue;
            Instruction[] flow = GrFinalVariableAccessInspection.buildFlowForField(block);
            for (GrField grField : fields) {
                if (grField.hasModifierProperty("static") || initializedFields.contains(grField) || !VariableInitializationChecker.isVariableDefinitelyInitializedCached(grField, block, flow)) continue;
                initializedFields.add(grField);
            }
        }
    }

    @NotNull
    private static Set<GrVariable> buildVarSet(@NotNull List<? extends GrField> fields, boolean isStatic) {
        if (fields == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(12);
        }
        HashSet<GrVariable> result2 = new HashSet<GrVariable>();
        for (GrField grField : fields) {
            if (grField.hasModifierProperty("static") != isStatic) continue;
            result2.add(grField);
        }
        HashSet<GrVariable> hashSet = result2;
        if (hashSet == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    private static boolean isFieldInitialized(@NotNull GrField field) {
        GrClassInitializer[] initializers;
        if (field == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(14);
        }
        if (field instanceof GrEnumConstant) {
            return true;
        }
        if (field.getInitializerGroovy() != null) {
            return true;
        }
        if (GrFinalVariableAccessInspection.isImmutableField(field)) {
            return true;
        }
        boolean isStatic = field.hasModifierProperty("static");
        GrTypeDefinition aClass = (GrTypeDefinition)field.getContainingClass();
        if (aClass == null) {
            return true;
        }
        for (GrClassInitializer initializer : initializers = aClass.getInitializers()) {
            Instruction[] initializerFlow;
            GrOpenBlock block;
            if (initializer.isStatic() != isStatic || !VariableInitializationChecker.isVariableDefinitelyInitializedCached(field, block = initializer.getBlock(), initializerFlow = GrFinalVariableAccessInspection.buildFlowForField(block))) continue;
            return true;
        }
        if (isStatic) {
            return false;
        }
        GrMethod[] constructors = aClass.getCodeConstructors();
        if (constructors.length == 0) {
            return false;
        }
        HashSet<GrMethod> initializedConstructors = new HashSet<GrMethod>();
        HashSet<GrMethod> notInitializedConstructors = new HashSet<GrMethod>();
        block1: for (GrMethod constructor : constructors) {
            if (constructor.getBlock() == null) {
                return false;
            }
            List<GrMethod> chained = GrFinalVariableAccessInspection.getChainedConstructors(constructor);
            for (GrMethod method : chained) {
                if (initializedConstructors.contains(method)) continue block1;
                if (notInitializedConstructors.contains(method)) continue;
                GrOpenBlock block = method.getBlock();
                assert (block != null);
                boolean initialized = VariableInitializationChecker.isVariableDefinitelyInitializedCached(field, block, GrFinalVariableAccessInspection.buildFlowForField(block));
                if (initialized) {
                    initializedConstructors.add(method);
                    continue block1;
                }
                notInitializedConstructors.add(method);
            }
            return false;
        }
        return true;
    }

    private static boolean isImmutableField(@NotNull GrField field) {
        GrModifierList fieldModifierList;
        if (field == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(15);
        }
        if ((fieldModifierList = field.getModifierList()) != null && fieldModifierList.hasExplicitVisibilityModifiers()) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return false;
        }
        return GrImmutableUtils.hasImmutableAnnotation((PsiModifierListOwner)aClass);
    }

    @NotNull
    private static List<GrMethod> getChainedConstructors(@NotNull GrMethod constructor) {
        PsiMethod method;
        GrConstructorInvocation invocation;
        if (constructor == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(16);
        }
        HashSet<PsiMethod> visited = new HashSet<PsiMethod>();
        ArrayList result2 = ContainerUtil.newArrayList((Object[])new GrMethod[]{constructor});
        while ((invocation = PsiUtil.getConstructorInvocation(constructor)) != null && invocation.isThisCall() && (method = invocation.resolveMethod()) != null && method.isConstructor() && visited.add(method)) {
            result2.add((GrMethod)method);
            constructor = (GrMethod)method;
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static Instruction @NotNull [] buildFlowForField(@NotNull GrOpenBlock block) {
        if (block == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(18);
        }
        Instruction[] instructionArray = new ControlFlowBuilder(GrFieldControlFlowPolicy.getInstance()).buildControlFlow(block);
        if (instructionArray == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(19);
        }
        return instructionArray;
    }

    @NotNull
    private static MultiMap<PsiElement, GrVariable> collectVariables(@NotNull GroovyPsiElement scope) {
        if (scope == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(20);
        }
        final MultiMap scopes = MultiMap.create();
        scope.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitVariable(@NotNull GrVariable variable) {
                PsiElement varScope;
                if (variable == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitVariable(variable);
                if (!(variable instanceof PsiField) && variable.hasModifierProperty("final") && (varScope = GrFinalVariableAccessInspection.findScope(variable)) != null) {
                    scopes.putValue((Object)varScope, (Object)variable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection$2", "visitVariable"));
            }
        });
        MultiMap multiMap = scopes;
        if (multiMap == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(21);
        }
        return multiMap;
    }

    private static Instruction @NotNull [] getFlow(@NotNull PsiElement element) {
        if (element == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(22);
        }
        Instruction[] instructionArray = element instanceof GrControlFlowOwner ? ((GrControlFlowOwner)element).getControlFlow() : new ControlFlowBuilder().buildControlFlow((GroovyPsiElement)element);
        if (instructionArray == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(23);
        }
        return instructionArray;
    }

    @Nullable
    private static PsiElement findScope(@NotNull GrVariable variable) {
        GrStatement body;
        GroovyPsiElement result2;
        if (variable == null) {
            GrFinalVariableAccessInspection.$$$reportNull$$$0(24);
        }
        if ((result2 = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{GrControlStatement.class, GrControlFlowOwner.class})) instanceof GrForStatement && (body = ((GrForStatement)result2).getBody()) != null) {
            result2 = body;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializedFields";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializers";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalFields";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVarSet";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChainedConstructors";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFlowForField";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVariables";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsideConstructorOrInitializer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFinalFields";
                break;
            }
            case 3: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendFieldInitializedInDeclaration";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendFieldsInitializedInClassInitializer";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendInitializationFromChainedConstructors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildVarSet";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitialized";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isImmutableField";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChainedConstructors";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildFlowForField";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectVariables";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFlow";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

