/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.ConstructorCallHighlighter;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;
import org.jetbrains.plugins.groovy.lang.typing.GrCollectionConstructorConverter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/LiteralConstructorReferenceHighlighter;", "Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/ConstructorCallHighlighter;", "reference", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyConstructorReference;", "highlightElement", "Lcom/intellij/psi/PsiElement;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "(Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyConstructorReference;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "getHighlightElement", "()Lcom/intellij/psi/PsiElement;", "highlightMethodApplicability", "", "shouldHighlightInapplicable", "intellij.groovy.psi"})
public final class LiteralConstructorReferenceHighlighter
extends ConstructorCallHighlighter {
    @NotNull
    private final PsiElement highlightElement;

    @Override
    protected boolean shouldHighlightInapplicable() {
        PsiClass clazz;
        GroovyCallReference groovyCallReference = this.getReference();
        if (groovyCallReference == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference");
        }
        GroovyResolveResult groovyResolveResult = ((GroovyConstructorReference)groovyCallReference).resolveClass();
        Object object = groovyResolveResult != null ? groovyResolveResult.getElement() : null;
        if (!(object instanceof PsiClass)) {
            object = null;
        }
        return (clazz = (PsiClass)object) == null || !GrCollectionConstructorConverter.Companion.hasCollectionApplicableConstructor(clazz, this.getHighlightElement());
    }

    @Override
    public boolean highlightMethodApplicability() {
        Collection<? extends GroovyResolveResult> collection = this.getReference().resolve(false);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"reference.resolve(false)");
        Collection<? extends GroovyResolveResult> results = collection;
        if (results.isEmpty()) {
            PsiClass clazz;
            GroovyCallReference groovyCallReference = this.getReference();
            if (groovyCallReference == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference");
            }
            GroovyResolveResult groovyResolveResult = ((GroovyConstructorReference)groovyCallReference).resolveClass();
            Object object = groovyResolveResult != null ? groovyResolveResult.getElement() : null;
            if (!(object instanceof PsiClass)) {
                object = null;
            }
            if ((clazz = (PsiClass)object) == null) {
                return false;
            }
            this.getSink().registerError(this.getHighlightElement(), GroovyBundle.message("cannot.instantiate.interface", clazz.getName()), new LocalQuickFix[0]);
            return true;
        }
        return super.highlightMethodApplicability();
    }

    @Override
    @NotNull
    protected PsiElement getHighlightElement() {
        return this.highlightElement;
    }

    public LiteralConstructorReferenceHighlighter(@NotNull GroovyConstructorReference reference, @NotNull PsiElement highlightElement, @NotNull HighlightSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)highlightElement, (String)"highlightElement");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        super(reference, sink);
        this.highlightElement = highlightElement;
    }
}

