/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class ScriptTypeFilter
implements ContextFilter {
    private final String myScriptType;

    public ScriptTypeFilter(String scriptType) {
        this.myScriptType = scriptType;
    }

    @Override
    public boolean isApplicable(GroovyClassDescriptor descriptor2, ProcessingContext ctx) {
        PsiFile file = descriptor2.getPlaceFile();
        if (file instanceof GroovyFile && ((GroovyFile)file).isScript()) {
            return this.myScriptType.contains(ScriptTypeFilter.getScriptTypeId((GroovyFile)file));
        }
        return false;
    }

    @NotNull
    private static String getScriptTypeId(@NotNull GroovyFile script) {
        GroovyScriptType scriptType;
        if (script == null) {
            ScriptTypeFilter.$$$reportNull$$$0(0);
        }
        String string = (scriptType = GroovyScriptTypeDetector.getScriptType(script)) == null ? "default" : scriptType.getId();
        if (string == null) {
            ScriptTypeFilter.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/dsl/toplevel/ScriptTypeFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/dsl/toplevel/ScriptTypeFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptTypeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScriptTypeId";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

