/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ide;

import com.intellij.execution.Executor;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import groovy.lang.Binding;
import groovy.lang.GroovySystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.groovy.tools.shell.Interpreter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.ide.MyConsoleRootType;
import org.jetbrains.plugins.groovy.ide.ScriptingKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000%\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000*\u0001\u0006\u001a\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"TITLE", "", "defaultImportStatements", "", "defaultImports", "createExecuteHandler", "org/jetbrains/plugins/groovy/ide/ScriptingKt$createExecuteHandler$1", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Lorg/jetbrains/plugins/groovy/ide/ScriptingKt$createExecuteHandler$1;", "initConsole", "", "intellij.groovy"})
public final class ScriptingKt {
    private static final String TITLE = "Groovy IDE Scripting Shell";
    private static final List<String> defaultImports;
    private static final List<String> defaultImportStatements;

    private static final void initConsole(Project project) {
        LanguageConsoleImpl console = new LanguageConsoleImpl(project, TITLE, (Language)GroovyLanguage.INSTANCE);
        ConsoleExecuteAction action = new ConsoleExecuteAction((LanguageConsoleView)console, (BaseConsoleExecuteActionHandler)ScriptingKt.createExecuteHandler(project));
        ShortcutSet shortcutSet = action.getShortcutSet();
        EditorEx editorEx = console.getConsoleEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"console.consoleEditor");
        action.registerCustomShortcutSet(shortcutSet, editorEx.getComponent());
        new ConsoleHistoryController((ConsoleRootType)MyConsoleRootType.INSTANCE, null, (LanguageConsoleView)console).install();
        JComponent jComponent = console.getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"console.component");
        JComponent consoleComponent = jComponent;
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("GroovyScriptingConsole", (ActionGroup)toolbarActions, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026\", toolbarActions, false)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(consoleComponent);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)consoleComponent, "Center");
        panel.add((Component)toolbar.getComponent(), "West");
        RunContentDescriptor descriptor2 = new RunContentDescriptor(console, panel, (ExecutionConsole)console, null, panel, TITLE){
            final /* synthetic */ LanguageConsoleImpl $console;
            final /* synthetic */ JPanel $panel;

            public boolean isContentReuseProhibited() {
                return true;
            }
            {
                this.$console = $captured_local_variable$0;
                this.$panel = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
        AnAction[] anActionArray = console.createConsoleActions();
        toolbarActions.addAll(Arrays.copyOf(anActionArray, anActionArray.length));
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor2, project));
        RunContentManager.getInstance((Project)project).showRunContent(executor, descriptor2);
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        ApplicationNamesInfo namesInfo = applicationNamesInfo;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yy HH:ss", Locale.US);
        ApplicationInfo applicationInfo = appInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"appInfo");
        Calendar calendar = applicationInfo.getBuildDate();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"appInfo.buildDate");
        String buildDate = simpleDateFormat.format(calendar.getTime());
        console.print("Welcome!\n" + namesInfo.getFullProductName() + " (build #" + appInfo.getBuild() + ", " + buildDate + "); Groovy: " + GroovySystem.getVersion() + '\n', ConsoleViewContentType.SYSTEM_OUTPUT);
        console.print("'application', 'project', 'facade' and 'allScope' variables are available at the top level. \n", ConsoleViewContentType.SYSTEM_OUTPUT);
        console.print("Default imports:\n" + CollectionsKt.joinToString$default((Iterable)defaultImports, (CharSequence)",\n", null, null, (int)0, null, (Function1)initConsole.1.INSTANCE, (int)30, null) + "\n\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    private static final createExecuteHandler.1 createExecuteHandler(Project project) {
        return new BaseConsoleExecuteActionHandler(project, false){
            @NotNull
            private final Lazy interpreter$delegate;
            final /* synthetic */ Project $project;

            @NotNull
            public final Interpreter getInterpreter() {
                Lazy lazy = this.interpreter$delegate;
                createExecuteHandler.1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return (Interpreter)lazy.getValue();
            }

            protected void execute(@NotNull String text, @NotNull LanguageConsoleView console) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)console, (String)"console");
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, text, console){
                    final /* synthetic */ createExecuteHandler.1 this$0;
                    final /* synthetic */ String $text;
                    final /* synthetic */ LanguageConsoleView $console;

                    public final void run() {
                        boolean $i$f$runReadAction = false;
                        ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this){
                            final /* synthetic */ createExecuteHandler.execute.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final T compute() {
                                boolean bl = false;
                                try {
                                    Object result2 = this.this$0.this$0.getInterpreter().evaluate((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ScriptingKt.access$getDefaultImportStatements$p(), (Object)""), (Object)""), (Object)this.this$0.$text));
                                    this.this$0.$console.print("Returned: ", ConsoleViewContentType.SYSTEM_OUTPUT);
                                    this.this$0.$console.print("" + result2 + '\n', ConsoleViewContentType.NORMAL_OUTPUT);
                                }
                                catch (Throwable e) {
                                    StringWriter errors = new StringWriter();
                                    e.printStackTrace(new PrintWriter(errors));
                                    this.this$0.$console.print("Error: " + errors, ConsoleViewContentType.ERROR_OUTPUT);
                                }
                                return (T)Unit.INSTANCE;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$text = string;
                        this.$console = languageConsoleView;
                    }
                });
            }
            {
                this.$project = $captured_local_variable$0;
                super($super_call_param$1);
                this.interpreter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Interpreter>(this){
                    final /* synthetic */ createExecuteHandler.1 this$0;

                    @NotNull
                    public final Interpreter invoke() {
                        Binding binding = new Binding(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"application", (Object)ApplicationManager.getApplication()), TuplesKt.to((Object)"project", (Object)this.this$0.$project), TuplesKt.to((Object)"facade", (Object)JavaPsiFacade.getInstance((Project)this.this$0.$project)), TuplesKt.to((Object)"allScope", (Object)GlobalSearchScope.allScope((Project)this.this$0.$project))}));
                        return new Interpreter(Interpreter.class.getClassLoader(), binding);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        defaultImports = CollectionsKt.listOf((Object[])new String[]{"com.intellij.openapi.application.*", "com.intellij.openapi.project.*", "com.intellij.openapi.module.*", "com.intellij.openapi.vfs.*", "com.intellij.psi.*", "com.intellij.psi.search.*", "com.intellij.psi.stubs.*", "com.intellij.util.indexing.*"});
        Iterable $this$map$iv = defaultImports;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = "import " + (String)it;
            collection.add(string2);
        }
        defaultImportStatements = (List)var3_3;
    }

    public static final /* synthetic */ void access$initConsole(Project project) {
        ScriptingKt.initConsole(project);
    }

    public static final /* synthetic */ List access$getDefaultImportStatements$p() {
        return defaultImportStatements;
    }
}

