/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyPresentationUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.SignaturesKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;

public class ConvertClosureToMethodIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(ConvertClosureToMethodIntention.class);

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new MyPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrAccessorMethod[] getters;
        PsiElement parent2;
        if (element == null) {
            ConvertClosureToMethodIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ConvertClosureToMethodIntention.$$$reportNull$$$0(1);
        }
        if (!((parent2 = element.getParent()) instanceof GrField)) {
            return;
        }
        GrField field = (GrField)parent2;
        HashSet usages = new HashSet();
        usages.addAll(ReferencesSearch.search((PsiElement)field).findAll());
        for (GrAccessorMethod getter : getters = field.getGetters()) {
            usages.addAll(MethodReferencesSearch.search((PsiMethod)getter).findAll());
        }
        GrAccessorMethod setter = field.getSetter();
        if (setter != null) {
            usages.addAll(MethodReferencesSearch.search((PsiMethod)setter).findAll());
        }
        String fieldName = field.getName();
        HashSet<PsiElement> fieldUsages = new HashSet<PsiElement>();
        MultiMap conflicts = new MultiMap();
        for (PsiReference usage : usages) {
            PsiElement psiElement = usage.getElement();
            if (PsiUtil.isMethodUsage(psiElement)) continue;
            if (!((Object)((Object)GroovyLanguage.INSTANCE)).equals(psiElement.getLanguage())) {
                conflicts.putValue((Object)psiElement, (Object)GroovyIntentionsBundle.message("closure.is.accessed.outside.of.groovy", fieldName));
                continue;
            }
            if (psiElement instanceof GrReferenceExpression) {
                fieldUsages.add(psiElement);
                if (!PsiUtil.isAccessedForWriting((GrExpression)psiElement)) continue;
                conflicts.putValue((Object)psiElement, (Object)GroovyIntentionsBundle.message("write.access.to.closure.variable", fieldName));
                continue;
            }
            if (!(psiElement instanceof GrArgumentLabel)) continue;
            conflicts.putValue((Object)psiElement, (Object)GroovyIntentionsBundle.message("field.is.used.in.argument.label", fieldName));
        }
        PsiClass containingClass = field.getContainingClass();
        GrExpression initializer = field.getInitializerGroovy();
        LOG.assertTrue(initializer != null);
        PsiType type2 = initializer.getType();
        LOG.assertTrue(type2 instanceof GroovyClosureType);
        List<MethodSignature> signatures2 = SignaturesKt.generateAllMethodSignaturesBySignature(fieldName, ((GroovyClosureType)type2).getSignatures());
        for (MethodSignature s : signatures2) {
            PsiMethod method = MethodSignatureUtil.findMethodBySignature((PsiClass)containingClass, (MethodSignature)s, (boolean)true);
            if (method == null) continue;
            conflicts.putValue((Object)method, (Object)GroovyIntentionsBundle.message("method.with.signature.already.exists", GroovyPresentationUtil.getSignaturePresentation(s)));
        }
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts, () -> ConvertClosureToMethodIntention.execute(field, fieldUsages));
            conflictsDialog.show();
            if (conflictsDialog.getExitCode() != 0) {
                return;
            }
        }
        ConvertClosureToMethodIntention.execute(field, fieldUsages);
    }

    private static void execute(GrField field, Collection<PsiElement> fieldUsages) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(field.getProject());
        StringBuilder builder = new StringBuilder(field.getTextLength());
        GrClosableBlock block = (GrClosableBlock)field.getInitializerGroovy();
        GrModifierList modifierList = field.getModifierList();
        if (modifierList.getModifiers().length > 0 || modifierList.getAnnotations().length > 0) {
            builder.append(modifierList.getText());
        } else {
            builder.append("def");
        }
        builder.append(' ').append(field.getName());
        builder.append('(');
        if (block.hasParametersSection()) {
            builder.append(block.getParameterList().getText());
        } else {
            builder.append("def it = null");
        }
        builder.append(") {");
        ApplicationManager.getApplication().runWriteAction(() -> {
            block.getParameterList().delete();
            block.getLBrace().delete();
            PsiElement psiElement = PsiUtil.skipWhitespacesAndComments(block.getFirstChild(), true);
            if (psiElement != null && "->".equals(psiElement.getText())) {
                psiElement.delete();
            }
            builder.append(block.getText());
            GrMethod method = GroovyPsiElementFactory.getInstance(field.getProject()).createMethodFromText(builder.toString());
            field.getParent().replace((PsiElement)method);
            for (PsiElement usage : fieldUsages) {
                if (!(usage instanceof GrReferenceExpression)) continue;
                PsiElement parent2 = usage.getParent();
                StringBuilder newRefText = new StringBuilder();
                if (parent2 instanceof GrReferenceExpression && usage == ((GrReferenceExpression)parent2).getQualifier() && "call".equals(((GrReferenceExpression)parent2).getReferenceName())) {
                    newRefText.append(usage.getText());
                    usage = parent2;
                } else {
                    PsiElement qualifier = ((GrReferenceExpression)usage).getQualifier();
                    if (qualifier == null && parent2 instanceof GrReferenceExpression && ((GrReferenceExpression)parent2).getQualifier() != null && usage != ((GrReferenceExpression)parent2).getQualifier()) {
                        qualifier = ((GrReferenceExpression)parent2).getQualifier();
                        usage = parent2;
                    }
                    if (qualifier != null) {
                        newRefText.append(qualifier.getText()).append('.');
                        ((GrReferenceExpression)usage).setQualifier(null);
                    } else {
                        newRefText.append("this.");
                    }
                    newRefText.append('&').append(usage.getText());
                }
                usage.replace((PsiElement)factory.createReferenceExpressionFromText(newRefText.toString()));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/conversions/ConvertClosureToMethodIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyPredicate
    implements PsiElementPredicate {
        private MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                MyPredicate.$$$reportNull$$$0(0);
            }
            if (element.getLanguage() != GroovyLanguage.INSTANCE) {
                return false;
            }
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof GrField)) {
                return false;
            }
            GrField field = (GrField)parent2;
            if (field.getNameIdentifierGroovy() != element) {
                return false;
            }
            PsiElement varDeclaration = field.getParent();
            if (!(varDeclaration instanceof GrVariableDeclaration)) {
                return false;
            }
            if (((GrVariableDeclaration)varDeclaration).getVariables().length != 1) {
                return false;
            }
            GrExpression expression = field.getInitializerGroovy();
            return expression instanceof GrClosableBlock;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertClosureToMethodIntention$MyPredicate", "satisfiedBy"));
        }
    }
}

