/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference;

import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.UnreachableException;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.InferenceDriverUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;
import org.jetbrains.plugins.groovy.lang.typing.TypeUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0003\u001a\u00020\tH\u0002\u001a@\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u00060\u0001\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0001\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\t2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\t\u001a\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00012\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0002\u001a\u0018\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0011\u001a\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\tH\u0000\u001a\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\tH\u0002\u001a\u0006\u0010)\u001a\u00020*\u001a\u001c\u0010+\u001a\u00020\u0002*\u00020,2\u0006\u0010-\u001a\u00020\u00072\b\u0010.\u001a\u0004\u0018\u00010\u0011\u001a\n\u0010/\u001a\u000200*\u000200\u001a\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e*\b\u0012\u0004\u0012\u00020\u00110\u000e\u001a\n\u00102\u001a\u00020\u0011*\u00020\u0011\u001a\f\u00103\u001a\u00020&*\u0004\u0018\u00010\u0011\u001a\f\u00104\u001a\u00020&*\u0004\u0018\u00010\u0011\u001a\f\u00105\u001a\u0004\u0018\u000106*\u000207\u001a\u001f\u00108\u001a\u00020\u0011*\u00020\u00182\u0006\u00109\u001a\u00020\u00112\b\b\u0002\u0010:\u001a\u00020\bH\u0086\u0010\u001a\u0012\u0010;\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0003\u001a\u00020\t\u001a\u000e\u0010<\u001a\u0004\u0018\u00010\u001d*\u0004\u0018\u00010\u0011\u001a\u000e\u0010=\u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u0011\u001a\n\u0010>\u001a\u00020\u0011*\u00020\u0002*\u0016\u0010?\"\b\u0012\u0004\u0012\u00020A0@2\b\u0012\u0004\u0012\u00020A0@\u00a8\u0006B"}, d2={"allOuterTypeParameters", "", "Lcom/intellij/psi/PsiTypeParameter;", "method", "Lcom/intellij/psi/PsiMethod;", "buildVirtualEnvironmentForMethod", "Lkotlin/Pair;", "", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "cartesianProduct", "T", "U", "leftRange", "", "rightRange", "compress", "Lcom/intellij/psi/PsiType;", "types", "convertToGroovyMethod", "createVirtualMethod", "typeParameterList", "Lcom/intellij/psi/PsiTypeParameterList;", "createVirtualToActualSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "virtualMethod", "originalMethod", "findOverridableMethod", "getContainingClasses", "Lcom/intellij/psi/PsiClass;", "startClass", "getInferenceVariable", "Lcom/intellij/psi/impl/source/resolve/graphInference/InferenceVariable;", "session", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "variableType", "getOriginalMethod", "methodsAgree", "", "pattern", "tested", "unreachable", "", "createProperTypeParameter", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;", "name", "superType", "erasure", "Lcom/intellij/psi/PsiClassType;", "flattenIntersections", "forceWildcardsAsTypeArguments", "isClosureTypeDeep", "isTypeParameter", "properResolve", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "Lcom/intellij/psi/PsiElement;", "recursiveSubstitute", "type", "recursionDepth", "removeForeignTypeParameters", "resolve", "typeParameter", "upperBound", "InferenceGraphNode", "Lcom/intellij/psi/impl/source/resolve/graphInference/InferenceVariablesOrder$InferenceGraphNode;", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitNode;", "intellij.groovy"})
public final class InferenceProcessUtilKt {
    @Nullable
    public static final InferenceVariable getInferenceVariable(@NotNull GroovyInferenceSession session, @NotNull PsiType variableType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)session), (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)variableType, (String)"variableType");
        return session.getInferenceVariable(session.substituteWithInferenceVariables(variableType));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Iterable<PsiType> flattenIntersections(@NotNull Iterable<? extends PsiType> $this$flattenIntersections) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$flattenIntersections, (String)"$this$flattenIntersections");
        Iterable<? extends PsiType> $this$flatMap$iv = $this$flattenIntersections;
        boolean $i$f$flatMap = false;
        Iterable<? extends PsiType> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Collection collection;
            PsiType it = (PsiType)element$iv$iv;
            boolean bl = false;
            if (it instanceof PsiIntersectionType) {
                PsiType[] psiTypeArray = ((PsiIntersectionType)it).getConjuncts();
                boolean bl2 = false;
                Set set = new LinkedHashSet();
                collection = PsiIntersectionType.flatten((PsiType[])psiTypeArray, (Set)set);
            } else {
                collection = CollectionsKt.listOf((Object)it);
            }
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PsiTypeParameter createProperTypeParameter(@NotNull GroovyPsiElementFactory $this$createProperTypeParameter, @NotNull String name, @Nullable PsiType superType) {
        void $this$filterTo$iv$iv;
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$this$createProperTypeParameter, (String)"$this$createProperTypeParameter");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (superType instanceof PsiIntersectionType) {
            Object[] objectArray = ((PsiIntersectionType)superType).getConjuncts();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"superType.conjuncts");
            list = ArraysKt.asList((Object[])objectArray);
        } else {
            list = superType != null ? CollectionsKt.listOf((Object)superType) : CollectionsKt.emptyList();
        }
        List extendsTypes = list;
        Iterable $this$filter$iv = extendsTypes;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiType it = (PsiType)element$iv$iv;
            boolean bl = false;
            if (!(!it.equalsToText("java.lang.Object") && !it.equalsToText("groovy.lang.GroovyObject"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredSupertypes = (List)destination$iv$iv;
        Collection $i$f$filter22 = filteredSupertypes;
        boolean bl = false;
        String extendsBound2 = !$i$f$filter22.isEmpty() ? " extends " + CollectionsKt.joinToString$default((Iterable)filteredSupertypes, (CharSequence)"&", null, null, (int)0, null, (Function1)createProperTypeParameter.extendsBound.1.INSTANCE, (int)30, null) : "";
        String method = "public <" + name + ' ' + extendsBound2 + "> void foo(){}";
        GrMethod grMethod = $this$createProperTypeParameter.createMethodFromText(method, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)grMethod, (String)"createMethodFromText(method, null)");
        Object[] objectArray = grMethod.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"createMethodFromText(method, null).typeParameters");
        Object object = ArraysKt.single((Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"createMethodFromText(met\u2026).typeParameters.single()");
        return (PsiTypeParameter)object;
    }

    @NotNull
    public static final PsiType forceWildcardsAsTypeArguments(@NotNull PsiType $this$forceWildcardsAsTypeArguments) {
        Intrinsics.checkParameterIsNotNull((Object)$this$forceWildcardsAsTypeArguments, (String)"$this$forceWildcardsAsTypeArguments");
        PsiClass psiClass = InferenceProcessUtilKt.resolve($this$forceWildcardsAsTypeArguments);
        if (psiClass == null || (psiClass = psiClass.getManager()) == null) {
            return $this$forceWildcardsAsTypeArguments;
        }
        PsiClass manager = psiClass;
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(manager.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyPsiElementFactory, (String)"GroovyPsiElementFactory.\u2026Instance(manager.project)");
        GroovyPsiElementFactory factory = groovyPsiElementFactory;
        Object object = $this$forceWildcardsAsTypeArguments.accept((PsiTypeVisitor)new PsiTypeMapper((PsiManager)manager, factory){
            final /* synthetic */ PsiManager $manager;
            final /* synthetic */ GroovyPsiElementFactory $factory;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public PsiType visitClassType(@NotNull PsiClassType classType) {
                PsiClass psiClass;
                Object object;
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)classType, (String)"classType");
                PsiType[] psiTypeArray = classType.getParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"classType.parameters");
                PsiType[] $this$map$iv = psiTypeArray;
                boolean $i$f$map2 = false;
                PsiType[] psiTypeArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var8_9 = $this$mapTo$iv$iv;
                int n = ((void)var8_9).length;
                for (int i = 0; i < n; ++i) {
                    PsiWildcardType psiWildcardType;
                    void it;
                    void item$iv$iv;
                    void var12_13 = item$iv$iv = var8_9[i];
                    object = destination$iv$iv;
                    boolean bl = false;
                    PsiType accepted = (PsiType)it.accept((PsiTypeVisitor)this);
                    if (accepted instanceof PsiWildcardType) {
                        psiWildcardType = (PsiWildcardType)accepted;
                    } else if (accepted != null && Intrinsics.areEqual((Object)accepted, (Object)PsiType.NULL) ^ true) {
                        PsiWildcardType psiWildcardType2 = PsiWildcardType.createExtends((PsiManager)this.$manager, (PsiType)accepted);
                        psiWildcardType = psiWildcardType2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiWildcardType2, (String)"PsiWildcardType.createExtends(manager, accepted)");
                    } else {
                        PsiWildcardType psiWildcardType3 = PsiWildcardType.createUnbounded((PsiManager)this.$manager);
                        psiWildcardType = psiWildcardType3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiWildcardType3, (String)"PsiWildcardType.createUnbounded(manager)");
                    }
                    psiClass = psiWildcardType;
                    object.add(psiClass);
                }
                List mappedParameters = (List)destination$iv$iv;
                PsiClass resolvedClass = classType.resolve();
                if (resolvedClass != null) {
                    void $this$toTypedArray$iv;
                    Collection $i$f$map2 = mappedParameters;
                    psiClass = resolvedClass;
                    object = this.$factory;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    PsiWildcardType[] psiWildcardTypeArray = thisCollection$iv.toArray(new PsiWildcardType[0]);
                    if (psiWildcardTypeArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    PsiWildcardType[] psiWildcardTypeArray2 = psiWildcardTypeArray;
                    PsiType[] psiTypeArray3 = (PsiType[])psiWildcardTypeArray2;
                    return (PsiType)object.createType(psiClass, Arrays.copyOf(psiTypeArray3, psiTypeArray3.length));
                }
                return (PsiType)classType;
            }
            {
                this.$manager = $captured_local_variable$0;
                this.$factory = $captured_local_variable$1;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"accept(object : PsiTypeM\u2026sType\n      }\n    }\n\n  })");
        return (PsiType)object;
    }

    public static final boolean isClosureTypeDeep(@Nullable PsiType $this$isClosureTypeDeep) {
        PsiClassType psiClassType;
        PsiClassType psiClassType2;
        PsiClassType psiClassType3 = $this$isClosureTypeDeep;
        if (!(psiClassType3 instanceof PsiClassType)) {
            psiClassType3 = null;
        }
        return ((psiClassType2 = (PsiClassType)psiClassType3) != null && (psiClassType2 = psiClassType2.rawType()) != null ? psiClassType2.equalsToText("groovy.lang.Closure") : false) || ((psiClassType = $this$isClosureTypeDeep) != null && (psiClassType = InferenceProcessUtilKt.typeParameter((PsiType)psiClassType)) != null && (psiClassType = psiClassType.getExtendsListTypes()) != null && (psiClassType = (PsiClassType)ArraysKt.singleOrNull((Object[])psiClassType)) != null && (psiClassType = psiClassType.rawType()) != null ? psiClassType.equalsToText("groovy.lang.Closure") : false);
    }

    @NotNull
    public static final PsiType recursiveSubstitute(@NotNull PsiSubstitutor $this$recursiveSubstitute, @NotNull PsiType type2, int recursionDepth) {
        while (true) {
            Intrinsics.checkParameterIsNotNull((Object)$this$recursiveSubstitute, (String)"$this$recursiveSubstitute");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            if (recursionDepth == 0) {
                Object object = type2.accept((PsiTypeVisitor)new PsiTypeMapper(){

                    @Nullable
                    public PsiType visitClassType(@NotNull PsiClassType classType) {
                        Intrinsics.checkParameterIsNotNull((Object)classType, (String)"classType");
                        return (PsiType)classType.rawType();
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"type.accept(object : Psi\u2026.rawType()\n      }\n    })");
                return (PsiType)object;
            }
            PsiType substituted = $this$recursiveSubstitute.substitute(type2);
            if (Intrinsics.areEqual((Object)substituted, (Object)type2)) break;
            Intrinsics.checkExpressionValueIsNotNull((Object)substituted, (String)"substituted");
            --recursionDepth;
        }
        return type2;
    }

    public static /* synthetic */ PsiType recursiveSubstitute$default(PsiSubstitutor psiSubstitutor, PsiType psiType, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 20;
        }
        return InferenceProcessUtilKt.recursiveSubstitute(psiSubstitutor, psiType, n);
    }

    @NotNull
    public static final Void unreachable() {
        throw (Throwable)new UnreachableException();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, U> List<Pair<T, U>> cartesianProduct(@NotNull Iterable<? extends T> leftRange, @NotNull Iterable<? extends U> rightRange) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(leftRange, (String)"leftRange");
        Intrinsics.checkParameterIsNotNull(rightRange, (String)"rightRange");
        Iterable<? extends T> $this$flatMap$iv = leftRange;
        boolean $i$f$flatMap = false;
        Iterable<? extends T> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            Object element$iv$iv;
            Object left = element$iv$iv = iterator2.next();
            boolean bl = false;
            Iterable<? extends U> $this$map$iv = rightRange;
            boolean $i$f$map = false;
            Iterable<? extends U> iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator3.next();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Pair pair = TuplesKt.to(left, (Object)it);
                collection.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isTypeParameter(@Nullable PsiType $this$isTypeParameter) {
        return InferenceProcessUtilKt.resolve($this$isTypeParameter) instanceof PsiTypeParameter;
    }

    @Nullable
    public static final PsiTypeParameter typeParameter(@Nullable PsiType $this$typeParameter) {
        PsiClass psiClass = InferenceProcessUtilKt.resolve($this$typeParameter);
        if (!(psiClass instanceof PsiTypeParameter)) {
            psiClass = null;
        }
        return (PsiTypeParameter)psiClass;
    }

    @Nullable
    public static final PsiMethod findOverridableMethod(@NotNull GrMethod method) {
        Object object;
        block9: {
            Iterable list$iv$iv;
            Object it;
            Object $this$flatMapTo$iv$iv;
            boolean hasJavaLangOverride;
            int n;
            PsiAnnotation[] psiAnnotationArray;
            boolean $i$f$any;
            PsiAnnotation[] $this$any$iv;
            Object[] superMethods;
            PsiClass clazz;
            block8: {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                PsiClass psiClass = method.getContainingClass();
                if (psiClass == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"method.containingClass ?: return null");
                clazz = psiClass;
                superMethods = method.findSuperMethods();
                PsiAnnotation[] psiAnnotationArray2 = method.getAnnotations();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationArray2, (String)"method.annotations");
                $this$any$iv = psiAnnotationArray2;
                $i$f$any = false;
                psiAnnotationArray = $this$any$iv;
                n = psiAnnotationArray.length;
                for (int i = 0; i < n; ++i) {
                    Object element$iv;
                    PsiAnnotation it2 = element$iv = psiAnnotationArray[i];
                    boolean bl2 = false;
                    PsiAnnotation psiAnnotation = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"it");
                    if (!Intrinsics.areEqual((Object)psiAnnotation.getQualifiedName(), (Object)"java.lang.Override")) continue;
                    bl = true;
                    break block8;
                }
                bl = hasJavaLangOverride = false;
            }
            if (hasJavaLangOverride) {
                Intrinsics.checkExpressionValueIsNotNull((Object)superMethods, (String)"superMethods");
                $this$any$iv = superMethods;
                $i$f$any = false;
                psiAnnotationArray = $this$any$iv;
                n = 0;
                if (!(psiAnnotationArray.length == 0)) {
                    return (PsiMethod)ArraysKt.first((Object[])superMethods);
                }
            }
            PsiClass[] candidateMethodsDomain = hasJavaLangOverride ? clazz.getSupers() : clazz.getInterfaces();
            Object[] objectArray = clazz.getSupers();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"clazz.supers");
            Object $this$flatMap$iv = ArraysKt.plus((Object[])objectArray, (Object)clazz);
            boolean $i$f$flatMap = false;
            Object object2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (PsiClass)element$iv$iv;
                boolean bl = false;
                Object[] objectArray2 = it.findMethodsByName(method.getName(), true);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"it.findMethodsByName(method.name, true)");
                list$iv$iv = ArraysKt.asIterable((Object[])objectArray2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            Iterator bl2 = $this$flatMapTo$iv$iv.iterator();
            while (bl2.hasNext()) {
                Object element$iv$iv = bl2.next();
                PsiMethod it3 = (PsiMethod)element$iv$iv;
                boolean bl = false;
                Object[] objectArray3 = it3.findSuperMethods();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray3, (String)"it.findSuperMethods()");
                Iterable list$iv$iv2 = ArraysKt.asIterable((Object[])objectArray3);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
            }
            List alreadyOverriddenMethods = (List)destination$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)candidateMethodsDomain, (String)"candidateMethodsDomain");
            $this$flatMap$iv = candidateMethodsDomain;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = element$iv$iv;
                boolean bl = false;
                Object[] objectArray4 = it.findMethodsByName(method.getName(), true);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray4, (String)"it.findMethodsByName(method.name, true)");
                list$iv$iv = ArraysKt.asIterable((Object[])objectArray4);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$firstOrNull$iv = CollectionsKt.subtract((Iterable)((List)destination$iv$iv), (Iterable)alreadyOverriddenMethods);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiMethod it4 = (PsiMethod)element$iv;
                boolean bl = false;
                PsiMethod psiMethod = it4;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"it");
                if (!InferenceProcessUtilKt.methodsAgree(psiMethod, method)) continue;
                object = element$iv;
                break block9;
            }
            object = null;
        }
        return (PsiMethod)object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean methodsAgree(PsiMethod pattern, GrMethod tested) {
        boolean bl;
        if (Intrinsics.areEqual((Object)pattern.getName(), (Object)tested.getName()) ^ true) return false;
        GrParameterList grParameterList = tested.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)grParameterList, (String)"tested.parameterList");
        int n = grParameterList.getParametersCount();
        PsiParameterList psiParameterList = pattern.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"pattern.parameterList");
        if (n != psiParameterList.getParametersCount()) {
            return false;
        }
        Object[] objectArray = pattern.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"pattern.parameters");
        Object[] objectArray2 = tested.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"tested.parameters");
        List parameterList = ArraysKt.zip((Object[])objectArray, (Object[])objectArray2);
        Iterable $this$all$iv = parameterList;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            JvmType jvmType;
            PsiPrimitiveType psiPrimitiveType;
            void patternParameter;
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            Pair $dstr$patternParameter$testedParameter = (Pair)element$iv;
            boolean bl2 = false;
            JvmParameter jvmParameter = (JvmParameter)$dstr$patternParameter$testedParameter.component1();
            GrParameter testedParameter = (GrParameter)$dstr$patternParameter$testedParameter.component2();
            void v5 = patternParameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"patternParameter");
            JvmType jvmType2 = v5.getType();
            if (!(jvmType2 instanceof PsiPrimitiveType)) {
                jvmType2 = null;
            }
            if ((psiPrimitiveType = (PsiPrimitiveType)jvmType2) != null && (psiPrimitiveType = TypeUtils.box((PsiType)psiPrimitiveType, tested)) != null) {
                jvmType = (JvmType)psiPrimitiveType;
            } else {
                JvmType jvmType3 = patternParameter.getType();
                jvmType = jvmType3;
                Intrinsics.checkExpressionValueIsNotNull((Object)jvmType3, (String)"patternParameter.type");
            }
            JvmType boxedPatternParameter = jvmType;
            GrParameter grParameter = testedParameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)grParameter, (String)"testedParameter");
            if (grParameter.getTypeElement() != null) {
                PsiType psiType = testedParameter.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"testedParameter.type");
                PsiType psiType2 = TypeUtils.box(psiType, tested);
                if (psiType2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiClassType");
                }
                PsiClassType psiClassType = InferenceProcessUtilKt.erasure((PsiClassType)psiType2);
                JvmType jvmType4 = boxedPatternParameter;
                if (!(jvmType4 instanceof PsiClassType)) {
                    jvmType4 = null;
                }
                PsiClassType psiClassType2 = (PsiClassType)jvmType4;
                if (!Intrinsics.areEqual((Object)psiClassType, (Object)(psiClassType2 != null ? InferenceProcessUtilKt.erasure(psiClassType2) : null))) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    public static final PsiClassType erasure(@NotNull PsiClassType $this$erasure) {
        PsiClassType psiClassType;
        Intrinsics.checkParameterIsNotNull((Object)$this$erasure, (String)"$this$erasure");
        PsiClassType psiClassType2 = $this$erasure.rawType();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType2, (String)"rawType()");
        PsiClassType raw = psiClassType2;
        PsiTypeParameter typeParameter = InferenceProcessUtilKt.typeParameter((PsiType)raw);
        if (typeParameter != null) {
            Object[] objectArray = typeParameter.getExtendsListTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"typeParameter.extendsListTypes");
            psiClassType = (PsiClassType)ArraysKt.firstOrNull((Object[])objectArray);
            if (psiClassType == null || (psiClassType = InferenceProcessUtilKt.erasure(psiClassType)) == null) {
                psiClassType = InferenceDriverUtilKt.getJavaLangObject((PsiElement)typeParameter);
            }
        } else {
            psiClassType = raw;
        }
        return psiClassType;
    }

    private static final List<PsiClass> getContainingClasses(PsiClass startClass) {
        getContainingClasses.1 $fun$getContainingClassesMutable$1 = getContainingClasses.1.INSTANCE;
        return $fun$getContainingClassesMutable$1.invoke(startClass);
    }

    private static final Pair<String, Integer> buildVirtualEnvironmentForMethod(GrMethod method) {
        PsiFile psiFile = method.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"method.containingFile");
        String text = psiFile.getText();
        List<PsiClass> containingClasses = InferenceProcessUtilKt.getContainingClasses(method.getContainingClass());
        boolean bl = false;
        List classRepresentations = new ArrayList();
        boolean bl2 = false;
        List fieldRepresentations = new ArrayList();
        for (PsiClass containingClass : containingClasses) {
            Object[] objectArray = containingClass.getFields();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"containingClass.fields");
            fieldRepresentations.add(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"\n", null, null, (int)0, null, (Function1)buildVirtualEnvironmentForMethod.1.INSTANCE, (int)30, null));
            TextRange textRange = containingClass.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"containingClass.textRange");
            int startOffset = textRange.getStartOffset();
            PsiElement psiElement = containingClass.getLBrace();
            int lBraceOffset = psiElement != null ? psiElement.getTextOffset() : startOffset;
            String string = text;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            classRepresentations.add(StringsKt.substring((String)string, (IntRange)RangesKt.until((int)startOffset, (int)lBraceOffset)));
        }
        String header2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.zip((Iterable)classRepresentations, (Iterable)fieldRepresentations), (CharSequence)"", null, null, (int)0, null, (Function1)buildVirtualEnvironmentForMethod.header.1.INSTANCE, (int)30, null);
        String footer = StringsKt.repeat((CharSequence)" } ", (int)containingClasses.size());
        return TuplesKt.to((Object)(header2 + method.getText() + footer), (Object)header2.length());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final GrMethod createVirtualMethod(@NotNull GrMethod method, @Nullable PsiTypeParameterList typeParameterList) {
        PsiElement psiElement;
        GroovyPsiElementFactory factory;
        block11: {
            block10: {
                void fileText;
                Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                Pair<String, Integer> pair = InferenceProcessUtilKt.buildVirtualEnvironmentForMethod(method);
                String string = (String)pair.component1();
                int offset = ((Number)pair.component2()).intValue();
                GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(method.getProject());
                Intrinsics.checkExpressionValueIsNotNull((Object)groovyPsiElementFactory, (String)"GroovyPsiElementFactory.\u2026tInstance(method.project)");
                factory = groovyPsiElementFactory;
                GroovyFile groovyFile = factory.createGroovyFile((CharSequence)fileText, false, method);
                Intrinsics.checkExpressionValueIsNotNull((Object)groovyFile, (String)"factory.createGroovyFile(fileText, false, method)");
                GroovyFile newFile = groovyFile;
                psiElement = newFile.findElementAt(offset);
                if (psiElement == null) break block10;
                PsiElement $this$parentOfType$iv = psiElement;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                psiElement = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrMethod.class, (boolean)true);
                if (psiElement != null) break block11;
            }
            return null;
        }
        PsiElement newMethod = psiElement;
        if (newMethod.hasTypeParameters()) {
            if (typeParameterList != null) {
                PsiTypeParameterList psiTypeParameterList = newMethod.getTypeParameterList();
                if (psiTypeParameterList == null) {
                    Intrinsics.throwNpe();
                }
                psiTypeParameterList.replace((PsiElement)typeParameterList);
            }
        } else if (typeParameterList != null) {
            newMethod.addAfter((PsiElement)typeParameterList, newMethod.getFirstChild());
        } else {
            newMethod.addAfter((PsiElement)factory.createTypeParameterList(), newMethod.getFirstChild());
        }
        return newMethod;
    }

    public static /* synthetic */ GrMethod createVirtualMethod$default(GrMethod grMethod, PsiTypeParameterList psiTypeParameterList, int n, Object object) {
        if ((n & 2) != 0) {
            psiTypeParameterList = null;
        }
        return InferenceProcessUtilKt.createVirtualMethod(grMethod, psiTypeParameterList);
    }

    @Nullable
    public static final GrMethod convertToGroovyMethod(@NotNull PsiMethod method) {
        GrMethod grMethod;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(method.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyPsiElementFactory, (String)"GroovyPsiElementFactory.\u2026tInstance(method.project)");
        GroovyPsiElementFactory factory = groovyPsiElementFactory;
        if (method.isConstructor()) {
            Object object = method.getBody();
            if (object == null || (object = object.getText()) == null) {
                return null;
            }
            Object constructorBody = object;
            grMethod = factory.createConstructorFromText(method.getName(), (CharSequence)constructorBody, (PsiElement)method);
        } else {
            String string = method.getText();
            if (string == null) {
                return null;
            }
            String methodText = string;
            grMethod = factory.createMethodFromText(methodText, (PsiElement)method);
        }
        return grMethod;
    }

    @Nullable
    public static final PsiClass resolve(@Nullable PsiType $this$resolve) {
        PsiType psiType = $this$resolve;
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        return psiClassType != null ? psiClassType.resolve() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PsiSubstitutor removeForeignTypeParameters(@NotNull PsiSubstitutor $this$removeForeignTypeParameters, @NotNull GrMethod method) {
        Collection $this$toTypedArray$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$this$removeForeignTypeParameters, (String)"$this$removeForeignTypeParameters");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        boolean bl = false;
        List typeParameters = new ArrayList();
        boolean bl2 = false;
        List substitutions = new ArrayList();
        Object[] objectArray = method.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"method.typeParameters");
        List allowedTypeParameters = ArraysKt.asList((Object[])objectArray);
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(method.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyPsiElementFactory, (String)"GroovyPsiElementFactory.\u2026tInstance(method.project)");
        GroovyPsiElementFactory factory = groovyPsiElementFactory;
        PsiWildcardType psiWildcardType = PsiWildcardType.createUnbounded((PsiManager)method.getManager());
        Intrinsics.checkExpressionValueIsNotNull((Object)psiWildcardType, (String)"PsiWildcardType.createUnbounded(method.manager)");
        PsiWildcardType unboundedWildcard = psiWildcardType;
        Iterator iterator2 = $this$removeForeignTypeParameters.getSubstitutionMap().entrySet().iterator();
        while (iterator2.hasNext()) {
            void typeParameter;
            Object object2 = object = iterator2.next();
            boolean bl3 = false;
            PsiTypeParameter psiTypeParameter = (PsiTypeParameter)object2.getKey();
            object2 = object;
            bl3 = false;
            PsiType type2 = (PsiType)object2.getValue();
            void v3 = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"typeParameter");
            typeParameters.add(v3);
            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"org/jetbrains/plugins/groovy/intentions/style/inference/InferenceProcessUtilKt$removeForeignTypeParameters$ForeignTypeParameterEraser", "Lcom/intellij/psi/PsiTypeMapper;", "(Ljava/util/List;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;Lcom/intellij/psi/PsiWildcardType;Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;)V", "visitClassType", "Lcom/intellij/psi/PsiType;", "classType", "Lcom/intellij/psi/PsiClassType;", "visitIntersectionType", "intersectionType", "Lcom/intellij/psi/PsiIntersectionType;", "visitWildcardType", "wildcardType", "Lcom/intellij/psi/PsiWildcardType;", "intellij.groovy"})
            public final class ForeignTypeParameterEraser
            extends PsiTypeMapper {
                final /* synthetic */ List $allowedTypeParameters;
                final /* synthetic */ GrMethod $method;
                final /* synthetic */ PsiWildcardType $unboundedWildcard;
                final /* synthetic */ GroovyPsiElementFactory $factory;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public PsiType visitClassType(@NotNull PsiClassType classType) {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkParameterIsNotNull((Object)classType, (String)"classType");
                    PsiTypeParameter typeParameter = InferenceProcessUtilKt.typeParameter((PsiType)classType);
                    if (typeParameter != null && !this.$allowedTypeParameters.contains(typeParameter)) {
                        Object[] objectArray = typeParameter.getExtendsListTypes();
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"typeParameter.extendsListTypes");
                        PsiType psiType = InferenceProcessUtilKt.compress(ArraysKt.asList((Object[])objectArray));
                        if (psiType == null) {
                            psiType = (PsiType)InferenceDriverUtilKt.getJavaLangObject(this.$method);
                        }
                        return (PsiType)psiType.accept((PsiTypeVisitor)this);
                    }
                    PsiClass psiClass = classType.resolve();
                    if (psiClass == null) {
                        return null;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"classType.resolve() ?: return null");
                    PsiClass resolvedClass = psiClass;
                    PsiType[] psiTypeArray = classType.getParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"classType.parameters");
                    PsiType[] $this$map$iv = psiTypeArray;
                    boolean $i$f$map = false;
                    PsiType[] psiTypeArray2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    void var10_9 = $this$mapTo$iv$iv;
                    int n = ((void)var10_9).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var14_13 = item$iv$iv = var10_9[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        PsiType psiType = it;
                        if (psiType == null || (psiType = (PsiType)psiType.accept((PsiTypeVisitor)this)) == null) {
                            psiType = (PsiType)this.$unboundedWildcard;
                        }
                        PsiType psiType2 = psiType;
                        collection.add(psiType2);
                    }
                    Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    PsiType[] psiTypeArray3 = thisCollection$iv.toArray(new PsiType[0]);
                    if (psiTypeArray3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    PsiType[] classParameters = psiTypeArray3;
                    return (PsiType)this.$factory.createType(resolvedClass, Arrays.copyOf(classParameters, classParameters.length));
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public PsiType visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
                    List list;
                    Intrinsics.checkParameterIsNotNull((Object)intersectionType, (String)"intersectionType");
                    Object object = intersectionType.getConjuncts();
                    if (object != null && (object = ArraysKt.filterNotNull((Object[])object)) != null) {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = (Iterable)object;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            PsiType psiType;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator2.next();
                            boolean bl = false;
                            PsiType it = (PsiType)element$iv$iv;
                            boolean bl2 = false;
                            if ((PsiType)it.accept((PsiTypeVisitor)this) == null) continue;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            PsiType it$iv$iv = psiType;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        list = (List)destination$iv$iv;
                    } else {
                        list = null;
                    }
                    return InferenceProcessUtilKt.compress(list);
                }

                @Nullable
                public PsiType visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                    Intrinsics.checkParameterIsNotNull((Object)wildcardType, (String)"wildcardType");
                    PsiType psiType = wildcardType.getBound();
                    if (psiType == null || (psiType = (PsiType)psiType.accept((PsiTypeVisitor)this)) == null) {
                        return (PsiType)wildcardType;
                    }
                    PsiType bound = psiType;
                    return wildcardType.isExtends() ? (PsiType)PsiWildcardType.createExtends((PsiManager)this.$method.getManager(), (PsiType)bound) : (wildcardType.isSuper() ? (PsiType)PsiWildcardType.createSuper((PsiManager)this.$method.getManager(), (PsiType)bound) : (PsiType)wildcardType);
                }

                public ForeignTypeParameterEraser(List $captured_local_variable$0, GrMethod $captured_local_variable$1, PsiWildcardType $captured_local_variable$2, GroovyPsiElementFactory $captured_local_variable$3) {
                    this.$allowedTypeParameters = $captured_local_variable$0;
                    this.$method = $captured_local_variable$1;
                    this.$unboundedWildcard = $captured_local_variable$2;
                    this.$factory = $captured_local_variable$3;
                }
            }
            PsiType psiType = (PsiType)type2.accept((PsiTypeVisitor)new ForeignTypeParameterEraser(allowedTypeParameters, method, unboundedWildcard, factory));
            if (psiType == null) {
                PsiPrimitiveType psiPrimitiveType = PsiType.NULL;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiPrimitiveType, (String)"PsiType.NULL");
                psiType = (PsiType)psiPrimitiveType;
            }
            substitutions.add(psiType);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"PsiSubstitutor.EMPTY");
        object = typeParameters;
        PsiSubstitutor psiSubstitutor2 = psiSubstitutor;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiTypeParameter[] psiTypeParameterArray = thisCollection$iv.toArray(new PsiTypeParameter[0]);
        if (psiTypeParameterArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        PsiTypeParameter[] psiTypeParameterArray2 = psiTypeParameterArray;
        $this$toTypedArray$iv = substitutions;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        PsiType[] psiTypeArray = thisCollection$iv.toArray(new PsiType[0]);
        if (psiTypeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        PsiType[] psiTypeArray2 = psiTypeArray;
        return InferenceKt.putAll(psiSubstitutor2, psiTypeParameterArray2, psiTypeArray2);
    }

    @Nullable
    public static final PsiType compress(@Nullable List<? extends PsiType> types) {
        if (types == null) {
            return null;
        }
        return types.isEmpty() ? (PsiType)PsiType.NULL : (types.size() == 1 ? (PsiType)CollectionsKt.single(types) : PsiIntersectionType.createIntersection(types));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiTypeParameter> allOuterTypeParameters(@NotNull PsiMethod method) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Object[] objectArray = method.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"method.typeParameters");
        Iterable iterable = InferenceProcessUtilKt.getContainingClasses(method.getContainingClass());
        Collection collection = ArraysKt.asList((Object[])objectArray);
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiClass it = (PsiClass)element$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = it.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"it.typeParameters");
            Iterable list$iv$iv = ArraysKt.asList((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    @NotNull
    public static final PsiSubstitutor createVirtualToActualSubstitutor(@NotNull GrMethod virtualMethod, @NotNull GrMethod originalMethod) {
        Intrinsics.checkParameterIsNotNull((Object)virtualMethod, (String)"virtualMethod");
        Intrinsics.checkParameterIsNotNull((Object)originalMethod, (String)"originalMethod");
        List<PsiTypeParameter> virtualTypeParameters = InferenceProcessUtilKt.allOuterTypeParameters(virtualMethod);
        List<PsiTypeParameter> originalTypeParameters = InferenceProcessUtilKt.allOuterTypeParameters(originalMethod);
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"PsiSubstitutor.EMPTY");
        PsiSubstitutor substitutor = psiSubstitutor;
        Iterable $this$forEach$iv = virtualTypeParameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiTypeParameter originalParameter;
            Object v1;
            PsiTypeParameter virtualParameter;
            block3: {
                virtualParameter = (PsiTypeParameter)element$iv;
                boolean bl = false;
                Iterable iterable = originalTypeParameters;
                boolean bl2 = false;
                Iterable iterable2 = iterable;
                boolean bl3 = false;
                for (Object t : iterable2) {
                    PsiTypeParameter it = (PsiTypeParameter)t;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)virtualParameter.getName())) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            if ((PsiTypeParameter)v1 == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)substitutor.put(virtualParameter, (PsiType)InferenceKt.type((PsiClass)originalParameter)), (String)"substitutor.put(virtualP\u2026originalParameter.type())");
        }
        return substitutor;
    }

    @NotNull
    public static final PsiType upperBound(@NotNull PsiTypeParameter $this$upperBound) {
        PsiType psiType;
        Intrinsics.checkParameterIsNotNull((Object)$this$upperBound, (String)"$this$upperBound");
        switch ($this$upperBound.getExtendsListTypes().length) {
            case 0: {
                psiType = (PsiType)InferenceDriverUtilKt.getJavaLangObject((PsiElement)$this$upperBound);
                break;
            }
            case 1: {
                Object[] objectArray = $this$upperBound.getExtendsListTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"extendsListTypes");
                Object object = ArraysKt.single((Object[])objectArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extendsListTypes.single()");
                psiType = (PsiType)object;
                break;
            }
            default: {
                PsiType[] psiTypeArray = (PsiType[])$this$upperBound.getExtendsListTypes();
                PsiType psiType2 = PsiIntersectionType.createIntersection((PsiType[])Arrays.copyOf(psiTypeArray, psiTypeArray.length));
                psiType = psiType2;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiType2, (String)"PsiIntersectionType.crea\u2026ection(*extendsListTypes)");
            }
        }
        return psiType;
    }

    @Nullable
    public static final GroovyResolveResult properResolve(@NotNull PsiElement $this$properResolve) {
        GroovyResolveResult groovyResolveResult;
        Intrinsics.checkParameterIsNotNull((Object)$this$properResolve, (String)"$this$properResolve");
        PsiElement psiElement = $this$properResolve;
        if (psiElement instanceof GrAssignmentExpression) {
            GroovyReference groovyReference;
            GrExpression grExpression = ((GrAssignmentExpression)$this$properResolve).getLValue();
            if (!(grExpression instanceof GrReferenceExpression)) {
                grExpression = null;
            }
            groovyResolveResult = (groovyReference = (GrReferenceExpression)grExpression) != null && (groovyReference = groovyReference.getLValueReference()) != null ? groovyReference.advancedResolve() : null;
        } else if (psiElement instanceof GrConstructorInvocation) {
            groovyResolveResult = ((GrConstructorInvocation)$this$properResolve).advancedResolve();
        } else {
            PsiElement psiElement2 = $this$properResolve;
            if (!(psiElement2 instanceof GrCall)) {
                psiElement2 = null;
            }
            GrCall grCall = (GrCall)psiElement2;
            groovyResolveResult = grCall != null ? grCall.advancedResolve() : null;
        }
        return groovyResolveResult;
    }

    @NotNull
    public static final GrMethod getOriginalMethod(@NotNull GrMethod method) {
        GrMethod grMethod;
        block8: {
            block11: {
                PsiFile originalFile;
                block10: {
                    GrMethod grMethod2;
                    block6: {
                        block9: {
                            block7: {
                                Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                                PsiFile psiFile = method.getContainingFile();
                                Object object = originalFile = psiFile != null ? psiFile.getOriginalFile() : null;
                                if (originalFile != null) break block7;
                                grMethod = method;
                                break block8;
                            }
                            if (!Intrinsics.areEqual((Object)originalFile, (Object)method.getContainingFile())) break block9;
                            grMethod = method;
                            break block8;
                        }
                        if (!(originalFile instanceof GroovyFileBase)) break block10;
                        GrMethod[] grMethodArray = ((GroovyFileBase)originalFile).getMethods();
                        Intrinsics.checkExpressionValueIsNotNull((Object)grMethodArray, (String)"originalFile.methods");
                        GrMethod[] grMethodArray2 = grMethodArray;
                        boolean bl = false;
                        GrMethod[] grMethodArray3 = grMethodArray2;
                        boolean bl2 = false;
                        GrMethod[] grMethodArray4 = grMethodArray3;
                        int n = grMethodArray4.length;
                        for (int i = 0; i < n; ++i) {
                            GrMethod grMethod3;
                            GrMethod it = grMethod3 = grMethodArray4[i];
                            boolean bl3 = false;
                            GrMethod grMethod4 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)grMethod4, (String)"it");
                            if (!InferenceProcessUtilKt.methodsAgree(grMethod4, method)) continue;
                            grMethod2 = grMethod3;
                            break block6;
                        }
                        grMethod2 = grMethod = null;
                    }
                    if (grMethod2 == null) {
                        grMethod = method;
                    }
                    break block8;
                }
                grMethod = originalFile.findElementAt(method.getTextOffset());
                if (grMethod == null) break block11;
                GrMethod $this$parentOfType$iv = grMethod;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                grMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrMethod.class, (boolean)true);
                if (grMethod == null) break block11;
                GrMethod grMethod5 = grMethod;
                boolean bl = false;
                boolean bl4 = false;
                GrMethod it = grMethod5;
                boolean bl5 = false;
                grMethod = Intrinsics.areEqual((Object)it.getName(), (Object)method.getName()) ? grMethod5 : null;
                if (grMethod != null) break block8;
            }
            grMethod = method;
        }
        return grMethod;
    }
}

