/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.parameterToEntry;

import com.intellij.DynamicBundle;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.settings.GroovyApplicationSettings;

public class GroovyMapParameterDialog
extends DialogWrapper {
    private JPanel contentPane;
    private ComboBox myNameComboBox;
    private JLabel myNameLabel;
    private JCheckBox myCbTypeSpec;
    private JCheckBox myCreateNew;
    private final Project myProject;
    private final EventListenerList myListenerList;

    public GroovyMapParameterDialog(Project project, String[] possibleNames, boolean createNew) {
        super(true);
        this.$$$setupUI$$$();
        this.myListenerList = new EventListenerList();
        this.myProject = project;
        this.setUpDialog(possibleNames, createNew);
        this.init();
    }

    private void setUpDialog(String[] possibleNames, boolean createNew) {
        this.setTitle(GroovyIntentionsBundle.message("convert.param.to.map.entry", new Object[0]));
        if (GroovyApplicationSettings.getInstance().CONVERT_PARAM_CREATE_NEW_PARAM != null) {
            createNew = GroovyApplicationSettings.getInstance().CONVERT_PARAM_CREATE_NEW_PARAM;
            this.myCreateNew.setSelected(createNew);
        } else {
            this.myCreateNew.setSelected(createNew);
        }
        this.myNameLabel.setLabelFor((Component)this.myNameComboBox);
        this.myCbTypeSpec.setMnemonic(84);
        this.myCbTypeSpec.setFocusable(false);
        this.setUpNameComboBox(possibleNames);
        this.setModal(true);
        if (GroovyApplicationSettings.getInstance().CONVERT_PARAM_SPECIFY_MAP_TYPE != null) {
            this.myCbTypeSpec.setSelected(GroovyApplicationSettings.getInstance().CONVERT_PARAM_SPECIFY_MAP_TYPE);
        } else {
            this.myCbTypeSpec.setSelected(true);
        }
        this.myCbTypeSpec.setEnabled(createNew);
        this.myNameComboBox.setEnabled(createNew);
        this.myNameLabel.setEnabled(createNew);
        this.myCreateNew.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean flag = GroovyMapParameterDialog.this.myCreateNew.isSelected();
                GroovyMapParameterDialog.this.myCbTypeSpec.setEnabled(flag);
                GroovyMapParameterDialog.this.myNameComboBox.setEnabled(flag);
                GroovyMapParameterDialog.this.myNameLabel.setEnabled(flag);
            }
        });
    }

    public boolean createNewFirst() {
        return this.myCreateNew.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComboBox;
    }

    public boolean specifyTypeExplicitly() {
        return this.myCbTypeSpec.isSelected();
    }

    protected void doOKAction() {
        if (this.myCbTypeSpec.isEnabled()) {
            GroovyApplicationSettings.getInstance().CONVERT_PARAM_SPECIFY_MAP_TYPE = this.myCbTypeSpec.isSelected();
        }
        GroovyApplicationSettings.getInstance().CONVERT_PARAM_CREATE_NEW_PARAM = this.myCreateNew.isSelected();
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    @Nullable
    protected String getEnteredName() {
        if (this.myNameComboBox.getEditor().getItem() instanceof String && !((String)this.myNameComboBox.getEditor().getItem()).isEmpty()) {
            return (String)this.myNameComboBox.getEditor().getItem();
        }
        return null;
    }

    private void setUpNameComboBox(String[] possibleNames) {
        StringComboboxEditor comboEditor = new StringComboboxEditor(this.myProject, (FileType)GroovyFileType.GROOVY_FILE_TYPE, this.myNameComboBox);
        this.myNameComboBox.setEditor((ComboBoxEditor)comboEditor);
        this.myNameComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)comboEditor));
        this.myNameComboBox.setEditable(true);
        this.myNameComboBox.setMaximumRowCount(8);
        this.myListenerList.add(DataChangedListener.class, new DataChangedListener());
        this.myNameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GroovyMapParameterDialog.this.fireNameDataChanged();
            }
        });
        ((EditorTextField)this.myNameComboBox.getEditor().getEditorComponent()).addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                GroovyMapParameterDialog.this.fireNameDataChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/intentions/style/parameterToEntry/GroovyMapParameterDialog$3", "documentChanged"));
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)GroovyMapParameterDialog.this.myNameComboBox, true));
            }
        }, KeyStroke.getKeyStroke(78, 8), 2);
        for (String possibleName : possibleNames) {
            this.myNameComboBox.addItem((Object)possibleName);
        }
    }

    private void fireNameDataChanged() {
        Object[] list;
        for (Object aList : list = this.myListenerList.getListenerList()) {
            if (!(aList instanceof DataChangedListener)) continue;
            ((DataChangedListener)aList).dataChanged();
        }
    }

    private void updateOkStatus() {
        String text = this.getEnteredName();
        this.setOKActionEnabled(GroovyNamesUtil.isIdentifier(text));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        this.myNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/GroovyIntentionsBundle", GroovyMapParameterDialog.class).getString("map.param.name"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbTypeSpec = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Specify type explicitly");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCreateNew = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/GroovyIntentionsBundle", GroovyMapParameterDialog.class).getString("create.first.new"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNameComboBox = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(100, -1), null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    class DataChangedListener
    implements EventListener {
        DataChangedListener() {
        }

        void dataChanged() {
            GroovyMapParameterDialog.this.updateOkStatus();
        }
    }
}

