/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GrMethodBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            GrMethodBodyFixer.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            GrMethodBodyFixer.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            GrMethodBodyFixer.$$$reportNull$$$0(2);
        }
        if (!(psiElement instanceof GrMethod)) {
            return;
        }
        GrMethod method = (GrMethod)psiElement;
        PsiClass aClass = method.getContainingClass();
        if (aClass != null && aClass.isInterface() || method.hasModifierProperty("abstract")) {
            return;
        }
        GrOpenBlock body = method.getBlock();
        Document doc = editor.getDocument();
        if (body != null) {
            GrStatement[] statements2;
            String bodyText = body.getText();
            if (!StringUtil.startsWithChar((CharSequence)bodyText, (char)'{') || (statements2 = body.getStatements()).length > 0) {
                // empty if block
            }
            return;
        }
        int endOffset = method.getTextRange().getEndOffset();
        if (StringUtil.endsWithChar((CharSequence)method.getText(), (char)';')) {
            doc.deleteString(endOffset - 1, endOffset);
            --endOffset;
        }
        doc.insertString(endOffset, (CharSequence)"{\n}");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrMethodBodyFixer";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

