/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocMemberReferenceImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;

public class GrDocMethodReferenceImpl
extends GrDocMemberReferenceImpl
implements GrDocMethodReference {
    public GrDocMethodReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrDocMethodReferenceImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String toString() {
        return "GrDocMethodReference";
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrDocMethodReferenceImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitDocMethodReference(this);
    }

    @Override
    @NotNull
    public GrDocMethodParams getParameterList() {
        GrDocMethodParams child = (GrDocMethodParams)this.findChildByClass(GrDocMethodParams.class);
        assert (child != null);
        GrDocMethodParams grDocMethodParams = child;
        if (grDocMethodParams == null) {
            GrDocMethodReferenceImpl.$$$reportNull$$$0(2);
        }
        return grDocMethodParams;
    }

    @Override
    public PsiElement bindToText(Project project, String text) {
        GrDocComment comment = GroovyPsiElementFactory.getInstance(project).createDocCommentFromText(text);
        PsiElement tag = PsiTreeUtil.getChildOfType((PsiElement)comment, GrDocTag.class);
        PsiElement ref = PsiTreeUtil.getChildOfType((PsiElement)tag, GrDocMethodReference.class);
        assert (ref != null) : text;
        return this.replace(ref);
    }

    @Override
    public PsiElement resolve() {
        GrCodeReferenceElement referenceElement;
        String name = this.getReferenceName();
        GrDocReferenceElement holder = this.getReferenceHolder();
        Object resolved = holder != null ? ((referenceElement = holder.getReferenceElement()) != null ? referenceElement.resolve() : null) : PsiUtil.getContextClass(this);
        if (resolved instanceof PsiClass) {
            PsiType[] parameterTypes = this.getParameterList().getParameterTypes();
            PsiClassType thisType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(resolved, PsiSubstitutor.EMPTY);
            MethodResolverProcessor processor = new MethodResolverProcessor(name, this, false, (PsiType)thisType, parameterTypes, PsiType.EMPTY_ARRAY);
            resolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
            if (processor.hasApplicableCandidates()) {
                return processor.getCandidates()[0].getElement();
            }
            MethodResolverProcessor constructorProcessor = new MethodResolverProcessor(name, this, true, (PsiType)thisType, parameterTypes, PsiType.EMPTY_ARRAY);
            resolved.processDeclarations((PsiScopeProcessor)constructorProcessor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
            if (constructorProcessor.hasApplicableCandidates()) {
                return constructorProcessor.getCandidates()[0].getElement();
            }
        }
        return null;
    }

    @Override
    protected ResolveResult[] multiResolveImpl() {
        GrCodeReferenceElement referenceElement;
        String name = this.getReferenceName();
        GrDocReferenceElement holder = this.getReferenceHolder();
        Object resolved = holder != null ? ((referenceElement = holder.getReferenceElement()) != null ? referenceElement.resolve() : null) : PsiUtil.getContextClass(this);
        if (resolved instanceof PsiClass) {
            PsiType[] parameterTypes = this.getParameterList().getParameterTypes();
            PsiClassType thisType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(resolved, PsiSubstitutor.EMPTY);
            MethodResolverProcessor processor = new MethodResolverProcessor(name, this, false, (PsiType)thisType, parameterTypes, PsiType.EMPTY_ARRAY);
            MethodResolverProcessor constructorProcessor = new MethodResolverProcessor(name, this, true, (PsiType)thisType, parameterTypes, PsiType.EMPTY_ARRAY);
            resolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
            resolved.processDeclarations((PsiScopeProcessor)constructorProcessor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
            return (ResolveResult[])ArrayUtil.mergeArrays((Object[])processor.getCandidates(), (Object[])constructorProcessor.getCandidates());
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            GrDocMethodReferenceImpl.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiNamedElement && Comparing.equal((String)((PsiNamedElement)element).getName(), (String)this.getReferenceName())) {
            return this.getManager().areElementsEquivalent(element, this.resolve());
        }
        return false;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement resolved;
        if (newElementName == null) {
            GrDocMethodReferenceImpl.$$$reportNull$$$0(4);
        }
        if ((resolved = this.resolve()) instanceof PsiMethod) {
            String newPropertyName;
            PsiMethod method = (PsiMethod)resolved;
            String oldName = this.getReferenceName();
            if (!method.getName().equals(oldName) && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method) && (newPropertyName = PropertyUtilBase.getPropertyName((String)newElementName)) != null) {
                return super.handleElementRename(newPropertyName);
            }
        }
        return super.handleElementRename(newElementName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocMethodReferenceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocMethodReferenceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

