/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrFlowInterruptingStatement;

public class GrLabelReference
implements PsiReference {
    private GrFlowInterruptingStatement myStatement;

    public GrLabelReference(GrFlowInterruptingStatement statement) {
        this.myStatement = statement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            GrLabelReference.$$$reportNull$$$0(0);
        }
        if (element instanceof GrLabeledStatement) {
            this.myStatement = this.handleElementRename(((GrLabeledStatement)element).getName());
        }
        throw new IncorrectOperationException("Can't bind not to labeled statement");
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement identifier = this.myStatement.getLabelIdentifier();
        if (identifier == null) {
            return new TextRange(-1, -2);
        }
        int offsetInParent = identifier.getStartOffsetInParent();
        return new TextRange(offsetInParent, offsetInParent + identifier.getTextLength());
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            GrLabelReference.$$$reportNull$$$0(1);
        }
        return this.resolve() == element;
    }

    @NotNull
    public String getCanonicalText() {
        String name = this.myStatement.getLabelName();
        if (name == null) {
            return "";
        }
        String string = name;
        if (string == null) {
            GrLabelReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public GrFlowInterruptingStatement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            GrLabelReference.$$$reportNull$$$0(3);
        }
        if (this.myStatement instanceof GrBreakStatement) {
            this.myStatement = (GrFlowInterruptingStatement)this.myStatement.replaceWithStatement(GroovyPsiElementFactory.getInstance(this.myStatement.getProject()).createStatementFromText("break " + newElementName));
        } else if (this.myStatement instanceof GrContinueStatement) {
            this.myStatement = (GrFlowInterruptingStatement)this.myStatement.replaceWithStatement(GroovyPsiElementFactory.getInstance(this.myStatement.getProject()).createStatementFromText("continue " + newElementName));
        }
        return this.myStatement;
    }

    public Object @NotNull [] getVariants() {
        ArrayList<GrFlowInterruptingStatement> result2 = new ArrayList<GrFlowInterruptingStatement>();
        for (GrFlowInterruptingStatement context = this.myStatement; context != null; context = context.getContext()) {
            if (!(context instanceof GrLabeledStatement)) continue;
            result2.add(context);
        }
        Object[] objectArray = ArrayUtil.toObjectArray(result2);
        if (objectArray == null) {
            GrLabelReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public GrFlowInterruptingStatement getElement() {
        GrFlowInterruptingStatement grFlowInterruptingStatement = this.myStatement;
        if (grFlowInterruptingStatement == null) {
            GrLabelReference.$$$reportNull$$$0(5);
        }
        return grFlowInterruptingStatement;
    }

    public PsiElement resolve() {
        return this.myStatement.resolveLabel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrLabelReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrLabelReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

