/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrSuperReferenceResolver {
    @Nullable(value="null if ref is not 'super' reference")
    public static @Nullable(value="null if ref is not 'super' reference") Collection<GroovyResolveResult> resolveSuperExpression(@NotNull GrReferenceExpression ref) {
        GroovyResolveResult result2;
        PsiElement resolved;
        GrExpression qualifier;
        if (ref == null) {
            GrSuperReferenceResolver.$$$reportNull$$$0(0);
        }
        if ((qualifier = (GrExpression)ref.getQualifier()) == null) {
            PsiClass aClass = PsiUtil.getContextClass(ref);
            if (aClass != null) {
                return GrSuperReferenceResolver.getSuperClass(aClass);
            }
        } else if (qualifier instanceof GrReferenceExpression && (resolved = (result2 = ((GrReferenceExpression)qualifier).advancedResolve()).getElement()) instanceof PsiClass) {
            PsiClass superClass = (PsiClass)resolved;
            GrTypeDefinition scopeClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)ref, GrTypeDefinition.class, (boolean)true);
            if (scopeClass != null && GrTraitUtil.isTrait(superClass) && scopeClass.isInheritor(superClass, false)) {
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)scopeClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return Collections.singletonList(new GroovyResolveResultImpl((PsiElement)superClass, null, null, superClassSubstitutor, true, true));
            }
            if (PsiUtil.hasEnclosingInstanceInScope(superClass, ref, false)) {
                return GrSuperReferenceResolver.getSuperClass(superClass);
            }
        }
        return null;
    }

    @NotNull
    private static Collection<GroovyResolveResult> getSuperClass(@NotNull PsiClass aClass) {
        PsiClass superClass;
        if (aClass == null) {
            GrSuperReferenceResolver.$$$reportNull$$$0(1);
        }
        if ((superClass = aClass.getSuperClass()) != null) {
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            List<GroovyResolveResult> list = Collections.singletonList(new GroovyResolveResultImpl((PsiElement)superClass, null, null, superClassSubstitutor, true, true));
            if (list == null) {
                GrSuperReferenceResolver.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<GroovyResolveResult> list = Collections.emptyList();
        if (list == null) {
            GrSuperReferenceResolver.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrSuperReferenceResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrSuperReferenceResolver";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveSuperExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

