/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.ObjectUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrAbstractLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralEscaper;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.LiteralUtilKt;

public class GrLiteralImpl
extends GrAbstractLiteral
implements GrLiteral,
PsiLanguageInjectionHost {
    private static final Logger LOG = Logger.getInstance(GrLiteralImpl.class);

    public GrLiteralImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrLiteralImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String toString() {
        return "Literal";
    }

    @Override
    public PsiType getType() {
        IElementType elemType = GrLiteralImpl.getLiteralType(this);
        return TypesUtil.getPsiType(this, elemType);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrLiteralImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitLiteralExpression(this);
    }

    public Object getValue() {
        return GrLiteralImpl.getLiteralValue(this.getFirstChild());
    }

    public static Object getLiteralValue(PsiElement child) {
        IElementType elemType = child.getNode().getElementType();
        String text = child.getText();
        if (TokenSets.NUMBERS.contains(elemType)) {
            try {
                if (elemType == GroovyTokenTypes.mNUM_INT) {
                    char lastChar = text.charAt(text.length() - 1);
                    if (lastChar == 'i' || lastChar == 'I') {
                        text = text.substring(0, text.length() - 1);
                    }
                    return LiteralUtilKt.parseInteger(text);
                }
                if (elemType == GroovyTokenTypes.mNUM_LONG) {
                    return PsiLiteralUtil.parseLong((String)text);
                }
                if (elemType == GroovyTokenTypes.mNUM_FLOAT) {
                    return PsiLiteralUtil.parseFloat((String)text);
                }
                if (elemType == GroovyTokenTypes.mNUM_DOUBLE) {
                    return PsiLiteralUtil.parseDouble((String)text);
                }
                if (elemType == GroovyTokenTypes.mNUM_BIG_INT) {
                    return new BigInteger(text.substring(0, text.length() - 1));
                }
                if (elemType == GroovyTokenTypes.mNUM_BIG_DECIMAL) {
                    char lastChar = text.charAt(text.length() - 1);
                    if (lastChar == 'g' || lastChar == 'G') {
                        return new BigDecimal(text.substring(0, text.length() - 1));
                    }
                    return new BigDecimal(text);
                }
            }
            catch (NumberFormatException lastChar) {}
        } else {
            if (elemType == GroovyTokenTypes.kFALSE) {
                return Boolean.FALSE;
            }
            if (elemType == GroovyTokenTypes.kTRUE) {
                return Boolean.TRUE;
            }
            if (elemType == GroovyElementTypes.STRING_SQ || elemType == GroovyElementTypes.STRING_TSQ) {
                StringBuilder chars2;
                if (!text.startsWith("'")) {
                    return null;
                }
                boolean result2 = GrStringUtil.parseStringCharacters(text = GrStringUtil.removeQuotes(text), chars2 = new StringBuilder(text.length()), null);
                return result2 ? chars2.toString() : null;
            }
            if (elemType == GroovyElementTypes.STRING_DQ || elemType == GroovyElementTypes.STRING_TDQ) {
                StringBuilder chars3;
                if (!text.startsWith("\"")) {
                    return null;
                }
                boolean result3 = GrStringUtil.parseStringCharacters(text = GrStringUtil.removeQuotes(text), chars3 = new StringBuilder(text.length()), null);
                return result3 ? chars3.toString() : null;
            }
            if (elemType == GroovyTokenTypes.mREGEX_LITERAL) {
                StringBuilder chars4;
                PsiElement cchild = child.getFirstChild();
                if (cchild == null) {
                    return null;
                }
                PsiElement sibling = cchild.getNextSibling();
                if (sibling == null) {
                    return null;
                }
                text = sibling.getText();
                boolean result4 = GrStringUtil.parseRegexCharacters(text, chars4 = new StringBuilder(text.length()), null, true);
                return result4 ? chars4.toString() : null;
            }
            if (elemType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
                StringBuilder chars5;
                PsiElement cchild = child.getFirstChild();
                if (cchild == null) {
                    return null;
                }
                PsiElement sibling = cchild.getNextSibling();
                if (sibling == null) {
                    return null;
                }
                text = sibling.getText();
                boolean result5 = GrStringUtil.parseRegexCharacters(text, chars5 = new StringBuilder(text.length()), null, false);
                return result5 ? chars5.toString() : null;
            }
            if (elemType == GroovyTokenTypes.kNULL) {
                return ObjectUtils.NULL;
            }
        }
        return null;
    }

    public static IElementType getLiteralType(GrLiteral literal) {
        PsiElement firstChild = literal.getFirstChild();
        assert (firstChild != null);
        return firstChild.getNode().getElementType();
    }

    public boolean isStringLiteral() {
        PsiElement child = this.getFirstChild();
        if (child == null) {
            return false;
        }
        IElementType elementType = child.getNode().getElementType();
        return TokenSets.STRING_LITERAL_SET.contains(elementType);
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            GrLiteralImpl.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    @Nullable
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        if (references.length == 1) {
            return references[0];
        }
        if (references.length > 1) {
            return new PsiMultiReference(references, (PsiElement)this);
        }
        return null;
    }

    public boolean isValidHost() {
        Object value = this.getValue();
        return value instanceof String && !((String)value).isEmpty();
    }

    @Override
    public GrLiteralImpl updateText(@NotNull String text) {
        if (text == null) {
            GrLiteralImpl.$$$reportNull$$$0(3);
        }
        GrExpression newExpr = GroovyPsiElementFactory.getInstance(this.getProject()).createExpressionFromText(text);
        LOG.assertTrue(newExpr instanceof GrLiteral, (Object)text);
        LOG.assertTrue(newExpr.getFirstChild() != null, (Object)text);
        ASTNode valueNode = this.getNode().getFirstChildNode();
        this.getNode().replaceChild(valueNode, newExpr.getFirstChild().getNode());
        return this;
    }

    @NotNull
    public LiteralTextEscaper<GrLiteralContainer> createLiteralTextEscaper() {
        return new GrLiteralEscaper(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

