/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnonymousClassIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullClassNameIndex;

public abstract class GrTypeDefinitionElementType<TypeDef extends GrTypeDefinition>
extends GrStubElementType<GrTypeDefinitionStub, TypeDef> {
    public GrTypeDefinitionElementType(@NotNull String debugName) {
        if (debugName == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    @NotNull
    public GrTypeDefinitionStub createStub(@NotNull TypeDef psi, StubElement parentStub) {
        if (psi == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(1);
        }
        byte flags = GrTypeDefinitionStub.buildFlags(psi);
        return new GrTypeDefinitionStub(parentStub, psi.getName(), GrStubUtils.getBaseClassName(psi), this, psi.getQualifiedName(), GrStubUtils.getAnnotationNames(psi), flags);
    }

    public void serialize(@NotNull GrTypeDefinitionStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(3);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getQualifiedName());
        dataStream.writeByte((int)stub.getFlags());
        dataStream.writeName(stub.getBaseClassName());
        GrStubUtils.writeStringArray(dataStream, stub.getAnnotations());
    }

    @NotNull
    public GrTypeDefinitionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(4);
        }
        String name = dataStream.readNameString();
        String qname = dataStream.readNameString();
        byte flags = dataStream.readByte();
        String baseClassName = dataStream.readNameString();
        String[] annos = GrStubUtils.readStringArray(dataStream);
        return new GrTypeDefinitionStub(parentStub, name, baseClassName, this, qname, annos, flags);
    }

    @Override
    public void indexStub(@NotNull GrTypeDefinitionStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(6);
        }
        if (stub.isAnonymous()) {
            String baseClassName = stub.getBaseClassName();
            if (baseClassName != null) {
                String shortName = PsiNameHelper.getShortClassName((String)baseClassName);
                sink.occurrence(GrAnonymousClassIndex.KEY, (Object)shortName);
            }
        } else {
            String fqn;
            String shortName = stub.getName();
            if (shortName != null) {
                sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)shortName);
            }
            if ((fqn = stub.getQualifiedName()) != null) {
                sink.occurrence(GrFullClassNameIndex.KEY, (Object)fqn.hashCode());
            }
        }
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

