/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyResolveScopeProvider
extends ResolveScopeProvider {
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            GroovyResolveScopeProvider.$$$reportNull$$$0(0);
        }
        if (file.getFileType() != GroovyFileType.GROOVY_FILE_TYPE) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = projectFileIndex.getModuleForFile(file);
        if (module == null) {
            return null;
        }
        boolean includeTests = projectFileIndex.isInTestSourceContent(file) || !projectFileIndex.isInSourceContent(file);
        GlobalSearchScope scope = projectFileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.RESOURCES) ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)includeTests) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
        PsiFile psi = PsiManager.getInstance((Project)project).findFile(file);
        if (psi instanceof GroovyFile && ((GroovyFile)psi).isScript()) {
            return GroovyScriptTypeDetector.patchResolveScope((GroovyFile)psi, scope);
        }
        return scope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/lang/resolve/GroovyResolveScopeProvider", "getResolveScope"));
    }
}

