/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.delegatesTo;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureAsAnonymousParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.FromStringHintProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToProvider;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\f\u001a&\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u001a \u0010\u001e\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0010\u0010\"\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0010\u0010#\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010%\u001a$\u0010&\u001a\u0004\u0018\u00010\u00172\b\u0010'\u001a\u0004\u0018\u00010\u00172\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u000eH\u0002\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006*"}, d2={"DELEGATES_TO_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "DELEGATES_TO_STRATEGY_KEY", "", "DELEGATES_TO_TYPE_KEY", "", "defaultDelegatesToInfo", "getDefaultDelegatesToInfo", "()Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "doGetDelegatesToInfo", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "findTargetParameter", "Lcom/intellij/psi/PsiParameter;", "list", "Lcom/intellij/psi/PsiParameterList;", "target", "getContainingCall", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;", "getDelegatesToInfo", "closure", "getFromTarget", "Lcom/intellij/psi/PsiType;", "parameterList", "delegatesTo", "Lcom/intellij/psi/PsiAnnotation;", "mapping", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ArgumentMapping;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/PsiCallParameter;", "getFromType", "call", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "getFromValue", "getStrategyValue", "strategy", "Lcom/intellij/psi/PsiAnnotationMemberValue;", "inferGenericArgType", "targetType", "genericIndex", "param", "intellij.groovy.psi"})
public final class GrDelegatesToUtilKt {
    @JvmField
    @NotNull
    public static final Key<DelegatesToInfo> DELEGATES_TO_KEY;
    @JvmField
    @NotNull
    public static final Key<String> DELEGATES_TO_TYPE_KEY;
    @JvmField
    @NotNull
    public static final Key<Integer> DELEGATES_TO_STRATEGY_KEY;
    @NotNull
    private static final DelegatesToInfo defaultDelegatesToInfo;

    @NotNull
    public static final DelegatesToInfo getDefaultDelegatesToInfo() {
        return defaultDelegatesToInfo;
    }

    @Nullable
    public static final DelegatesToInfo getDelegatesToInfo(@NotNull GrFunctionalExpression closure) {
        Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
        return (DelegatesToInfo)CachedValuesManager.getCachedValue((PsiElement)closure, (CachedValueProvider)new CachedValueProvider<T>(closure){
            final /* synthetic */ GrFunctionalExpression $closure;

            @NotNull
            public final CachedValueProvider.Result<DelegatesToInfo> compute() {
                return CachedValueProvider.Result.create((Object)GrDelegatesToUtilKt.access$doGetDelegatesToInfo(this.$closure), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            {
                this.$closure = grFunctionalExpression;
            }
        });
    }

    private static final DelegatesToInfo doGetDelegatesToInfo(GrFunctionalExpression expression) {
        ExtensionPointName<GrDelegatesToProvider> extensionPointName = GrDelegatesToProvider.EP_NAME;
        Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"GrDelegatesToProvider.EP_NAME");
        for (GrDelegatesToProvider ext : (GrDelegatesToProvider[])extensionPointName.getExtensions()) {
            DelegatesToInfo info = ext.getDelegatesToInfo(expression);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Nullable
    public static final GrCall getContainingCall(@NotNull GrFunctionalExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        PsiElement parent2 = expression.getParent();
        if (parent2 instanceof GrCall) {
            GrFunctionalExpression[] grFunctionalExpressionArray = ((GrCall)parent2).getClosureArguments();
            if (ArrayUtil.contains((Object)expression, (Object[])Arrays.copyOf(grFunctionalExpressionArray, grFunctionalExpressionArray.length))) {
                return (GrCall)parent2;
            }
        }
        if (parent2 instanceof GrArgumentList) {
            PsiElement grandParent = ((GrArgumentList)parent2).getParent();
            PsiElement psiElement = grandParent;
            if (!(psiElement instanceof GrCall)) {
                psiElement = null;
            }
            return (GrCall)psiElement;
        }
        return null;
    }

    @Nullable
    public static final PsiType getFromValue(@NotNull PsiAnnotation delegatesTo) {
        Intrinsics.checkParameterIsNotNull((Object)delegatesTo, (String)"delegatesTo");
        PsiAnnotationMemberValue value = delegatesTo.findDeclaredAttributeValue("value");
        if (value instanceof GrReferenceExpression) {
            return ResolveUtil.unwrapClassType(((GrReferenceExpression)value).getType());
        }
        if (value instanceof PsiClassObjectAccessExpression) {
            return ResolveUtil.unwrapClassType(((PsiClassObjectAccessExpression)value).getType());
        }
        if (value == null || value instanceof PsiLiteralExpression && ((PsiLiteralExpression)value).getType() == PsiType.NULL || value instanceof GrLiteral && ((GrLiteral)value).getType() == PsiType.NULL) {
            return null;
        }
        if (value instanceof PsiExpression) {
            return ((PsiExpression)value).getType();
        }
        return null;
    }

    @Nullable
    public static final PsiType getFromTarget(@NotNull PsiParameterList parameterList, @NotNull PsiAnnotation delegatesTo, @NotNull ArgumentMapping<? extends PsiCallParameter> mapping2) {
        Argument argument;
        Object v3;
        PsiParameter parameter;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)parameterList, (String)"parameterList");
            Intrinsics.checkParameterIsNotNull((Object)delegatesTo, (String)"delegatesTo");
            Intrinsics.checkParameterIsNotNull(mapping2, (String)"mapping");
            String string = GrAnnotationUtil.inferStringAttribute(delegatesTo, "target");
            if (string == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GrAnnotationUtil.inferSt\u2026 \"target\") ?: return null");
            String target = string;
            PsiParameter psiParameter = GrDelegatesToUtilKt.findTargetParameter(parameterList, target);
            if (psiParameter == null) {
                return null;
            }
            parameter = psiParameter;
            Iterable $this$firstOrNull$iv = mapping2.getArguments();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Argument it = (Argument)element$iv;
                boolean bl = false;
                PsiCallParameter psiCallParameter = mapping2.targetParameter(it);
                if (!Intrinsics.areEqual((Object)(psiCallParameter != null ? psiCallParameter.getPsi() : null), (Object)parameter)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        if ((argument = (Argument)v3) == null || (argument = argument.getType()) == null) {
            return null;
        }
        Argument type2 = argument;
        Integer index = GrAnnotationUtil.inferIntegerAttribute(delegatesTo, "genericTypeIndex");
        return index != null ? GrDelegatesToUtilKt.inferGenericArgType((PsiType)type2, index, parameter) : type2;
    }

    private static final PsiType inferGenericArgType(PsiType targetType, int genericIndex, PsiParameter param) {
        PsiTypeParameter[] typeParameters;
        if (!(targetType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)targetType).resolveGenerics();
        Intrinsics.checkExpressionValueIsNotNull((Object)classResolveResult, (String)"targetType.resolveGenerics()");
        PsiClassType.ClassResolveResult result2 = classResolveResult;
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"result.element ?: return null");
        PsiClass psiClass2 = psiClass;
        PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"result.substitutor");
        PsiSubstitutor substitutor = psiSubstitutor;
        PsiType psiType = param.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"param.type");
        PsiType baseType = psiType;
        PsiClass baseClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)baseType);
        if (baseClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass2, (PsiClass)baseClass, (boolean)true) && genericIndex < (typeParameters = baseClass.getTypeParameters()).length) {
            PsiSubstitutor psiSubstitutor2 = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)psiClass2, (PsiSubstitutor)substitutor);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor2, (String)"TypeConversionUtil.getSu\u2026s, psiClass, substitutor)");
            PsiSubstitutor superClassSubstitutor = psiSubstitutor2;
            return superClassSubstitutor.substitute(typeParameters[genericIndex]);
        }
        return null;
    }

    @Nullable
    public static final PsiParameter findTargetParameter(@NotNull PsiParameterList list, @NotNull String target) {
        PsiParameter[] parameters2;
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        PsiParameter[] psiParameterArray = parameters2 = list.getParameters();
        int n = psiParameterArray.length;
        for (int i = 0; i < n; ++i) {
            String value;
            PsiAnnotation targetAnnotation;
            PsiModifierList modifierList;
            PsiParameter parameter;
            PsiParameter psiParameter = parameter = psiParameterArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameter");
            if (psiParameter.getModifierList() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)modifierList, (String)"parameter.modifierList ?: continue");
            if (modifierList.findAnnotation("groovy.lang.DelegatesTo.Target") == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)targetAnnotation, (String)"modifierList.findAnnotat\u2026ES_TO_TARGET) ?: continue");
            if (GrAnnotationUtil.inferStringAttribute(targetAnnotation, "value") == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"GrAnnotationUtil.inferSt\u2026ion, \"value\") ?: continue");
            if (!Intrinsics.areEqual((Object)value, (Object)target)) continue;
            return parameter;
        }
        return null;
    }

    @Nullable
    public static final PsiType getFromType(@NotNull GrCall call, @NotNull GroovyResolveResult result2, @NotNull PsiAnnotation delegatesTo) {
        Object object;
        PsiType type2;
        block8: {
            block6: {
                block7: {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
                    Intrinsics.checkParameterIsNotNull((Object)delegatesTo, (String)"delegatesTo");
                    PsiElement psiElement = result2.getElement();
                    if (!(psiElement instanceof PsiMethod)) {
                        psiElement = null;
                    }
                    PsiMethod psiMethod = (PsiMethod)psiElement;
                    if (psiMethod == null) {
                        return null;
                    }
                    PsiMethod element = psiMethod;
                    String string = GrAnnotationUtil.inferStringAttribute(delegatesTo, "type");
                    if (string == null) {
                        return null;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GrAnnotationUtil.inferSt\u2026o, \"type\") ?: return null");
                    String typeValue = string;
                    if (StringsKt.isBlank((CharSequence)typeValue)) {
                        return null;
                    }
                    PsiElement psiElement2 = FromStringHintProcessor.createContext(element);
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"FromStringHintProcessor.createContext(element)");
                    PsiElement context = psiElement2;
                    PsiType psiType = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(typeValue, context);
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"JavaPsiFacade.getElement\u2026mText(typeValue, context)");
                    type2 = psiType;
                    if (!(result2 instanceof GroovyMethodResult)) break block6;
                    object = ((GroovyMethodResult)result2).getCandidate();
                    if (object == null) break block7;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object candidate = object2;
                    boolean bl3 = false;
                    Object object3 = candidate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"candidate");
                    object = ClosureAsAnonymousParameterEnhancer.Companion.substitutorIgnoringClosures(call, (GroovyMethodCandidate)object3, (GroovyMethodResult)result2);
                    if (object != null) break block8;
                }
                PsiSubstitutor psiSubstitutor = ((GroovyMethodResult)result2).getPartialSubstitutor();
                object = psiSubstitutor;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"result.partialSubstitutor");
                break block8;
            }
            PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
            object = psiSubstitutor;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"result.substitutor");
        }
        Object substitutor = object;
        return substitutor.substitute(type2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final int getStrategyValue(@Nullable PsiAnnotationMemberValue strategy) {
        String text;
        if (strategy == null) {
            return 0;
        }
        String string = text = strategy.getText();
        if (string != null) {
            switch (string) {
                case "0": {
                    return 0;
                }
                case "1": {
                    return 1;
                }
                case "2": {
                    return 2;
                }
                case "3": {
                    return 3;
                }
                case "4": {
                    return 4;
                }
            }
        }
        String string2 = text;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
        if (StringsKt.endsWith$default((String)string2, (String)"OWNER_FIRST", (boolean)false, (int)2, null)) {
            return 0;
        }
        if (StringsKt.endsWith$default((String)text, (String)"DELEGATE_FIRST", (boolean)false, (int)2, null)) {
            return 1;
        }
        if (StringsKt.endsWith$default((String)text, (String)"OWNER_ONLY", (boolean)false, (int)2, null)) {
            return 2;
        }
        if (StringsKt.endsWith$default((String)text, (String)"DELEGATE_ONLY", (boolean)false, (int)2, null)) {
            return 3;
        }
        if (!StringsKt.endsWith$default((String)text, (String)"TO_SELF", (boolean)false, (int)2, null)) return 0;
        return 4;
    }

    static {
        Key key = Key.create((String)"groovy.closure.delegatesTo");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"groovy.closure.delegatesTo\")");
        DELEGATES_TO_KEY = key;
        Key key2 = Key.create((String)"groovy.closure.delegatesTo.type");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<String>(\"groo\u2026losure.delegatesTo.type\")");
        DELEGATES_TO_TYPE_KEY = key2;
        Key key3 = Key.create((String)"groovy.closure.delegatesTo.strategy");
        Intrinsics.checkExpressionValueIsNotNull((Object)key3, (String)"Key.create<Int>(\"groovy.\u2026re.delegatesTo.strategy\")");
        DELEGATES_TO_STRATEGY_KEY = key3;
        defaultDelegatesToInfo = new DelegatesToInfo(null, 2);
    }

    public static final /* synthetic */ DelegatesToInfo access$doGetDelegatesToInfo(GrFunctionalExpression expression) {
        return GrDelegatesToUtilKt.doGetDelegatesToInfo(expression);
    }
}

