/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.java.PsiLocalVariableImpl;
import com.intellij.psi.scope.ElementClassHint;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class ResolverProcessorImpl
extends ResolverProcessor<GroovyResolveResult> {
    private Set<String> myProcessedClasses;
    private final PsiType[] myTypeArguments;

    protected ResolverProcessorImpl(@Nullable String name, @NotNull EnumSet<ElementClassHint.DeclarationKind> resolveTargets, @NotNull PsiElement place, PsiType @NotNull [] typeArguments) {
        if (resolveTargets == null) {
            ResolverProcessorImpl.$$$reportNull$$$0(0);
        }
        if (place == null) {
            ResolverProcessorImpl.$$$reportNull$$$0(1);
        }
        if (typeArguments == null) {
            ResolverProcessorImpl.$$$reportNull$$$0(2);
        }
        super(name, resolveTargets, place);
        this.myTypeArguments = typeArguments;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            ResolverProcessorImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            ResolverProcessorImpl.$$$reportNull$$$0(4);
        }
        if (element instanceof PsiLocalVariableImpl) {
            return true;
        }
        if (this.myResolveTargetKinds == null || this.myResolveTargetKinds.contains(ResolverProcessorImpl.getDeclarationKind(element))) {
            if (element instanceof PsiVariable && !(element instanceof PsiField) && this.myName != null && !this.myName.equals(((PsiVariable)element).getName())) {
                return true;
            }
            PsiNamedElement namedElement = (PsiNamedElement)element;
            PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
            if (substitutor == null) {
                substitutor = PsiSubstitutor.EMPTY;
            }
            if (this.myTypeArguments.length > 0 && namedElement instanceof PsiClass) {
                substitutor = substitutor.putAll((PsiClass)namedElement, this.myTypeArguments);
            }
            if (namedElement instanceof PsiClass && !(namedElement instanceof PsiTypeParameter)) {
                PsiClass aClass = (PsiClass)namedElement;
                if (this.myProcessedClasses == null) {
                    this.myProcessedClasses = new HashSet<String>();
                }
                if (!this.myProcessedClasses.add(aClass.getQualifiedName())) {
                    return true;
                }
            }
            boolean isAccessible = this.isAccessible(namedElement);
            PsiElement resolveContext = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
            SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
            boolean isStaticsOK = this.isStaticsOK(namedElement, resolveContext, false);
            this.addCandidate(new GroovyResolveResultImpl((PsiElement)namedElement, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK));
            return !isAccessible || !isStaticsOK;
        }
        return true;
    }

    private static ElementClassHint.DeclarationKind getDeclarationKind(PsiElement element) {
        if (element instanceof PsiMethod) {
            return ElementClassHint.DeclarationKind.METHOD;
        }
        if (element instanceof PsiEnumConstant) {
            return ElementClassHint.DeclarationKind.ENUM_CONST;
        }
        if (element instanceof PsiField) {
            return ElementClassHint.DeclarationKind.FIELD;
        }
        if (element instanceof PsiVariable) {
            return ElementClassHint.DeclarationKind.VARIABLE;
        }
        if (element instanceof PsiClass) {
            return ElementClassHint.DeclarationKind.CLASS;
        }
        if (element instanceof PsiPackage) {
            return ElementClassHint.DeclarationKind.PACKAGE;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveTargets";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

