/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.surroundWith;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.surroundWith.GroovyManyStatementsSurrounder;

public class IfSurrounder
extends GroovyManyStatementsSurrounder {
    @Override
    protected GroovyPsiElement doSurroundElements(PsiElement[] elements, PsiElement context) throws IncorrectOperationException {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(elements[0].getProject());
        GrIfStatement ifStatement = (GrIfStatement)factory.createStatementFromText("if (a) {\n}", context);
        IfSurrounder.addStatements(((GrBlockStatement)ifStatement.getThenBranch()).getBlock(), elements);
        return ifStatement;
    }

    @Override
    protected TextRange getSurroundSelectionRange(GroovyPsiElement element) {
        assert (element instanceof GrIfStatement);
        GrExpression condition = ((GrIfStatement)element).getCondition();
        int endOffset = element.getTextRange().getEndOffset();
        if (condition != null) {
            PsiElement child = condition.getFirstChild();
            assert (child != null);
            endOffset = child.getTextRange().getStartOffset();
            condition.getParent().getNode().removeChild(condition.getNode());
        }
        return new TextRange(endOffset, endOffset);
    }

    public String getTemplateDescription() {
        return "if";
    }
}

