/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.JavaCodeFragmentTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureDialog;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterTableModelItem;
import org.jetbrains.plugins.groovy.refactoring.ui.GrCodeFragmentTableCellEditor;

public class GrParameterTableModel
extends ParameterTableModelBase<GrParameterInfo, GrParameterTableModelItem> {
    public GrParameterTableModel(PsiElement typeContext, PsiElement defaultValueContext, final GrChangeSignatureDialog dialog) {
        this(typeContext, defaultValueContext, new ColumnInfo[]{new GrTypeColumn(typeContext.getProject()), new ParameterTableModelBase.NameColumn(typeContext.getProject(), "Name"), new GrInitializerColumn(typeContext.getProject()), new GrDefaultValueColumn(typeContext.getProject()), new ParameterTableModelBase.AnyVarColumn<GrParameterInfo, GrParameterTableModelItem>(){

            public boolean isCellEditable(GrParameterTableModelItem item) {
                boolean isGenerateDelegate = dialog.isGenerateDelegate();
                return !isGenerateDelegate && super.isCellEditable((ParameterTableModelItemBase)item);
            }
        }});
    }

    private GrParameterTableModel(PsiElement typeContext, PsiElement defaultValueContext, ColumnInfo ... columnInfos) {
        super(typeContext, defaultValueContext, columnInfos);
    }

    protected GrParameterTableModelItem createRowItem(@Nullable GrParameterInfo parameterInfo) {
        return GrParameterTableModelItem.create(parameterInfo, this.myTypeContext.getProject(), this.myDefaultValueContext);
    }

    private static class GrInitializerColumn
    extends GrDefaultValueColumn {
        GrInitializerColumn(Project project) {
            super(project);
        }

        public String getName() {
            return "Default initializer";
        }

        public boolean isCellEditable(GrParameterTableModelItem item) {
            return true;
        }

        public PsiCodeFragment valueOf(GrParameterTableModelItem item) {
            return item.initializerCodeFragment;
        }
    }

    private static class GrDefaultValueColumn
    extends ParameterTableModelBase.DefaultValueColumn<GrParameterInfo, GrParameterTableModelItem> {
        private final Project myProject;

        GrDefaultValueColumn(Project project) {
            super(project, (FileType)GroovyFileType.GROOVY_FILE_TYPE);
            this.myProject = project;
        }

        public TableCellEditor doCreateEditor(GrParameterTableModelItem item) {
            return new GrCodeFragmentTableCellEditor(this.myProject);
        }
    }

    private static class GrTypeColumn
    extends ParameterTableModelBase.TypeColumn<GrParameterInfo, GrParameterTableModelItem> {
        GrTypeColumn(Project project) {
            super(project, (FileType)GroovyFileType.GROOVY_FILE_TYPE, "Type");
        }

        public TableCellEditor doCreateEditor(GrParameterTableModelItem o) {
            return new JavaCodeFragmentTableCellEditor(this.myProject);
        }
    }
}

