/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.constant;

import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrAbstractInplaceIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GroovyInplaceFieldValidator;

public class GrInplaceConstantIntroducer
extends GrAbstractInplaceIntroducer<GrIntroduceConstantSettings> {
    private final GrInplaceIntroduceConstantPanel myPanel;
    private final GrIntroduceContext myContext;
    private final String[] mySuggestedNames;

    public GrInplaceConstantIntroducer(GrIntroduceContext context, OccurrencesChooser.ReplaceChoice choice) {
        super(IntroduceConstantHandler.getRefactoringNameText(), choice, context);
        this.myContext = context;
        this.myPanel = new GrInplaceIntroduceConstantPanel();
        GrVariable localVar = GrIntroduceHandlerBase.resolveLocalVar(context);
        if (localVar != null) {
            ArrayList result2 = ContainerUtil.newArrayList((Object[])new String[]{localVar.getName()});
            GrExpression initializer = localVar.getInitializerGroovy();
            if (initializer != null) {
                ContainerUtil.addAll((Collection)result2, (Object[])GroovyNameSuggestionUtil.suggestVariableNames(initializer, new GroovyInplaceFieldValidator(context), true));
            }
            this.mySuggestedNames = ArrayUtilRt.toStringArray((Collection)result2);
        } else {
            GrExpression expression = context.getExpression();
            assert (expression != null);
            this.mySuggestedNames = GroovyNameSuggestionUtil.suggestVariableNames(expression, new GroovyInplaceFieldValidator(context), true);
        }
    }

    protected String getActionName() {
        return "Introduce Constant";
    }

    protected String @NotNull [] suggestNames(boolean replaceAll, @Nullable GrVariable variable) {
        if (this.mySuggestedNames == null) {
            GrInplaceConstantIntroducer.$$$reportNull$$$0(0);
        }
        return this.mySuggestedNames;
    }

    @Nullable
    protected JComponent getComponent() {
        return this.myPanel.getRootPane();
    }

    protected void saveSettings(@NotNull GrVariable variable) {
        if (variable == null) {
            GrInplaceConstantIntroducer.$$$reportNull$$$0(1);
        }
    }

    @Override
    protected GrVariable runRefactoring(GrIntroduceContext context, GrIntroduceConstantSettings settings, boolean processUsages) {
        return this.refactorInWriteAction((Computable<GrVariable>)((Computable)() -> {
            if (processUsages) {
                return new GrIntroduceConstantProcessor(context, settings).run();
            }
            PsiElement scope = context.getScope();
            return new GrIntroduceConstantProcessor(context, settings).addDeclaration(scope instanceof GroovyFileBase ? ((GroovyFileBase)scope).getScriptClass() : (PsiClass)scope).getVariables()[0];
        }));
    }

    @Override
    @Nullable
    protected GrIntroduceConstantSettings getInitialSettingsForInplace(final @NotNull GrIntroduceContext context, @NotNull OccurrencesChooser.ReplaceChoice choice, final String[] names) {
        if (context == null) {
            GrInplaceConstantIntroducer.$$$reportNull$$$0(2);
        }
        if (choice == null) {
            GrInplaceConstantIntroducer.$$$reportNull$$$0(3);
        }
        return new GrIntroduceConstantSettings(){

            @Override
            public String getVisibilityModifier() {
                return "public";
            }

            @Override
            @Nullable
            public PsiClass getTargetClass() {
                return (PsiClass)context.getScope();
            }

            @Override
            @Nullable
            public String getName() {
                return names[0];
            }

            @Override
            public boolean replaceAllOccurrences() {
                return GrInplaceConstantIntroducer.this.isReplaceAllOccurrences();
            }

            @Override
            @Nullable
            public PsiType getSelectedType() {
                GrExpression expression = context.getExpression();
                GrVariable var = context.getVar();
                StringPartInfo stringPart = context.getStringPart();
                return var != null ? var.getDeclaredType() : (expression != null ? expression.getType() : (stringPart != null ? stringPart.getLiteral().getType() : null));
            }
        };
    }

    @Override
    protected GrIntroduceConstantSettings getSettings() {
        return new GrIntroduceConstantSettings(){

            @Override
            public String getVisibilityModifier() {
                return "public";
            }

            @Override
            @Nullable
            public String getName() {
                return GrInplaceConstantIntroducer.this.getInputName();
            }

            @Override
            public boolean replaceAllOccurrences() {
                return GrInplaceConstantIntroducer.this.isReplaceAllOccurrences();
            }

            @Override
            @Nullable
            public PsiType getSelectedType() {
                return GrInplaceConstantIntroducer.this.getSelectedType();
            }

            @Override
            @Nullable
            public PsiClass getTargetClass() {
                return (PsiClass)GrInplaceConstantIntroducer.this.myContext.getScope();
            }
        };
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        return ((PsiField)this.getVariable()).getContainingClass();
    }

    protected boolean performRefactoring() {
        JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_MOVE_TO_ANOTHER_CLASS = this.myPanel.isMoveToAnotherClass();
        if (this.myPanel.isMoveToAnotherClass()) {
            try {
                this.myEditor.putUserData(INTRODUCE_RESTART, (Object)true);
                this.myEditor.putUserData(ACTIVE_INTRODUCE, (Object)this);
                GrIntroduceConstantHandler constantHandler = new GrIntroduceConstantHandler();
                PsiLocalVariable localVariable = (PsiLocalVariable)this.getLocalVariable();
                constantHandler.getContextAndInvoke(this.myProject, this.myEditor, (GrExpression)this.myExpr, (GrVariable)localVariable, null);
            }
            finally {
                this.myEditor.putUserData(INTRODUCE_RESTART, (Object)false);
                this.myEditor.putUserData(ACTIVE_INTRODUCE, null);
                this.releaseResources();
                if (this.myLocalMarker != null) {
                    this.myLocalMarker.dispose();
                }
                if (this.myExprMarker != null) {
                    this.myExprMarker.dispose();
                }
            }
            return false;
        }
        return super.performRefactoring();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/constant/GrInplaceConstantIntroducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/constant/GrInplaceConstantIntroducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInitialSettingsForInplace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class GrInplaceIntroduceConstantPanel {
        private JBCheckBox myMoveToAnotherClassJBCheckBox;
        private JPanel myRootPane;
        private JComponent myPreview;

        public GrInplaceIntroduceConstantPanel() {
            this.$$$setupUI$$$();
        }

        public boolean isMoveToAnotherClass() {
            return this.myMoveToAnotherClassJBCheckBox.isSelected();
        }

        public JComponent getRootPane() {
            return this.myRootPane;
        }

        private void createUIComponents() {
            this.myPreview = GrInplaceConstantIntroducer.this.getPreviewComponent();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JPanel jPanel;
            this.createUIComponents();
            this.myRootPane = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myMoveToAnotherClassJBCheckBox = jBCheckBox = new JBCheckBox();
            jBCheckBox.setFocusable(false);
            jBCheckBox.setRequestFocusEnabled(true);
            jBCheckBox.setText("Move to another class");
            jBCheckBox.setMnemonic('M');
            jBCheckBox.setDisplayedMnemonicIndex(0);
            jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null));
            JComponent jComponent = this.myPreview;
            jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myRootPane;
        }
    }
}

