/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.BinaryPatchContentParser;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.vcsUtil.VcsFileUtil;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPatchParser {
    @NonNls
    private static final String DIFF_GIT_HEADER_LINE = "diff --git";
    @NonNls
    private static final Pattern ourGitHeaderLinePattern = Pattern.compile("diff --git\\s+(\\S+)\\s+(\\S+).*");
    @NonNls
    private static final Pattern ourIndexHeaderLinePattern = Pattern.compile("index\\s+([0-9a-fA-F]+)..([0-9a-fA-F]+).*");
    @NonNls
    private static final Pattern ourRenameFromPattern = Pattern.compile("\\s*rename from\\s+(\\S+)\\s*");
    @NonNls
    private static final Pattern ourRenameToPattern = Pattern.compile("\\s*rename to\\s+(\\S+)\\s*");
    @NonNls
    private static final Pattern ourFileStatusPattern = Pattern.compile("\\s*(new|deleted)\\s+file\\s+mode\\s*(\\d*)\\s*");
    @NonNls
    private static final Pattern ourNewFileModePattern = Pattern.compile("\\s*new\\s+mode\\s*(\\d+)\\s*");
    @NonNls
    private static final String ourGitBinaryContentStart = "GIT binary patch";
    private static final Logger LOG = Logger.getInstance(GitPatchParser.class);

    public static FilePatch parse(@NotNull String start2, @NotNull ListIterator<String> iterator, boolean saveHunks) throws PatchSyntaxException {
        if (start2 == null) {
            GitPatchParser.$$$reportNull$$$0(0);
        }
        if (iterator == null) {
            GitPatchParser.$$$reportNull$$$0(1);
        }
        TextFilePatch patch = null;
        PatchReader.PatchContentParser contentParser = new PatchReader.PatchContentParser(saveHunks);
        PatchInfo patchInfo = GitPatchParser.parseGitHeader(start2, iterator, contentParser);
        if (iterator.hasNext()) {
            String next = iterator.next();
            if (next.startsWith(ourGitBinaryContentStart)) {
                patch = BinaryPatchContentParser.readGitBinaryFormatPatch(iterator, patchInfo.myFileStatus);
            } else if (next.startsWith(DIFF_GIT_HEADER_LINE)) {
                patch = new TextFilePatch(null);
                iterator.previous();
            } else if (contentParser.testIsStart(next)) {
                patch = contentParser.readTextPatch(next, iterator, true);
            }
        }
        if (patch == null) {
            patch = new TextFilePatch(null);
        }
        GitPatchParser.applyPatchInfo(patch, patchInfo);
        return patch;
    }

    private static PatchInfo parseGitHeader(@NotNull String startLine, @NotNull ListIterator<String> iterator, @NotNull PatchReader.PatchContentParser contentParser) throws PatchSyntaxException {
        if (startLine == null) {
            GitPatchParser.$$$reportNull$$$0(2);
        }
        if (iterator == null) {
            GitPatchParser.$$$reportNull$$$0(3);
        }
        if (contentParser == null) {
            GitPatchParser.$$$reportNull$$$0(4);
        }
        Couple beforeAfterName = GitPatchParser.parseNamesFromGitHeaderLine(startLine);
        FileStatus parsedStatus = FileStatus.MODIFIED;
        int newFileMode = -1;
        Couple sha1Indexes = null;
        if (beforeAfterName == null) {
            throw new PatchSyntaxException(iterator.previousIndex(), "Can't detect file names from git format header line");
        }
        while (iterator.hasNext()) {
            String next = iterator.next();
            Matcher indexMatcher = ourIndexHeaderLinePattern.matcher(next);
            Matcher fileStatusMatcher = ourFileStatusPattern.matcher(next);
            Matcher fileModeMatcher = ourNewFileModePattern.matcher(next);
            Matcher fileRenameFromMatcher = ourRenameFromPattern.matcher(next);
            try {
                if (fileStatusMatcher.matches()) {
                    parsedStatus = GitPatchParser.parseFileStatus(fileStatusMatcher.group(1));
                    String additionalModeInfo = fileStatusMatcher.group(2);
                    if (StringUtil.isEmptyOrSpaces((String)additionalModeInfo) || parsedStatus != FileStatus.ADDED) continue;
                    newFileMode = Integer.parseInt(additionalModeInfo);
                    continue;
                }
                if (fileModeMatcher.matches()) {
                    newFileMode = Integer.parseInt(fileModeMatcher.group(1));
                    continue;
                }
                if (indexMatcher.matches()) {
                    sha1Indexes = Couple.of((Object)indexMatcher.group(1), (Object)indexMatcher.group(2));
                    continue;
                }
                if (fileRenameFromMatcher.matches() && iterator.hasNext()) {
                    Matcher fileRenameToMatcher = ourRenameToPattern.matcher(iterator.next());
                    if (fileRenameToMatcher.matches()) {
                        beforeAfterName = Couple.of((Object)fileRenameFromMatcher.group(1), (Object)fileRenameToMatcher.group(1));
                        continue;
                    }
                    iterator.previous();
                    continue;
                }
                if (!contentParser.testIsStart(next) && !next.startsWith(ourGitBinaryContentStart)) continue;
                iterator.previous();
                break;
            }
            catch (NumberFormatException e) {
                LOG.debug("Can't parse file mode from " + next);
            }
        }
        return new PatchInfo(beforeAfterName, sha1Indexes, parsedStatus, newFileMode);
    }

    private static void applyPatchInfo(@NotNull FilePatch patch, @NotNull PatchInfo patchInfo) {
        if (patch == null) {
            GitPatchParser.$$$reportNull$$$0(5);
        }
        if (patchInfo == null) {
            GitPatchParser.$$$reportNull$$$0(6);
        }
        if (patch instanceof TextFilePatch) {
            ((TextFilePatch)patch).setFileStatus(patchInfo.myFileStatus);
        }
        if (patch.getBeforeName() == null) {
            patch.setBeforeName(patchInfo.myBeforeName);
        }
        if (patch.getAfterName() == null) {
            patch.setAfterName(patchInfo.myAfterName);
        }
        patch.setBeforeVersionId(patchInfo.myBeforeIndex);
        patch.setAfterVersionId(patchInfo.myAfterIndex);
        patch.setNewFileMode(patchInfo.myNewFileMode);
    }

    @Nullable
    private static Couple<String> parseNamesFromGitHeaderLine(@NotNull String start2) {
        Matcher m;
        if (start2 == null) {
            GitPatchParser.$$$reportNull$$$0(7);
        }
        return (m = ourGitHeaderLinePattern.matcher(start2)).matches() ? Couple.of((Object)GitPatchParser.getFileNameFromGitHeaderLine(m.group(1), true), (Object)GitPatchParser.getFileNameFromGitHeaderLine(m.group(2), false)) : null;
    }

    @Nullable
    private static String getFileNameFromGitHeaderLine(@NotNull String line, boolean before) {
        if (line == null) {
            GitPatchParser.$$$reportNull$$$0(8);
        }
        return PatchReader.PatchContentParser.stripPatchNameIfNeeded(VcsFileUtil.unescapeGitPath(line), true, before);
    }

    @NotNull
    private static FileStatus parseFileStatus(@NotNull String status) {
        if (status == null) {
            GitPatchParser.$$$reportNull$$$0(9);
        }
        if (status.startsWith("new")) {
            FileStatus fileStatus = FileStatus.ADDED;
            if (fileStatus == null) {
                GitPatchParser.$$$reportNull$$$0(10);
            }
            return fileStatus;
        }
        if (status.startsWith("deleted")) {
            FileStatus fileStatus = FileStatus.DELETED;
            if (fileStatus == null) {
                GitPatchParser.$$$reportNull$$$0(11);
            }
            return fileStatus;
        }
        FileStatus fileStatus = FileStatus.MODIFIED;
        if (fileStatus == null) {
            GitPatchParser.$$$reportNull$$$0(12);
        }
        return fileStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentParser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/GitPatchParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/GitPatchParser";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFileStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseGitHeader";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyPatchInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseNamesFromGitHeaderLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileNameFromGitHeaderLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseFileStatus";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PatchInfo {
        @Nullable
        private final String myBeforeName;
        @Nullable
        private final String myAfterName;
        @Nullable
        private final String myBeforeIndex;
        @Nullable
        private final String myAfterIndex;
        private final int myNewFileMode;
        @NotNull
        private final FileStatus myFileStatus;

        private PatchInfo(@NotNull Couple<String> beforeAfterName, @Nullable Couple<String> indexes, @NotNull FileStatus status, int newFileMode) {
            if (beforeAfterName == null) {
                PatchInfo.$$$reportNull$$$0(0);
            }
            if (status == null) {
                PatchInfo.$$$reportNull$$$0(1);
            }
            this.myBeforeName = (String)beforeAfterName.first;
            this.myAfterName = (String)beforeAfterName.second;
            this.myBeforeIndex = (String)Pair.getFirst(indexes);
            this.myAfterIndex = (String)Pair.getSecond(indexes);
            this.myNewFileMode = newFileMode;
            this.myFileStatus = status;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "beforeAfterName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "status";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/diff/impl/patch/GitPatchParser$PatchInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

