/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.actions.VcsAnnotateUtil;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AnnotateLocalFileAction {
    private static final Logger LOG = Logger.getInstance(AnnotateLocalFileAction.class);

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null || project.isDisposed()) {
            return false;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file == null || file.isDirectory() || file.getFileType().isBinary()) {
            return false;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        if (vcs == null) {
            return false;
        }
        AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (annotationProvider == null) {
            return false;
        }
        FileStatus fileStatus = ChangeListManager.getInstance((Project)project).getStatus(file);
        return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED && fileStatus != FileStatus.IGNORED;
    }

    private static boolean isSuspended(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(1);
        }
        VirtualFile file = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        return VcsAnnotateUtil.getBackgroundableLock((Project)e.getRequiredData(CommonDataKeys.PROJECT), file).isLocked();
    }

    private static boolean isAnnotated(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(2);
        }
        List<Editor> editors = AnnotateLocalFileAction.getEditors(e.getDataContext());
        return ContainerUtil.exists(editors, editor -> AnnotateToggleAction.hasVcsAnnotations(editor));
    }

    private static void perform(AnActionEvent e, boolean selected) {
        if (!selected) {
            List<Editor> editors = AnnotateLocalFileAction.getEditors(e.getDataContext());
            for (Editor editor : editors) {
                AnnotateToggleAction.closeVcsAnnotations(editor);
            }
        } else {
            Project project = Objects.requireNonNull(e.getProject());
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                Object[] fileEditors;
                VirtualFile selectedFile = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
                for (FileEditor fileEditor : fileEditors = FileEditorManager.getInstance((Project)project).openFile(selectedFile, false)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    editor = ((TextEditor)fileEditor).getEditor();
                }
                if (editor == null) {
                    Messages.showErrorDialog((Project)project, (String)("Can't create text editor for " + selectedFile.getPresentableUrl()), (String)VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                    LOG.warn(String.format("Can't create text editor for file: valid - %s; file type - %s; editors - %s", selectedFile.isValid(), selectedFile.getFileType().getName(), Arrays.toString(fileEditors)));
                    return;
                }
            }
            AnnotateLocalFileAction.doAnnotate(editor, project);
        }
    }

    private static void doAnnotate(final @NotNull Editor editor, final @NotNull Project project) {
        VirtualFile file;
        if (editor == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(4);
        }
        if ((file = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
            return;
        }
        final AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        if (vcs == null) {
            return;
        }
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        assert (annotationProvider != null);
        final Ref fileAnnotationRef = new Ref();
        final Ref exceptionRef = new Ref();
        final BackgroundableActionLock actionLock = VcsAnnotateUtil.getBackgroundableLock(project, file);
        actionLock.lock();
        Task.Backgroundable annotateTask = new Task.Backgroundable(project, VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    fileAnnotationRef.set((Object)annotationProvider.annotate(file));
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    exceptionRef.set((Object)new VcsException(t));
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                if (!exceptionRef.isNull()) {
                    LOG.warn((Throwable)exceptionRef.get());
                    AbstractVcsHelper.getInstance((Project)project).showErrors(Collections.singletonList(exceptionRef.get()), VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                }
                if (!fileAnnotationRef.isNull()) {
                    AnnotateToggleAction.doAnnotate(editor, project, (FileAnnotation)fileAnnotationRef.get(), vcs);
                }
            }

            public void onFinished() {
                actionLock.unlock();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)annotateTask);
    }

    @NotNull
    private static List<Editor> getEditors(@NotNull DataContext context) {
        Editor editor;
        if (context == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(5);
        }
        if ((editor = (Editor)context.getData(CommonDataKeys.EDITOR)) != null) {
            List<Editor> list = Collections.singletonList(editor);
            if (list == null) {
                AnnotateLocalFileAction.$$$reportNull$$$0(6);
            }
            return list;
        }
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || file == null) {
            List<Editor> list = Collections.emptyList();
            if (list == null) {
                AnnotateLocalFileAction.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<Editor> list = VcsAnnotateUtil.getEditors(project, file);
        if (list == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuspended";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Provider
    implements AnnotateToggleAction.Provider {
        @Override
        public boolean isEnabled(AnActionEvent e) {
            return AnnotateLocalFileAction.isEnabled(e);
        }

        @Override
        public boolean isSuspended(@NotNull AnActionEvent e) {
            if (e == null) {
                Provider.$$$reportNull$$$0(0);
            }
            return AnnotateLocalFileAction.isSuspended(e);
        }

        @Override
        public boolean isAnnotated(AnActionEvent e) {
            return AnnotateLocalFileAction.isAnnotated(e);
        }

        @Override
        public void perform(@NotNull AnActionEvent e, boolean selected) {
            if (e == null) {
                Provider.$$$reportNull$$$0(1);
            }
            AnnotateLocalFileAction.perform(e, selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction$Provider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuspended";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

