/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class CopyRevisionNumberFromAnnotateAction
extends DumbAwareAction
implements UpToDateLineNumberListener {
    private final FileAnnotation myAnnotation;
    private int myLineNumber = -1;

    public CopyRevisionNumberFromAnnotateAction(FileAnnotation annotation) {
        super("Copy Revision Number");
        this.myAnnotation = annotation;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyRevisionNumberFromAnnotateAction.$$$reportNull$$$0(0);
        }
        if (this.myLineNumber < 0) {
            return;
        }
        VcsRevisionNumber revisionNumber = this.myAnnotation.getLineRevisionNumber(this.myLineNumber);
        if (revisionNumber != null) {
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(revisionNumber.asString()));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyRevisionNumberFromAnnotateAction.$$$reportNull$$$0(1);
        }
        boolean enabled = this.myLineNumber >= 0 && this.myAnnotation.getLineRevisionNumber(this.myLineNumber) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void consume(Integer integer) {
        this.myLineNumber = integer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/vcs/actions/CopyRevisionNumberFromAnnotateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

