/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeMap;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsDirtyScopeManagerImpl
extends VcsDirtyScopeManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsDirtyScopeManagerImpl.class);
    private final Project myProject;
    private final DirtBuilder myDirtBuilder;
    @Nullable
    private DirtBuilder myDirtInProgress;
    private boolean myReady;
    private final Object LOCK;

    public VcsDirtyScopeManagerImpl(@NotNull Project project) {
        if (project == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myProject = project;
        this.myDirtBuilder = new DirtBuilder();
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect();
        busConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> VcsDirtyScopeManagerImpl.this.markEverythingDirty(), ModalityState.NON_MODAL, VcsDirtyScopeManagerImpl.this.myProject.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl$1", "rootsChanged"));
            }
        });
        busConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (project == VcsDirtyScopeManagerImpl.this.myProject) {
                    VcsDirtyScopeManagerImpl.this.projectOpened();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl$2", "projectOpened"));
            }
        });
    }

    private static ProjectLevelVcsManager getVcsManager(@NotNull Project project) {
        if (project == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(1);
        }
        return ProjectLevelVcsManager.getInstance((Project)project);
    }

    private void projectOpened() {
        ProjectLevelVcsManagerImpl.getInstanceImpl(this.myProject).addInitializationRequest(VcsInitObject.DIRTY_SCOPE_MANAGER, () -> ReadAction.run(() -> {
            boolean ready = !this.myProject.isDisposed() && this.myProject.isOpen();
            Object object = this.LOCK;
            synchronized (object) {
                this.myReady = ready;
            }
            if (ready) {
                VcsDirtyScopeVfsListener.install(this.myProject);
                this.markEverythingDirty();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEverythingDirty() {
        if (!this.myProject.isOpen() || this.myProject.isDisposed() || VcsDirtyScopeManagerImpl.getVcsManager(this.myProject).getAllActiveVcss().length == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("everything dirty: " + VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass());
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myReady) {
                this.myDirtBuilder.setEverythingDirty(true);
            }
        }
        ChangeListManager.getInstance((Project)this.myProject).scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myReady = false;
            this.myDirtBuilder.reset();
            this.myDirtInProgress = null;
        }
    }

    @NotNull
    private Map<AbstractVcs, Set<FilePath>> groupByVcs(@Nullable Collection<? extends FilePath> from) {
        if (from == null) {
            Map<AbstractVcs, Set<FilePath>> map2 = Collections.emptyMap();
            if (map2 == null) {
                VcsDirtyScopeManagerImpl.$$$reportNull$$$0(2);
            }
            return map2;
        }
        VcsDirtyScopeMap map3 = new VcsDirtyScopeMap();
        for (FilePath filePath : from) {
            AbstractVcs vcs = VcsDirtyScopeManagerImpl.getVcsManager(this.myProject).getVcsFor(filePath);
            if (vcs == null) continue;
            map3.add(vcs, filePath);
        }
        Map<AbstractVcs, Set<FilePath>> map4 = map3.asMap();
        if (map4 == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(3);
        }
        return map4;
    }

    @NotNull
    private Map<AbstractVcs, Set<FilePath>> groupFilesByVcs(@Nullable Collection<? extends VirtualFile> from) {
        if (from == null) {
            Map<AbstractVcs, Set<FilePath>> map2 = Collections.emptyMap();
            if (map2 == null) {
                VcsDirtyScopeManagerImpl.$$$reportNull$$$0(4);
            }
            return map2;
        }
        VcsDirtyScopeMap map3 = new VcsDirtyScopeMap();
        for (VirtualFile virtualFile : from) {
            AbstractVcs vcs = VcsDirtyScopeManagerImpl.getVcsManager(this.myProject).getVcsFor(virtualFile);
            if (vcs == null) continue;
            map3.add(vcs, VcsUtil.getFilePath((VirtualFile)virtualFile));
        }
        Map<AbstractVcs, Set<FilePath>> map4 = map3.asMap();
        if (map4 == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(5);
        }
        return map4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileVcsPathsDirty(@NotNull Map<AbstractVcs, Set<FilePath>> filesConverted, @NotNull Map<AbstractVcs, Set<FilePath>> dirsConverted) {
        boolean hasSomethingDirty;
        if (filesConverted == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(6);
        }
        if (dirsConverted == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(7);
        }
        if (filesConverted.isEmpty() && dirsConverted.isEmpty()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("dirty files: %s; dirty dirs: %s; %s", VcsDirtyScopeManagerImpl.toString(filesConverted), VcsDirtyScopeManagerImpl.toString(dirsConverted), VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass()));
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                return;
            }
            VcsDirtyScopeManagerImpl.markDirty(this.myDirtBuilder, filesConverted, false);
            VcsDirtyScopeManagerImpl.markDirty(this.myDirtBuilder, dirsConverted, true);
            hasSomethingDirty = !this.myDirtBuilder.isEmpty();
        }
        if (hasSomethingDirty) {
            ChangeListManager.getInstance((Project)this.myProject).scheduleUpdate();
        }
    }

    private static void markDirty(@NotNull DirtBuilder dirtBuilder, @NotNull Map<AbstractVcs, Set<FilePath>> filesOrDirs, boolean recursively) {
        if (dirtBuilder == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(8);
        }
        if (filesOrDirs == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(9);
        }
        for (AbstractVcs vcs : filesOrDirs.keySet()) {
            for (FilePath path2 : filesOrDirs.get(vcs)) {
                if (recursively) {
                    dirtBuilder.addDirtyDirRecursively(vcs, path2);
                    continue;
                }
                dirtBuilder.addDirtyFile(vcs, path2);
            }
        }
    }

    public void filePathsDirty(@Nullable Collection<? extends FilePath> filesDirty, @Nullable Collection<? extends FilePath> dirsRecursivelyDirty) {
        try {
            this.fileVcsPathsDirty(this.groupByVcs(filesDirty), this.groupByVcs(dirsRecursivelyDirty));
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public void filesDirty(@Nullable Collection<? extends VirtualFile> filesDirty, @Nullable Collection<? extends VirtualFile> dirsRecursivelyDirty) {
        try {
            this.fileVcsPathsDirty(this.groupFilesByVcs(filesDirty), this.groupFilesByVcs(dirsRecursivelyDirty));
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public void fileDirty(@NotNull VirtualFile file) {
        if (file == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(10);
        }
        this.fileDirty(VcsUtil.getFilePath((VirtualFile)file));
    }

    public void fileDirty(@NotNull FilePath file) {
        if (file == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(11);
        }
        this.filePathsDirty(Collections.singleton(file), null);
    }

    public void dirDirtyRecursively(@NotNull VirtualFile dir) {
        if (dir == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(12);
        }
        this.dirDirtyRecursively(VcsUtil.getFilePath((VirtualFile)dir));
    }

    public void dirDirtyRecursively(@NotNull FilePath path2) {
        if (path2 == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(13);
        }
        this.filePathsDirty(null, Collections.singleton(path2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VcsInvalidated retrieveScopes() {
        DirtBuilder dirtBuilder;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                return null;
            }
            this.myDirtInProgress = dirtBuilder = new DirtBuilder(this.myDirtBuilder);
            this.myDirtBuilder.reset();
        }
        return this.calculateInvalidated(dirtBuilder);
    }

    @NotNull
    private VcsInvalidated calculateInvalidated(@NotNull DirtBuilder dirt) {
        if (dirt == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(14);
        }
        VcsDirtyScopeMap filesScope = dirt.getFilesForVcs();
        VcsDirtyScopeMap dirsScope = dirt.getDirsForVcs();
        boolean isEverythingDirty = dirt.isEverythingDirty();
        if (isEverythingDirty) {
            this.putEverythingDirtyRoots(dirsScope);
        }
        Map<AbstractVcs, Set<FilePath>> files = filesScope.asMap();
        Map<AbstractVcs, Set<FilePath>> dirs = dirsScope.asMap();
        Set keys = ContainerUtil.union(files.keySet(), dirs.keySet());
        HashMap<AbstractVcs, VcsDirtyScopeImpl> scopes = new HashMap<AbstractVcs, VcsDirtyScopeImpl>();
        for (AbstractVcs key : keys) {
            VcsDirtyScopeImpl scope = new VcsDirtyScopeImpl(key, isEverythingDirty);
            scopes.put(key, scope);
            scope.addDirtyData(ContainerUtil.notNullize(dirs.get(key)), ContainerUtil.notNullize(files.get(key)));
        }
        return new VcsInvalidated(new ArrayList(scopes.values()), isEverythingDirty);
    }

    private void putEverythingDirtyRoots(@NotNull VcsDirtyScopeMap dirs) {
        VcsRoot[] roots;
        if (dirs == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(15);
        }
        for (VcsRoot root : roots = VcsDirtyScopeManagerImpl.getVcsManager(this.myProject).getAllVcsRoots()) {
            AbstractVcs vcs = root.getVcs();
            VirtualFile path2 = root.getPath();
            if (vcs == null) continue;
            dirs.add(vcs, VcsUtil.getFilePath((VirtualFile)path2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changesProcessed() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtInProgress = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Collection<FilePath> whatFilesDirty(@NotNull Collection<? extends FilePath> files) {
        DirtBuilder dirtBuilderInProgress;
        DirtBuilder dirtBuilder;
        if (files == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(16);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                List<FilePath> list = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var4_2
                if (list == null) {
                    VcsDirtyScopeManagerImpl.$$$reportNull$$$0(17);
                }
                return list;
            }
            dirtBuilder = new DirtBuilder(this.myDirtBuilder);
            dirtBuilderInProgress = this.myDirtInProgress != null ? new DirtBuilder(this.myDirtInProgress) : new DirtBuilder();
        }
        VcsInvalidated invalidated = this.calculateInvalidated(dirtBuilder);
        VcsInvalidated inProgress = this.calculateInvalidated(dirtBuilderInProgress);
        ArrayList<FilePath> result2 = new ArrayList<FilePath>();
        for (FilePath filePath : files) {
            if (!invalidated.isFileDirty(filePath) && !inProgress.isFileDirty(filePath)) continue;
            result2.add(filePath);
        }
        ArrayList<FilePath> arrayList = result2;
        if (arrayList == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private static String toString(@NotNull Map<AbstractVcs, Set<FilePath>> filesByVcs) {
        if (filesByVcs == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(19);
        }
        String string = StringUtil.join(filesByVcs.keySet(), vcs -> vcs.getName() + ": " + StringUtil.join((Collection)((Collection)filesByVcs.get(vcs)), path2 -> path2.getPath(), (String)"\n"), (String)"\n");
        if (string == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    private static Class<?> findFirstInterestingCallerClass() {
        for (int i = 1; i <= 7; ++i) {
            Class clazz = ReflectionUtil.findCallerClass((int)i);
            if (clazz != null && clazz.getName().contains(VcsDirtyScopeManagerImpl.class.getName())) continue;
            return clazz;
        }
        return null;
    }

    @NotNull
    public static TObjectHashingStrategy<FilePath> getDirtyScopeHashingStrategy(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(21);
        }
        TObjectHashingStrategy tObjectHashingStrategy = vcs.needsCaseSensitiveDirtyScope() ? ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY : ContainerUtil.canonicalStrategy();
        if (tObjectHashingStrategy == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(22);
        }
        return tObjectHashingStrategy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesConverted";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsConverted";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesOrDirs";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirt";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesByVcs";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByVcs";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "groupFilesByVcs";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "whatFilesDirty";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScopeHashingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVcsManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fileVcsPathsDirty";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "markDirty";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fileDirty";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "dirDirtyRecursively";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateInvalidated";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putEverythingDirtyRoots";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "whatFilesDirty";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDirtyScopeHashingStrategy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

