/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.VcsIgnoreFilesChecker;
import com.intellij.openapi.vcs.changes.VcsIgnoreFilesCheckerKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0013\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreFilesChecker;", "Lcom/intellij/openapi/components/ProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "generateVcsIgnoreFileInRootIfNeeded", "", "projectOpened", "getProjectConfigDirOrProjectFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "intellij.platform.vcs.impl"})
public final class VcsIgnoreFilesChecker
implements ProjectComponent {
    private final Project project;

    public void projectOpened() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        this.project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(this){
            final /* synthetic */ VcsIgnoreFilesChecker this$0;

            public final void directoryMappingChanged() {
                StartupManager.getInstance((Project)VcsIgnoreFilesChecker.access$getProject$p(this.this$0)).runWhenProjectIsInitialized(new Runnable(this){
                    final /* synthetic */ projectOpened.1 this$0;

                    public final void run() {
                        BackgroundTaskUtil.executeOnPooledThread((Disposable)((Disposable)VcsIgnoreFilesChecker.access$getProject$p(this.this$0.this$0)), (Runnable)new Runnable(this){
                            final /* synthetic */ projectOpened.1 this$0;

                            public final void run() {
                                VcsIgnoreFilesChecker.access$generateVcsIgnoreFileInRootIfNeeded(this.this$0.this$0.this$0, VcsIgnoreFilesChecker.access$getProject$p(this.this$0.this$0.this$0));
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = vcsIgnoreFilesChecker;
            }
        });
    }

    private final void generateVcsIgnoreFileInRootIfNeeded(Project project) {
        if (project.isDisposed()) {
            return;
        }
        VirtualFile virtualFile = this.getProjectConfigDirOrProjectFile(project);
        if (virtualFile == null) {
            return;
        }
        VirtualFile projectFile = virtualFile;
        VirtualFile virtualFile2 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectFile);
        if (virtualFile2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"VcsUtil.getVcsRootFor(pr\u2026t, projectFile) ?: return");
        VirtualFile projectFileVcsRoot = virtualFile2;
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)projectFileVcsRoot);
        if (abstractVcs == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs, (String)"VcsUtil.getVcsFor(projec\u2026ectFileVcsRoot) ?: return");
        AbstractVcs vcs = abstractVcs;
        VcsIgnoreFilesCheckerKt.access$getLOG$p().debug("Propose manage VCS ignore in " + projectFileVcsRoot.getPath() + " for vcs " + vcs.getName());
        VcsImplUtil.proposeUpdateIgnoreFile(project, vcs, projectFileVcsRoot);
    }

    private final VirtualFile getProjectConfigDirOrProjectFile(@NotNull Project $this$getProjectConfigDirOrProjectFile) {
        VirtualFile virtualFile;
        if (ProjectKt.isDirectoryBased((Project)$this$getProjectConfigDirOrProjectFile)) {
            String string = ProjectKt.getStateStore((Project)this.project).getProjectConfigDir();
            if (string != null) {
                String string2 = string;
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                boolean bl = false;
                boolean bl2 = false;
                String p1 = string2;
                boolean bl3 = false;
                virtualFile = localFileSystem.findFileByPath(p1);
            } else {
                virtualFile = null;
            }
        } else {
            virtualFile = this.project.getProjectFile();
        }
        return virtualFile;
    }

    public VcsIgnoreFilesChecker(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ Project access$getProject$p(VcsIgnoreFilesChecker $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$generateVcsIgnoreFileInRootIfNeeded(VcsIgnoreFilesChecker $this, Project project) {
        $this.generateVcsIgnoreFileInRootIfNeeded(project);
    }
}

