/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowser;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesNavigation;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTableModel;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CommittedChangesBrowserDialogPanel
extends JPanel {
    private final Project myProject;
    private final TableView<CommittedChangeList> myChangeListsView;
    private final CommittedChangesBrowser myChangesView;
    private CommittedChangesTableModel myTableModel;
    private final JEditorPane myCommitMessageArea;
    private CommittedChangeList mySelectedChangeList;
    private final JPanel myLeftPanel;
    private final JPanel myLoadingLabelPanel;

    public CommittedChangesBrowserDialogPanel(Project project, CommittedChangesTableModel tableModel) {
        super(new BorderLayout());
        this.myProject = project;
        this.myTableModel = tableModel;
        for (int i = 0; i < this.myTableModel.getColumnCount(); ++i) {
            if (!ChangeListColumn.DATE.getTitle().equals(this.myTableModel.getColumnName(i))) continue;
            this.myTableModel.setSortKey(new RowSorter.SortKey(i, SortOrder.DESCENDING));
            break;
        }
        this.myChangeListsView = new TableView((ListTableModel)this.myTableModel);
        this.myChangeListsView.setSelectionMode(0);
        this.myChangesView = new CommittedChangesBrowser(project);
        this.myChangeListsView.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CommittedChangesBrowserDialogPanel.this.updateBySelectionChange();
            }
        });
        this.myCommitMessageArea = new JEditorPane("text/html", "");
        this.myCommitMessageArea.setBackground(UIUtil.getComboBoxDisabledBackground());
        this.myCommitMessageArea.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myCommitMessageArea.setPreferredSize((Dimension)new JBDimension(150, 100));
        this.myCommitMessageArea.setEditable(false);
        JPanel commitPanel2 = new JPanel(new BorderLayout());
        commitPanel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myCommitMessageArea), "Center");
        TitledSeparator separator = SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myCommitMessageArea);
        commitPanel2.add((Component)separator, "North");
        this.myLeftPanel = new JPanel(new GridBagLayout());
        final JLabel loadingLabel = new JLabel(CommonBundle.getLoadingTreeNodeText());
        this.myLoadingLabelPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(CommittedChangesBrowserDialogPanel.this.myLoadingLabelPanel.getWidth(), loadingLabel.getHeight());
            }
        };
        this.myLoadingLabelPanel.setBackground(UIUtil.getToolTipBackground());
        this.myLoadingLabelPanel.add((Component)loadingLabel, "North");
        JPanel listContainer = new JPanel(new GridBagLayout());
        GridBagConstraints innerGb = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        ++innerGb.gridy;
        innerGb.weighty = 0.0;
        innerGb.fill = 2;
        if (this.myTableModel.isAsynchLoad()) {
            listContainer.add((Component)this.myLoadingLabelPanel, innerGb);
        }
        ++innerGb.gridy;
        innerGb.weighty = 1.0;
        innerGb.fill = 1;
        listContainer.add((Component)ScrollPaneFactory.createScrollPane(this.myChangeListsView), innerGb);
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, (Insets)JBUI.insets((int)1), 0, 0);
        gb.gridwidth = 2;
        this.myLeftPanel.add((Component)listContainer, gb);
        if (tableModel instanceof CommittedChangesNavigation) {
            final CommittedChangesNavigation navigation = (CommittedChangesNavigation)((Object)tableModel);
            final JButton backButton = new JButton("< Older");
            final JButton forwardButton = new JButton("Newer >");
            backButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        navigation.goBack();
                        backButton.setEnabled(navigation.canGoBack());
                    }
                    catch (VcsException e1) {
                        Messages.showErrorDialog((String)e1.getMessage(), (String)"");
                        backButton.setEnabled(false);
                    }
                    forwardButton.setEnabled(navigation.canGoForward());
                    CommittedChangesBrowserDialogPanel.this.selectFirstIfAny();
                }
            });
            forwardButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    navigation.goForward();
                    backButton.setEnabled(navigation.canGoBack());
                    forwardButton.setEnabled(navigation.canGoForward());
                    CommittedChangesBrowserDialogPanel.this.selectFirstIfAny();
                }
            });
            backButton.setEnabled(navigation.canGoBack());
            forwardButton.setEnabled(navigation.canGoForward());
            this.myLeftPanel.add((Component)backButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
            this.myLeftPanel.add((Component)forwardButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
        Splitter leftSplitter = new Splitter(true, 0.8f);
        leftSplitter.setFirstComponent((JComponent)this.myLeftPanel);
        leftSplitter.setSecondComponent((JComponent)commitPanel2);
        Splitter splitter = new Splitter(false, 0.5f);
        splitter.setFirstComponent((JComponent)leftSplitter);
        splitter.setSecondComponent((JComponent)this.myChangesView);
        this.add((Component)splitter, "Center");
        this.selectFirstIfAny();
        this.myChangesView.getDiffAction().registerCustomShortcutSet(this.myChangesView.getDiffAction().getShortcutSet(), this.myChangeListsView);
    }

    public void selectFirstIfAny() {
        if (this.myTableModel.getRowCount() > 0) {
            TableUtil.selectRows(this.myChangeListsView, (int[])new int[]{0});
        }
    }

    public void addToolBar(JComponent toolBar) {
        this.myLeftPanel.add((Component)toolBar, "North");
    }

    public void setModel(CommittedChangesTableModel tableModel) {
        this.myTableModel = tableModel;
        this.myChangeListsView.setModelAndUpdateColumns((ListTableModel)tableModel);
        tableModel.fireTableStructureChanged();
    }

    public void setItems(List<CommittedChangeList> items) {
        this.myTableModel.setItems(items);
    }

    private void updateBySelectionChange() {
        CommittedChangeList list;
        int idx = this.myChangeListsView.getSelectionModel().getLeadSelectionIndex();
        List items = this.myTableModel.getItems();
        CommittedChangeList committedChangeList = list = idx >= 0 && idx < items.size() ? (CommittedChangeList)items.get(idx) : null;
        if (list != this.mySelectedChangeList) {
            this.mySelectedChangeList = list;
            this.myChangesView.setChangesToDisplay(list != null ? new ArrayList(list.getChanges()) : Collections.emptyList());
            this.myCommitMessageArea.setText(list != null ? this.formatText(list) : "");
            this.myCommitMessageArea.select(0, 0);
        }
    }

    private String formatText(CommittedChangeList list) {
        return IssueLinkHtmlRenderer.formatTextIntoHtml(this.myProject, list.getComment());
    }

    public CommittedChangeList getSelectedChangeList() {
        return this.mySelectedChangeList;
    }

    public void setTableContextMenu(ActionGroup group) {
        PopupHandler.installPopupHandler(this.myChangeListsView, (ActionGroup)group, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    public void startLoading() {
    }

    public void stopLoading() {
        this.myLoadingLabelPanel.setVisible(false);
        this.myLoadingLabelPanel.repaint();
    }
}

