/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsBaseRevisionAdviser;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultPatchBaseVersionProvider {
    private static final Logger LOG = Logger.getInstance(DefaultPatchBaseVersionProvider.class);
    private static final Pattern ourTsPattern = Pattern.compile("\\(date ([0-9]+)\\)");
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myVersionId;
    private final Pattern myRevisionPattern;
    private final AbstractVcs myVcs;

    public DefaultPatchBaseVersionProvider(Project project, VirtualFile file, String versionId) {
        String vcsPattern;
        this.myProject = project;
        this.myFile = file;
        this.myVersionId = versionId;
        this.myVcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(this.myFile);
        if (this.myVcs != null && (vcsPattern = this.myVcs.getRevisionPattern()) != null) {
            this.myRevisionPattern = Pattern.compile("\\(revision (" + vcsPattern + ")\\)");
            return;
        }
        this.myRevisionPattern = null;
    }

    public void getBaseVersionContent(FilePath filePath, Processor<? super String> processor) throws VcsException {
        VcsHistorySession historySession;
        Matcher matcher;
        if (this.myVcs == null) {
            return;
        }
        VcsHistoryProvider historyProvider = this.myVcs.getVcsHistoryProvider();
        if (historyProvider == null) {
            return;
        }
        VcsRevisionNumber revision = null;
        if (this.myRevisionPattern != null && (matcher = this.myRevisionPattern.matcher(this.myVersionId)).find()) {
            VcsRevisionNumber finalRevision = revision = this.myVcs.parseRevisionNumber(matcher.group(1), filePath);
            try {
                String message;
                boolean loadedExactRevision;
                if (finalRevision != null && (loadedExactRevision = ((Boolean)DefaultPatchBaseVersionProvider.computeWithModalProgressIfNeeded(this.myProject, message = VcsBundle.message((String)"progress.text2.loading.revision", (Object[])new Object[]{finalRevision.asString()}), () -> {
                    if (historyProvider instanceof VcsBaseRevisionAdviser) {
                        VcsBaseRevisionAdviser revisionAdviser = (VcsBaseRevisionAdviser)historyProvider;
                        return revisionAdviser.getBaseVersionContent(filePath, processor, finalRevision.asString());
                    }
                    DiffProvider diffProvider = this.myVcs.getDiffProvider();
                    if (diffProvider == null || filePath.getVirtualFile() == null) {
                        return false;
                    }
                    ContentRevision fileContent = diffProvider.createFileContent(finalRevision, filePath.getVirtualFile());
                    return fileContent != null && !processor.process((Object)fileContent.getContent());
                })).booleanValue())) {
                    return;
                }
            }
            catch (ProcessCanceledException pce) {
                return;
            }
        }
        Date versionDate = null;
        if (revision == null) {
            try {
                Matcher tsMatcher = ourTsPattern.matcher(this.myVersionId);
                if (tsMatcher.find()) {
                    Long fromTsPattern = this.getFromTsPattern();
                    if (fromTsPattern == null) {
                        return;
                    }
                    versionDate = new Date(fromTsPattern);
                } else {
                    versionDate = new Date(this.myVersionId);
                }
            }
            catch (IllegalArgumentException ex) {
                return;
            }
        }
        try {
            historySession = (VcsHistorySession)DefaultPatchBaseVersionProvider.computeWithModalProgressIfNeeded(this.myProject, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), () -> historyProvider.createSessionFor(filePath));
        }
        catch (ProcessCanceledException e) {
            return;
        }
        if (historySession == null) {
            return;
        }
        List list = historySession.getRevisionList();
        if (list == null) {
            return;
        }
        for (VcsFileRevision fileRevision : list) {
            boolean found;
            if (revision != null) {
                found = fileRevision.getRevisionNumber().compareTo((Object)revision) <= 0;
            } else {
                Date date = fileRevision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)fileRevision).getAuthorDate() : fileRevision.getRevisionDate();
                boolean bl = found = date != null && (date.before(versionDate) || date.equals(versionDate));
            }
            if (!found) continue;
            try {
                CharSequence content2 = LoadTextUtil.getTextByBinaryPresentation((byte[])fileRevision.loadContent(), (VirtualFile)this.myFile, (boolean)false, (boolean)false);
                processor.process((Object)content2.toString());
                break;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public boolean canProvideContent() {
        if (this.myVcs == null) {
            return false;
        }
        if (this.myRevisionPattern != null && this.myRevisionPattern.matcher(this.myVersionId).matches()) {
            return true;
        }
        if (ourTsPattern.matcher(this.myVersionId).matches()) {
            return true;
        }
        try {
            Date.parse(this.myVersionId);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }

    public boolean hasVcs() {
        return this.myVcs != null;
    }

    private Long getFromTsPattern() {
        String trimmed = this.myVersionId.trim();
        String startPattern = "(date";
        int start2 = trimmed.indexOf("(date");
        if (start2 >= 0) {
            String number = trimmed.substring("(date".length() + start2);
            number = number.endsWith(")") ? number.substring(0, number.length() - 1) : number;
            try {
                return Long.parseLong(number.trim());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private static <T> T computeWithModalProgressIfNeeded(@Nullable Project project, @NotNull String title2, @NotNull ThrowableComputable<T, ? extends VcsException> computable) throws VcsException {
        if (title2 == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(0);
        }
        if (computable == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (T)VcsUtil.computeWithModalProgress((Project)project, (String)title2, (boolean)true, indicator -> computable.compute());
        }
        return (T)computable.compute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "computable";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/patch/DefaultPatchBaseVersionProvider";
        objectArray[2] = "computeWithModalProgressIfNeeded";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

