/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitMessageProvider;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J \u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0004J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010H\u0004R\u0014\u0010\u0005\u001a\u00020\u00068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "getChangeListManager", "()Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "getProject", "()Lcom/intellij/openapi/project/Project;", "vcsConfiguration", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "getVcsConfiguration", "()Lcom/intellij/openapi/vcs/VcsConfiguration;", "getCommitMessageFor", "", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "getCommitMessageFromVcs", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "save", "", "changeListName", "commitMessage", "intellij.platform.vcs.impl"})
public abstract class AbstractCommitMessagePolicy {
    @NotNull
    private final Project project;

    @NotNull
    protected final VcsConfiguration getVcsConfiguration() {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsConfiguration, (String)"VcsConfiguration.getInstance(project)");
        return vcsConfiguration;
    }

    @NotNull
    protected final ChangeListManager getChangeListManager() {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        return changeListManager;
    }

    protected final void save(@NotNull String changeListName, @NotNull String commitMessage2) {
        Intrinsics.checkParameterIsNotNull((Object)changeListName, (String)"changeListName");
        Intrinsics.checkParameterIsNotNull((Object)commitMessage2, (String)"commitMessage");
        this.getChangeListManager().editComment(changeListName, commitMessage2);
    }

    @Nullable
    protected final String getCommitMessageFor(@NotNull LocalChangeList changeList) {
        Intrinsics.checkParameterIsNotNull((Object)changeList, (String)"changeList");
        ExtensionPointName<CommitMessageProvider> extensionPointName = CommitMessageProvider.EXTENSION_POINT_NAME;
        Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"CommitMessageProvider.EXTENSION_POINT_NAME");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"CommitMessageProvider.EX\u2026_POINT_NAME.extensionList");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommitMessageProvider provider = (CommitMessageProvider)element$iv;
            boolean bl = false;
            String providerMessage = provider.getCommitMessage(changeList, this.project);
            if (providerMessage == null) continue;
            return providerMessage;
        }
        String changeListDescription = changeList.getComment();
        CharSequence charSequence = changeListDescription;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return changeListDescription;
        }
        return !changeList.hasDefaultName() ? changeList.getName() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final String getCommitMessageFromVcs(@NotNull List<? extends Change> changes) {
        void result2;
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ChangesUtil.processChangesByVcs((Project)this.project, (Collection)changes, (ChangesUtil.PerVcsProcessor)((ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<Change>(this, (Ref.ObjectRef)result2){
            final /* synthetic */ AbstractCommitMessagePolicy this$0;
            final /* synthetic */ Ref.ObjectRef $result;

            public final void process(@NotNull AbstractVcs vcs, @NotNull List<Change> vcsChanges) {
                Intrinsics.checkParameterIsNotNull((Object)vcs, (String)"vcs");
                Intrinsics.checkParameterIsNotNull(vcsChanges, (String)"vcsChanges");
                if ((String)this.$result.element == null) {
                    this.$result.element = AbstractCommitMessagePolicy.access$getCommitMessageFromVcs(this.this$0, vcs, vcsChanges);
                }
            }
            {
                this.this$0 = abstractCommitMessagePolicy;
                this.$result = objectRef;
            }
        }));
        return (String)result2.element;
    }

    /*
     * WARNING - void declaration
     */
    private final String getCommitMessageFromVcs(AbstractVcs vcs, List<? extends Change> changes) {
        String string;
        CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
        if (checkinEnvironment != null) {
            void $this$toTypedArray$iv;
            List list = ChangesUtil.getPaths((Collection)changes);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ChangesUtil.getPaths(changes)");
            Collection collection = list;
            CheckinEnvironment checkinEnvironment2 = checkinEnvironment;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            FilePath[] filePathArray = thisCollection$iv.toArray(new FilePath[0]);
            if (filePathArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            FilePath[] filePathArray2 = filePathArray;
            string = checkinEnvironment2.getDefaultMessageFor(filePathArray2);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public AbstractCommitMessagePolicy(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ String access$getCommitMessageFromVcs(AbstractCommitMessagePolicy $this, AbstractVcs vcs, List changes) {
        return $this.getCommitMessageFromVcs(vcs, changes);
    }
}

