/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.util.containers.IntStack;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.Dfs;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\n\u001a,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\nH\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"getPreviousNode", "", "stack", "Lcom/intellij/util/containers/IntStack;", "isDown", "", "walk", "", "start", "nextNodeFun", "Lkotlin/Function1;", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "visitor", "Lcom/intellij/vcs/log/graph/utils/Dfs$NodeVisitor;", "intellij.platform.vcs.log.graph.impl"})
public final class DfsUtilKt {
    private static final void walk(int start2, IntStack stack, Function1<? super Integer, Integer> nextNodeFun) {
        stack.push(start2);
        while (!stack.empty()) {
            int nextNode = ((Number)nextNodeFun.invoke((Object)stack.peek())).intValue();
            if (nextNode == -10) {
                return;
            }
            if (nextNode != -1) {
                stack.push(nextNode);
                continue;
            }
            stack.pop();
        }
        stack.clear();
    }

    public static final void walk(int start2, @NotNull Function1<? super Integer, Integer> nextNodeFun) {
        Intrinsics.checkParameterIsNotNull(nextNodeFun, (String)"nextNodeFun");
        DfsUtilKt.walk(start2, new IntStack(), nextNodeFun);
    }

    public static final void walk(@NotNull LiteLinearGraph $this$walk, int start2, @NotNull Dfs.NodeVisitor visitor) {
        Intrinsics.checkParameterIsNotNull((Object)$this$walk, (String)"$this$walk");
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        if (start2 < 0 || start2 >= $this$walk.nodesCount()) {
            return;
        }
        BitSetFlags visited = new BitSetFlags($this$walk.nodesCount(), false);
        IntStack stack = new IntStack();
        stack.push(start2);
        block0: while (!stack.empty()) {
            Integer nextNode;
            int currentNode = stack.peek();
            boolean down = DfsUtilKt.isDown(stack);
            if (!visited.get(currentNode)) {
                visited.set(currentNode, true);
                visitor.enterNode(currentNode, DfsUtilKt.getPreviousNode(stack), down);
            }
            Iterator<Integer> iterator = $this$walk.getNodes(currentNode, down ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP).iterator();
            while (iterator.hasNext()) {
                Integer n = nextNode = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"nextNode");
                if (visited.get(n)) continue;
                stack.push(nextNode.intValue());
                continue block0;
            }
            iterator = $this$walk.getNodes(currentNode, down ? LiteLinearGraph.NodeFilter.UP : LiteLinearGraph.NodeFilter.DOWN).iterator();
            while (iterator.hasNext()) {
                Integer n = nextNode = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"nextNode");
                if (visited.get(n)) continue;
                stack.push(nextNode.intValue());
                continue block0;
            }
            visitor.exitNode(currentNode);
            stack.pop();
        }
    }

    private static final int getPreviousNode(IntStack stack) {
        return stack.size() < 2 ? -1 : stack.get(stack.size() - 2);
    }

    private static final boolean isDown(IntStack stack) {
        int currentNode = stack.peek();
        int previousNode = DfsUtilKt.getPreviousNode(stack);
        if (previousNode == -1) {
            return true;
        }
        return previousNode < currentNode;
    }

    public static final /* synthetic */ void access$walk(int start2, IntStack stack, Function1 nextNodeFun) {
        DfsUtilKt.walk(start2, stack, (Function1<? super Integer, Integer>)nextNodeFun);
    }
}

