/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.paint;

import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class PositionUtil {
    private static float distance(int x1, int y1, int x2, int y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }

    public static boolean overUpEdge(int upPosition, int downPosition, int x, int y, int rowHeight, int nodeWidth, float lineThickness) {
        int x1 = nodeWidth * downPosition + nodeWidth / 2;
        int y1 = rowHeight / 2;
        int x2 = nodeWidth * upPosition + nodeWidth / 2;
        int y2 = -rowHeight / 2;
        return PositionUtil.distance(x1, y1, x, y) + PositionUtil.distance(x2, y2, x, y) < PositionUtil.distance(x1, y1, x2, y2) + lineThickness;
    }

    public static boolean overDownEdge(int upPosition, int downPosition, int x, int y, int rowHeight, int nodeWidth, float lineThickness) {
        int x1 = nodeWidth * upPosition + nodeWidth / 2;
        int y1 = rowHeight / 2;
        int x2 = nodeWidth * downPosition + nodeWidth / 2;
        int y2 = rowHeight + rowHeight / 2;
        return PositionUtil.distance(x1, y1, x, y) + PositionUtil.distance(x2, y2, x, y) < PositionUtil.distance(x1, y1, x2, y2) + lineThickness;
    }

    public static boolean overNode(int position, int x, int y, int rowHeight, int nodeWidth, int circleRadius) {
        int x0 = nodeWidth * position + nodeWidth / 2;
        int y0 = rowHeight / 2;
        return PositionUtil.distance(x0, y0, x, y) <= (float)circleRadius;
    }

    public static int getYInsideRow(@NotNull Point point, int rowHeight) {
        if (point == null) {
            PositionUtil.$$$reportNull$$$0(0);
        }
        return point.y - PositionUtil.getRowIndex(point, rowHeight) * rowHeight;
    }

    public static int getRowIndex(@NotNull Point point, int rowHeight) {
        if (point == null) {
            PositionUtil.$$$reportNull$$$0(1);
        }
        return point.y / rowHeight;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "point";
        objectArray2[1] = "com/intellij/vcs/log/paint/PositionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getYInsideRow";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRowIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

