/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OpenAnotherLogTabAction
extends DumbAwareAction {
    protected OpenAnotherLogTabAction() {
        super(() -> OpenAnotherLogTabAction.getText(VcsLogBundle.message((String)"vcs", (Object[])new Object[0])), () -> OpenAnotherLogTabAction.getDescription(VcsLogBundle.message((String)"vcs", (Object[])new Object[0])), AllIcons.Actions.OpenNewTab);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
        VcsLogManager logManager = (VcsLogManager)ObjectUtils.chooseNotNull((Object)e.getData(VcsLogInternalDataKeys.LOG_MANAGER), (Object)projectLog.getLogManager());
        if (logManager == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(projectLog.getLogManager() == logManager);
        String vcsName = VcsLogUtil.getVcsDisplayName(project, logManager.getDataManager().getLogProviders().values());
        e.getPresentation().setText(OpenAnotherLogTabAction.getText(vcsName));
        e.getPresentation().setDescription(OpenAnotherLogTabAction.getDescription(vcsName));
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    private static String getDescription(@Nls @NotNull String vcsName) {
        if (vcsName == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(1);
        }
        String string = VcsLogBundle.message((String)"vcs.log.action.description.open.new.tab.with.log", (Object[])new Object[]{vcsName});
        if (string == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    private static String getText(@Nls @NotNull String vcsName) {
        if (vcsName == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(3);
        }
        String string = VcsLogBundle.message((String)"vcs.log.action.open.new.tab.with.log", (Object[])new Object[]{vcsName});
        if (string == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(5);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogFilterCollection filters = Registry.is((String)"vcs.log.copy.filters.to.new.tab") && logUi != null ? logUi.getFilterUi().getFilters() : VcsLogFilterObject.collection(new VcsLogFilter[0]);
        VcsLogManager.LogWindowKind kind = VcsLogManager.LogWindowKind.TOOL_WINDOW;
        if (e.getData(PlatformDataKeys.TOOL_WINDOW) == null && Registry.is((String)"vcs.log.open.editor.tab")) {
            kind = VcsLogManager.LogWindowKind.EDITOR;
        }
        VcsProjectLog.getInstance(project).openLogTab(filters, kind);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

