/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.exception.FrequentErrorLogger;
import com.intellij.util.text.JBDateFormat;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.table.VcsLogColumn;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableModel
extends AbstractTableModel {
    private static final int UP_PRELOAD_COUNT = 20;
    private static final int DOWN_PRELOAD_COUNT = 40;
    public static final int COMMIT_NOT_FOUND = -1;
    public static final int COMMIT_DOES_NOT_MATCH = -2;
    private static final Logger LOG = Logger.getInstance(GraphTableModel.class);
    private static final FrequentErrorLogger ERROR_LOG = FrequentErrorLogger.newInstance((Logger)LOG);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final Consumer<? super Runnable> myRequestMore;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private VisiblePack myDataPack;
    private boolean myMoreRequested;

    public GraphTableModel(@NotNull VcsLogData logData, @NotNull Consumer<? super Runnable> requestMore, @NotNull VcsLogUiProperties properties) {
        if (logData == null) {
            GraphTableModel.$$$reportNull$$$0(0);
        }
        if (requestMore == null) {
            GraphTableModel.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            GraphTableModel.$$$reportNull$$$0(2);
        }
        this.myDataPack = VisiblePack.EMPTY;
        this.myLogData = logData;
        this.myRequestMore = requestMore;
        this.myProperties = properties;
    }

    @Override
    public int getRowCount() {
        return this.myDataPack.getVisibleGraph().getVisibleCommitCount();
    }

    @Override
    public final int getColumnCount() {
        return VcsLogColumn.count();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return VcsLogColumn.fromOrdinal(column).getContentClass();
    }

    @Override
    public String getColumnName(int column) {
        return VcsLogColumn.fromOrdinal(column).getName();
    }

    public int getRowOfCommit(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            GraphTableModel.$$$reportNull$$$0(3);
        }
        if (root == null) {
            GraphTableModel.$$$reportNull$$$0(4);
        }
        if (!this.myLogData.getStorage().containsCommit(new CommitId(hash, root))) {
            return -1;
        }
        return this.getRowOfCommitWithoutCheck(hash, root);
    }

    public int getRowOfCommitByPartOfHash(@NotNull String partialHash) {
        if (partialHash == null) {
            GraphTableModel.$$$reportNull$$$0(5);
        }
        CommitIdByStringCondition hashByString = new CommitIdByStringCondition(partialHash);
        Ref commitExists = new Ref((Object)false);
        CommitId commitId = this.myLogData.getStorage().findCommitId((Condition<? super CommitId>)((Condition)commitId1 -> {
            if (hashByString.value((CommitId)commitId1)) {
                commitExists.set((Object)true);
                return this.getRowOfCommitWithoutCheck(commitId1.getHash(), commitId1.getRoot()) >= 0;
            }
            return false;
        }));
        return commitId != null ? this.getRowOfCommitWithoutCheck(commitId.getHash(), commitId.getRoot()) : ((Boolean)commitExists.get() != false ? -2 : -1);
    }

    private int getRowOfCommitWithoutCheck(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            GraphTableModel.$$$reportNull$$$0(6);
        }
        if (root == null) {
            GraphTableModel.$$$reportNull$$$0(7);
        }
        int commitIndex = this.myLogData.getCommitIndex(hash, root);
        Integer rowIndex = this.myDataPack.getVisibleGraph().getVisibleRowIndex((Object)commitIndex);
        return rowIndex == null ? -2 : rowIndex;
    }

    @Override
    @NotNull
    public final Object getValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, VcsLogColumn.fromOrdinal(columnIndex));
    }

    @NotNull
    public final Object getValueAt(int rowIndex, @NotNull VcsLogColumn column) {
        if (column == null) {
            GraphTableModel.$$$reportNull$$$0(8);
        }
        if (rowIndex >= this.getRowCount() - 1 && this.canRequestMore()) {
            this.requestToLoadMore(EmptyRunnable.INSTANCE);
        }
        try {
            return this.getValue(rowIndex, column, (VcsShortCommitDetails)this.getCommitMetadata(rowIndex));
        }
        catch (ProcessCanceledException ignore) {
            return this.getStub(column);
        }
        catch (Throwable t) {
            ERROR_LOG.error("Failed to get information for the log table", t);
            return this.getStub(column);
        }
    }

    @NotNull
    private Object getValue(int rowIndex, @NotNull VcsLogColumn column, @NotNull VcsShortCommitDetails data) {
        if (column == null) {
            GraphTableModel.$$$reportNull$$$0(9);
        }
        if (data == null) {
            GraphTableModel.$$$reportNull$$$0(10);
        }
        switch (column) {
            case ROOT: {
                FilePath filePath = this.myDataPack.getFilePath(rowIndex);
                if (filePath == null) {
                    GraphTableModel.$$$reportNull$$$0(11);
                }
                return filePath;
            }
            case COMMIT: {
                return new GraphCommitCell(data.getSubject(), this.getRefsAtRow(rowIndex), this.myDataPack.getVisibleGraph().getRowInfo(rowIndex).getPrintElements());
            }
            case AUTHOR: {
                String string = CommitPresentationUtil.getAuthorPresentation(data);
                if (string == null) {
                    GraphTableModel.$$$reportNull$$$0(12);
                }
                return string;
            }
            case DATE: {
                long timeStamp = this.myProperties.exists(CommonUiProperties.PREFER_COMMIT_DATE) && Boolean.TRUE.equals(this.myProperties.get(CommonUiProperties.PREFER_COMMIT_DATE)) ? data.getCommitTime() : data.getAuthorTime();
                String string = timeStamp < 0L ? "" : JBDateFormat.getFormatter().formatPrettyDateTime(timeStamp);
                if (string == null) {
                    GraphTableModel.$$$reportNull$$$0(13);
                }
                return string;
            }
            case HASH: {
                String string = ((Hash)data.getId()).toShortString();
                if (string == null) {
                    GraphTableModel.$$$reportNull$$$0(14);
                }
                return string;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)column));
    }

    @NotNull
    private Object getStub(@NotNull VcsLogColumn column) {
        if (column == null) {
            GraphTableModel.$$$reportNull$$$0(15);
        }
        switch (column) {
            case ROOT: {
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)((VirtualFile)ContainerUtil.getFirstItem(this.myLogData.getRoots())));
                if (filePath == null) {
                    GraphTableModel.$$$reportNull$$$0(16);
                }
                return filePath;
            }
            case COMMIT: {
                return new GraphCommitCell("", Collections.emptyList(), Collections.emptyList());
            }
        }
        return "";
    }

    public void requestToLoadMore(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            GraphTableModel.$$$reportNull$$$0(17);
        }
        this.myMoreRequested = true;
        this.myRequestMore.consume((Object)onLoaded);
    }

    public boolean canRequestMore() {
        return !this.myMoreRequested && this.myDataPack.canRequestMore();
    }

    public void setVisiblePack(@NotNull VisiblePack visiblePack) {
        if (visiblePack == null) {
            GraphTableModel.$$$reportNull$$$0(18);
        }
        this.myDataPack = visiblePack;
        this.myMoreRequested = false;
        this.fireTableDataChanged();
    }

    @NotNull
    public VisiblePack getVisiblePack() {
        VisiblePack visiblePack = this.myDataPack;
        if (visiblePack == null) {
            GraphTableModel.$$$reportNull$$$0(19);
        }
        return visiblePack;
    }

    @NotNull
    public Integer getIdAtRow(int row2) {
        Integer n = (Integer)this.myDataPack.getVisibleGraph().getRowInfo(row2).getCommit();
        if (n == null) {
            GraphTableModel.$$$reportNull$$$0(20);
        }
        return n;
    }

    @NotNull
    public VirtualFile getRootAtRow(int row2) {
        VirtualFile virtualFile = this.myDataPack.getRoot(row2);
        if (virtualFile == null) {
            GraphTableModel.$$$reportNull$$$0(21);
        }
        return virtualFile;
    }

    @NotNull
    public List<VcsRef> getRefsAtRow(int row2) {
        List<VcsRef> list = ((RefsModel)this.myDataPack.getRefs()).refsToCommit(this.getIdAtRow(row2));
        if (list == null) {
            GraphTableModel.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public List<VcsRef> getBranchesAtRow(int row2) {
        List list = ContainerUtil.filter(this.getRefsAtRow(row2), ref -> ref.getType().isBranch());
        if (list == null) {
            GraphTableModel.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public VcsFullCommitDetails getFullDetails(int row2) {
        Integer id = this.getIdAtRow(row2);
        VcsFullCommitDetails vcsFullCommitDetails = (VcsFullCommitDetails)this.myLogData.getCommitDetailsGetter().getCommitData(id, Collections.singleton(id));
        if (vcsFullCommitDetails == null) {
            GraphTableModel.$$$reportNull$$$0(24);
        }
        return vcsFullCommitDetails;
    }

    @NotNull
    public VcsCommitMetadata getCommitMetadata(int row2) {
        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)this.myLogData.getMiniDetailsGetter().getCommitData(this.getIdAtRow(row2), this.getCommitsToPreload(row2));
        if (vcsCommitMetadata == null) {
            GraphTableModel.$$$reportNull$$$0(25);
        }
        return vcsCommitMetadata;
    }

    @Nullable
    public CommitId getCommitId(int row2) {
        return this.myLogData.getCommitId(this.getIdAtRow(row2));
    }

    @NotNull
    public List<VcsFullCommitDetails> getFullDetails(int[] rows) {
        return GraphTableModel.getDataForRows(rows, this::getFullDetails);
    }

    @NotNull
    public List<VcsCommitMetadata> getCommitMetadata(int[] rows) {
        return GraphTableModel.getDataForRows(rows, this::getCommitMetadata);
    }

    @NotNull
    public List<CommitId> getCommitIds(int[] rows) {
        return GraphTableModel.getDataForRows(rows, this::getCommitId);
    }

    @NotNull
    public List<Integer> convertToCommitIds(@NotNull List<Integer> rows) {
        if (rows == null) {
            GraphTableModel.$$$reportNull$$$0(26);
        }
        List list = ContainerUtil.map(rows, (com.intellij.util.Function)((NotNullFunction)this::getIdAtRow));
        if (list == null) {
            GraphTableModel.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    private Iterable<Integer> getCommitsToPreload(final int row2) {
        final int maxRows = this.getRowCount();
        Iterable<Integer> iterable = () -> new Iterator<Integer>(){
            private int myRowIndex;
            {
                this.myRowIndex = Math.max(0, row2 - 20);
            }

            @Override
            public boolean hasNext() {
                return this.myRowIndex < row2 + 40 && this.myRowIndex < maxRows;
            }

            @Override
            public Integer next() {
                int nextRow = this.myRowIndex++;
                return GraphTableModel.this.getIdAtRow(nextRow);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing elements is not supported.");
            }
        };
        if (iterable == null) {
            GraphTableModel.$$$reportNull$$$0(28);
        }
        return iterable;
    }

    @NotNull
    private static <T> List<T> getDataForRows(final int[] rows, final @NotNull Function<? super Integer, ? extends T> dataGetter) {
        if (dataGetter == null) {
            GraphTableModel.$$$reportNull$$$0(29);
        }
        return new AbstractList<T>(){

            @Override
            @NotNull
            public T get(int index) {
                Object r = dataGetter.apply(rows[index]);
                if (r == null) {
                    2.$$$reportNull$$$0(0);
                }
                return r;
            }

            @Override
            public int size() {
                return rows.length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel$2", "get"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestMore";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialHash";
                break;
            }
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/GraphTableModel";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onLoaded";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGetter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/GraphTableModel";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStub";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisiblePack";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdAtRow";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootAtRow";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefsAtRow";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesAtRow";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullDetails";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMetadata";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToCommitIds";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsToPreload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRowOfCommit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRowOfCommitByPartOfHash";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRowOfCommitWithoutCheck";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getValueAt";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStub";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "requestToLoadMore";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setVisiblePack";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "convertToCommitIds";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDataForRows";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

