/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;

public class FilesProgress {
    private final double myTotal;
    private final String myPrefix;
    private final ProgressIndicator myProgressIndicator;
    private int myCnt;
    private boolean myInText2;

    public FilesProgress(double total, String prefix) {
        this.myTotal = total;
        this.myPrefix = prefix;
        this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
        this.myCnt = 0;
        this.myInText2 = false;
    }

    public void updateIndicator(VirtualFile vf) {
        if (this.myProgressIndicator == null) {
            return;
        }
        this.myProgressIndicator.checkCanceled();
        if (this.myInText2) {
            this.myProgressIndicator.setText2(this.myPrefix + FilesProgress.getFileDescriptionForProgress(vf));
        } else {
            this.myProgressIndicator.setText(this.myPrefix + FilesProgress.getFileDescriptionForProgress(vf));
        }
        this.myProgressIndicator.setFraction((double)this.myCnt / this.myTotal);
        ++this.myCnt;
    }

    private static String getFileDescriptionForProgress(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return file.getName() + " (" + (parent == null ? file.getPath() : parent.getPath()) + ")";
    }

    public void setInText2(boolean inText2) {
        this.myInText2 = inText2;
    }
}

