/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.analysis.AnalyzedToken;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.language.Language;
import org.languagetool.tools.StringTools;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006B9\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010&J)\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040(2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+J!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010&J\u000e\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020+H\u0016J\u000e\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rJ\b\u00103\u001a\u00020\rH\u0016J\u000e\u00103\u001a\u00020\r2\u0006\u00102\u001a\u00020\rJ\u0018\u00103\u001a\u00020\r2\u0006\u00102\u001a\u00020\r2\u0006\u00104\u001a\u00020$H\u0002J\u0006\u00105\u001a\u00020\rR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u001d\u0010\u0016R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0016R\u000e\u0010 \u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/languagetool/analysis/AnalyzedSentence;", "", "tokens", "", "Lorg/languagetool/analysis/AnalyzedTokenReadings;", "preDisambigTokens", "([Lorg/languagetool/analysis/AnalyzedTokenReadings;[Lorg/languagetool/analysis/AnalyzedTokenReadings;)V", "mapping", "", "nonBlankTokens", "nonBlankPreDisambigTokens", "([Lorg/languagetool/analysis/AnalyzedTokenReadings;[I[Lorg/languagetool/analysis/AnalyzedTokenReadings;[Lorg/languagetool/analysis/AnalyzedTokenReadings;)V", "annotations", "", "getAnnotations", "()Ljava/lang/String;", "lemmaSet", "", "getLemmaSet", "()Ljava/util/Set;", "[Lorg/languagetool/analysis/AnalyzedTokenReadings;", "getPreDisambigTokens", "()[Lorg/languagetool/analysis/AnalyzedTokenReadings;", "preDisambigTokensWithoutWhitespace", "getPreDisambigTokensWithoutWhitespace", "text", "getText", "tokenSet", "getTokenSet", "getTokens", "tokensWithoutWhitespace", "getTokensWithoutWhitespace", "whPositions", "copy", "sentence", "equals", "", "other", "([Lorg/languagetool/analysis/AnalyzedTokenReadings;)Ljava/util/Set;", "getNonBlankReadings", "Ljava/util/ArrayList;", "([Lorg/languagetool/analysis/AnalyzedTokenReadings;[I)Ljava/util/ArrayList;", "getOriginalPosition", "", "nonWhPosition", "hasParagraphEndMark", "lang", "Lorg/languagetool/language/Language;", "hashCode", "toShortString", "readingDelimiter", "toString", "includeChunks", "toTextString", "languagetool-core"})
public final class AnalyzedSentence {
    @NotNull
    private final AnalyzedTokenReadings[] tokens;
    @NotNull
    private final AnalyzedTokenReadings[] preDisambigTokens;
    private final AnalyzedTokenReadings[] nonBlankTokens;
    private final AnalyzedTokenReadings[] nonBlankPreDisambigTokens;
    private final int[] whPositions;
    @NotNull
    private final Set<String> tokenSet;
    @NotNull
    private final Set<String> lemmaSet;

    @NotNull
    public final AnalyzedTokenReadings[] getTokens() {
        return this.tokens;
    }

    @NotNull
    public final AnalyzedTokenReadings[] getPreDisambigTokens() {
        return this.preDisambigTokens;
    }

    @NotNull
    public final Set<String> getTokenSet() {
        return this.tokenSet;
    }

    @NotNull
    public final Set<String> getLemmaSet() {
        return this.lemmaSet;
    }

    @NotNull
    public final AnalyzedTokenReadings[] getTokensWithoutWhitespace() {
        return (AnalyzedTokenReadings[])this.nonBlankTokens.clone();
    }

    @NotNull
    public final AnalyzedTokenReadings[] getPreDisambigTokensWithoutWhitespace() {
        return (AnalyzedTokenReadings[])this.nonBlankPreDisambigTokens.clone();
    }

    @NotNull
    public final String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        for (AnalyzedTokenReadings element : this.tokens) {
            $this$apply.append(element.getToken());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply {\n\u2026   }\n        }.toString()");
        return string;
    }

    @NotNull
    public final String getAnnotations() {
        StringBuilder stringBuilder = new StringBuilder(40);
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        $this$apply.append("Disambiguator log: \n");
        for (AnalyzedTokenReadings element : this.tokens) {
            if (element.isWhitespace() || !(Intrinsics.areEqual((Object)"", (Object)element.getHistoricalAnnotations()) ^ true)) continue;
            $this$apply.append(element.getHistoricalAnnotations());
            $this$apply.append('\n');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(40).apply \u2026   }\n        }.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<AnalyzedTokenReadings> getNonBlankReadings(AnalyzedTokenReadings[] tokens, int[] mapping) {
        ArrayList<AnalyzedTokenReadings> arrayList = new ArrayList<AnalyzedTokenReadings>(tokens.length);
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<AnalyzedTokenReadings> $this$apply = arrayList;
        boolean bl3 = false;
        int nonWhCounter = 0;
        AnalyzedTokenReadings[] analyzedTokenReadingsArray = tokens;
        int n = analyzedTokenReadingsArray.length;
        int n2 = 0;
        while (n2 < n) {
            void whCounter;
            AnalyzedTokenReadings token = analyzedTokenReadingsArray[n2];
            if (!token.isWhitespace() || token.isSentenceStart() || token.isSentenceEnd() || token.isParagraphEnd()) {
                $this$apply.add(token);
                mapping[nonWhCounter] = whCounter;
                ++nonWhCounter;
            }
            ++whCounter;
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getTokenSet(AnalyzedTokenReadings[] tokens) {
        void $this$mapTo$iv$iv;
        AnalyzedTokenReadings[] $this$map$iv = tokens;
        boolean $i$f$map = false;
        AnalyzedTokenReadings[] analyzedTokenReadingsArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getToken();
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getLemmaSet(AnalyzedTokenReadings[] tokens) {
        void $this$mapTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        AnalyzedTokenReadings[] $this$flatMap$iv = tokens;
        boolean $i$f$flatMap = false;
        AnalyzedTokenReadings[] analyzedTokenReadingsArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv;
        int n = ((void)iterator2).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void token = element$iv$iv = iterator2[i];
            boolean bl = false;
            Iterable list$iv$iv = token.getReadings();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            AnalyzedToken analyzedToken = (AnalyzedToken)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getLemmaOrToken();
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnalyzedSentence copy(@NotNull AnalyzedSentence sentence) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        AnalyzedTokenReadings[] $this$map$iv = sentence.tokens;
        boolean $i$f$map = false;
        AnalyzedTokenReadings[] analyzedTokenReadingsArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_7 = $this$mapTo$iv$iv;
        int n = ((void)var8_7).length;
        for (int i = 0; i < n; ++i) {
            void analyzedTokens;
            void item$iv$iv;
            void var12_11 = item$iv$iv = var8_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AnalyzedTokenReadings analyzedTokenReadings = new AnalyzedTokenReadings(analyzedTokens.getReadings(), analyzedTokens.getStartPos());
            boolean bl2 = false;
            boolean bl3 = false;
            AnalyzedTokenReadings $this$apply = analyzedTokenReadings;
            boolean bl4 = false;
            $this$apply.setHistoricalAnnotations(analyzedTokens.getHistoricalAnnotations());
            $this$apply.setChunkTags(analyzedTokens.getChunkTags());
            if (analyzedTokens.isImmunized()) {
                $this$apply.immunize();
            }
            if (analyzedTokens.isIgnoredBySpeller()) {
                $this$apply.ignoreSpelling();
            }
            $this$apply.setWhitespaceBefore(analyzedTokens.isWhitespaceBefore());
            AnalyzedTokenReadings analyzedTokenReadings2 = analyzedTokenReadings;
            collection.add(analyzedTokenReadings2);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AnalyzedTokenReadings[] analyzedTokenReadingsArray2 = thisCollection$iv.toArray(new AnalyzedTokenReadings[0]);
        if (analyzedTokenReadingsArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        AnalyzedTokenReadings[] copyTokens = analyzedTokenReadingsArray2;
        return new AnalyzedSentence(copyTokens, sentence.whPositions, sentence.getTokensWithoutWhitespace(), sentence.getPreDisambigTokensWithoutWhitespace());
    }

    public final int getOriginalPosition(int nonWhPosition) {
        return this.whPositions[nonWhPosition];
    }

    @NotNull
    public final String toShortString(@NotNull String readingDelimiter) {
        Intrinsics.checkParameterIsNotNull((Object)readingDelimiter, (String)"readingDelimiter");
        return this.toString(readingDelimiter, false);
    }

    @NotNull
    public final String toTextString() {
        return this.getText();
    }

    @NotNull
    public final String toString(@NotNull String readingDelimiter) {
        Intrinsics.checkParameterIsNotNull((Object)readingDelimiter, (String)"readingDelimiter");
        return this.toString(readingDelimiter, true);
    }

    private final String toString(String readingDelimiter, boolean includeChunks) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        for (AnalyzedTokenReadings element : this.tokens) {
            if (!element.isWhitespace()) {
                $this$apply.append(element.getToken());
                $this$apply.append('[');
            }
            Iterator<AnalyzedToken> iterator2 = element.iterator();
            while (iterator2.hasNext()) {
                AnalyzedToken token = iterator2.next();
                String posTag = token.getPosTag();
                if (element.isSentenceStart()) {
                    $this$apply.append("<S>");
                    continue;
                }
                if (Intrinsics.areEqual((Object)"SENT_END", (Object)posTag)) {
                    $this$apply.append("</S>");
                    continue;
                }
                if (Intrinsics.areEqual((Object)"PARA_END", (Object)posTag)) {
                    $this$apply.append("<P/>");
                    continue;
                }
                if (posTag == null && !includeChunks) {
                    $this$apply.append(token.getToken());
                    continue;
                }
                if (element.isWhitespace()) continue;
                $this$apply.append(token);
                if (!iterator2.hasNext()) continue;
                $this$apply.append(readingDelimiter);
            }
            if (!element.isWhitespace()) {
                if (includeChunks) {
                    Collection collection = element.getChunkTags();
                    boolean bl4 = false;
                    if (!collection.isEmpty()) {
                        $this$apply.append(',');
                        $this$apply.append(StringUtils.join((Iterable)element.getChunkTags(), (String)"|"));
                    }
                }
                if (element.isImmunized()) {
                    $this$apply.append("{!}");
                }
                $this$apply.append(']');
                continue;
            }
            $this$apply.append(' ');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply {\n\u2026       }\n    }.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.toString(",");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) return false;
        if (Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        AnalyzedSentence cfr_ignored_0 = (AnalyzedSentence)other;
        Object[] objectArray = this.nonBlankTokens;
        Object[] objectArray2 = ((AnalyzedSentence)other).nonBlankTokens;
        boolean bl = false;
        if (!Arrays.equals(objectArray, objectArray2)) return false;
        Object[] objectArray3 = this.tokens;
        Object[] objectArray4 = ((AnalyzedSentence)other).tokens;
        bl = false;
        if (!Arrays.equals(objectArray3, objectArray4)) return false;
        int[] nArray = this.whPositions;
        int[] nArray2 = ((AnalyzedSentence)other).whPositions;
        bl = false;
        if (!Arrays.equals(nArray, nArray2)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.nonBlankTokens, this.tokens, this.whPositions);
    }

    public final boolean hasParagraphEndMark(@NotNull Language lang) {
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        return StringTools.INSTANCE.isParagraphEnd(this.getText(), lang.getSentenceTokenizer().singleLineBreaksMarksPara());
    }

    @JvmOverloads
    public AnalyzedSentence(@NotNull AnalyzedTokenReadings[] tokens, @NotNull AnalyzedTokenReadings[] preDisambigTokens) {
        Collection $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull((Object)preDisambigTokens, (String)"preDisambigTokens");
        this.tokens = tokens;
        this.preDisambigTokens = preDisambigTokens;
        this.whPositions = new int[tokens.length + 1];
        Collection collection = this.getNonBlankReadings(tokens, this.whPositions);
        AnalyzedSentence analyzedSentence = this;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AnalyzedTokenReadings[] analyzedTokenReadingsArray = thisCollection$iv.toArray(new AnalyzedTokenReadings[0]);
        if (analyzedTokenReadingsArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        AnalyzedTokenReadings[] analyzedTokenReadingsArray2 = analyzedTokenReadingsArray;
        analyzedSentence.nonBlankTokens = analyzedTokenReadingsArray2;
        $this$toTypedArray$iv = this.getNonBlankReadings(preDisambigTokens, this.whPositions);
        analyzedSentence = this;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        AnalyzedTokenReadings[] analyzedTokenReadingsArray3 = thisCollection$iv.toArray(new AnalyzedTokenReadings[0]);
        if (analyzedTokenReadingsArray3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        analyzedTokenReadingsArray2 = analyzedTokenReadingsArray3;
        analyzedSentence.nonBlankPreDisambigTokens = analyzedTokenReadingsArray2;
        this.tokenSet = this.getTokenSet(tokens);
        this.lemmaSet = this.getLemmaSet(tokens);
    }

    public /* synthetic */ AnalyzedSentence(AnalyzedTokenReadings[] analyzedTokenReadingsArray, AnalyzedTokenReadings[] analyzedTokenReadingsArray2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            analyzedTokenReadingsArray2 = analyzedTokenReadingsArray;
        }
        this(analyzedTokenReadingsArray, analyzedTokenReadingsArray2);
    }

    @JvmOverloads
    public AnalyzedSentence(@NotNull AnalyzedTokenReadings[] tokens) {
        this(tokens, null, 2, null);
    }

    private AnalyzedSentence(AnalyzedTokenReadings[] tokens, int[] mapping, AnalyzedTokenReadings[] nonBlankTokens, AnalyzedTokenReadings[] nonBlankPreDisambigTokens) {
        this.tokens = tokens;
        this.preDisambigTokens = tokens;
        this.whPositions = mapping;
        this.nonBlankTokens = nonBlankTokens;
        this.nonBlankPreDisambigTokens = nonBlankPreDisambigTokens;
        this.tokenSet = this.getTokenSet(tokens);
        this.lemmaSet = this.getLemmaSet(tokens);
    }
}

