/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.analysis.AnalyzedSentence;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.language.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SymbolLocator;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.rules.UnsyncStack;

public class GenericUnpairedBracketsRule
extends TextLevelRule {
    private static final Pattern NUMERALS_EN = Pattern.compile("(?i)\\d{1,2}?[a-z']*|M*(D?C{0,3}|C[DM])(L?X{0,3}|X[LC])(V?I{0,3}|I[VX])$");
    private static final Pattern PUNCTUATION = Pattern.compile("[\\p{Punct}\u2026\u2013\u2014]");
    private static final Pattern PUNCTUATION_NO_DOT = Pattern.compile("[ldmnstLDMNST]'|[\u2013\u2014\\p{Punct}&&[^\\.]]");
    private final String[] startSymbols;
    private final String[] endSymbols;
    private final Map<String, Boolean> uniqueMap;
    private final String ruleId;
    private final Pattern numerals;

    public GenericUnpairedBracketsRule(String ruleId, ResourceBundle messages, Language language, List<String> startSymbols, List<String> endSymbols) {
        this(ruleId, messages, language, startSymbols, endSymbols, NUMERALS_EN);
    }

    public GenericUnpairedBracketsRule(String ruleId, ResourceBundle messages, Language language, List<String> startSymbols, List<String> endSymbols, Pattern numerals) {
        super(messages, language);
        this.ruleId = ruleId != null ? ruleId : "UNPAIRED_BRACKETS";
        super.setCategory(Categories.PUNCTUATION.getCategory(messages, language));
        if (startSymbols.size() != endSymbols.size()) {
            throw new IllegalArgumentException("Different number of start and end symbols: " + startSymbols + " vs. " + endSymbols);
        }
        this.startSymbols = startSymbols.toArray(new String[0]);
        this.endSymbols = endSymbols.toArray(new String[0]);
        this.numerals = Objects.requireNonNull(numerals);
        this.uniqueMap = this.uniqueMapInit();
        this.setDefaultOff();
        this.setLocQualityIssueType(ITSIssueType.Typographical);
    }

    public GenericUnpairedBracketsRule(ResourceBundle messages, Language language, List<String> startSymbols, List<String> endSymbols) {
        this(null, messages, language, startSymbols, endSymbols);
    }

    public GenericUnpairedBracketsRule(ResourceBundle messages, Language language, List<String> startSymbols, List<String> endSymbols, Pattern numerals) {
        this(null, messages, language, startSymbols, endSymbols, numerals);
    }

    public GenericUnpairedBracketsRule(ResourceBundle messages, Language language) {
        this(null, messages, language, Arrays.asList("[", "(", "{", "\"", "'"), Arrays.asList("]", ")", "}", "\"", "'"));
    }

    @Override
    public String getId() {
        return this.ruleId;
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_unpaired_brackets");
    }

    protected boolean isNoException(String token, AnalyzedTokenReadings[] tokens, int i, int j, boolean precSpace, boolean follSpace, UnsyncStack<SymbolLocator> symbolStack) {
        String tokenStr = tokens[i].getToken();
        if (i >= 2) {
            String prevPrevToken = tokens[i - 2].getToken();
            String prevToken = tokens[i - 1].getToken();
            if (prevPrevToken.equals(":") && prevToken.equals("-") && (tokenStr.equals(")") || tokenStr.equals("("))) {
                return false;
            }
            if (prevPrevToken.equals(";") && prevToken.equals("-") && (tokenStr.equals(")") || tokenStr.equals("("))) {
                return false;
            }
        }
        if (i >= 1) {
            String prevToken = tokens[i - 1].getToken();
            if (prevToken.equals(":") && !tokens[i].isWhitespaceBefore() && (tokenStr.equals(")") || tokenStr.equals("("))) {
                return false;
            }
            if (prevToken.equals(";") && !tokens[i].isWhitespaceBefore() && (tokenStr.equals(")") || tokenStr.equals("("))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final RuleMatch[] match(List<AnalyzedSentence> sentences) {
        UnsyncStack<SymbolLocator> symbolStack = new UnsyncStack<SymbolLocator>();
        UnsyncStack<SymbolLocator> ruleMatchStack = new UnsyncStack<SymbolLocator>();
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int startPosBase = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            for (int i = 1; i < tokens.length; ++i) {
                for (int j = 0; j < this.startSymbols.length && !this.fillSymbolStack(startPosBase, tokens, i, j, symbolStack, sentence); ++j) {
                }
            }
            for (AnalyzedTokenReadings readings : sentence.getTokens()) {
                startPosBase += readings.getToken().length();
            }
        }
        for (SymbolLocator sLoc : symbolStack) {
            RuleMatch rMatch = this.createMatch(ruleMatches, ruleMatchStack, sLoc.getStartPos(), sLoc.getSymbol(), sLoc.getSentence(), sentences);
            if (rMatch == null) continue;
            ruleMatches.add(rMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private Map<String, Boolean> uniqueMapInit() {
        HashMap<String, Boolean> uniqueMap = new HashMap<String, Boolean>();
        for (String endSymbol : this.endSymbols) {
            int found = 0;
            for (String endSymbol1 : this.endSymbols) {
                if (!endSymbol1.equals(endSymbol)) continue;
                ++found;
            }
            uniqueMap.put(endSymbol, found == 1);
        }
        return Collections.unmodifiableMap(uniqueMap);
    }

    private boolean fillSymbolStack(int startPosBase, AnalyzedTokenReadings[] tokens, int i, int j, UnsyncStack<SymbolLocator> symbolStack, AnalyzedSentence sentence) {
        String token = tokens[i].getToken();
        int startPos = startPosBase + tokens[i].getStartPos();
        if (token.equals(this.startSymbols[j]) || token.equals(this.endSymbols[j])) {
            boolean followedByWhitespace;
            boolean precededByWhitespace = this.getPrecededByWhitespace(tokens, i, j);
            boolean noException = this.isNoException(token, tokens, i, j, precededByWhitespace, followedByWhitespace = this.getFollowedByWhitespace(tokens, i, j), symbolStack);
            if (noException && precededByWhitespace && token.equals(this.startSymbols[j])) {
                symbolStack.push(new SymbolLocator(this.startSymbols[j], i, startPos, sentence));
                return true;
            }
            if (noException && (followedByWhitespace || tokens[i].isSentenceEnd()) && token.equals(this.endSymbols[j]) && (i <= 1 || !this.endSymbols[j].equals(")") || !this.numerals.matcher(tokens[i - 1].getToken()).matches() || !symbolStack.empty() && "(".equals(symbolStack.peek().getSymbol()))) {
                if (symbolStack.empty()) {
                    symbolStack.push(new SymbolLocator(this.endSymbols[j], i, startPos, sentence));
                    return true;
                }
                if (symbolStack.peek().getSymbol().equals(this.startSymbols[j])) {
                    symbolStack.pop();
                    return true;
                }
                if (this.isEndSymbolUnique(this.endSymbols[j])) {
                    symbolStack.push(new SymbolLocator(this.endSymbols[j], i, startPos, sentence));
                    return true;
                }
                if (j == this.endSymbols.length - 1) {
                    symbolStack.push(new SymbolLocator(this.endSymbols[j], i, startPos, sentence));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean getPrecededByWhitespace(AnalyzedTokenReadings[] tokens, int i, int j) {
        boolean precededByWhitespace = true;
        if (this.startSymbols[j].equals(this.endSymbols[j])) {
            precededByWhitespace = tokens[i - 1].isSentenceStart() || tokens[i].isWhitespaceBefore() || PUNCTUATION_NO_DOT.matcher(tokens[i - 1].getToken()).matches() || Arrays.asList(this.startSymbols).contains(tokens[i - 1].getToken());
        }
        return precededByWhitespace;
    }

    private boolean getFollowedByWhitespace(AnalyzedTokenReadings[] tokens, int i, int j) {
        boolean followedByWhitespace = true;
        if (i < tokens.length - 1 && this.startSymbols[j].equals(this.endSymbols[j])) {
            followedByWhitespace = tokens[i + 1].isWhitespaceBefore() || PUNCTUATION.matcher(tokens[i + 1].getToken()).matches() || Arrays.asList(this.endSymbols).contains(tokens[i + 1].getToken());
        }
        return followedByWhitespace;
    }

    private boolean isEndSymbolUnique(String str) {
        return this.uniqueMap.get(str);
    }

    @Nullable
    private RuleMatch createMatch(List<RuleMatch> ruleMatches, UnsyncStack<SymbolLocator> ruleMatchStack, int startPos, String symbol, AnalyzedSentence sentence, List<AnalyzedSentence> sentences) {
        String context;
        SymbolLocator rLoc;
        int index;
        if (!ruleMatchStack.empty() && (index = this.findSymbolNum(symbol, this.endSymbols)) >= 0 && (rLoc = ruleMatchStack.peek()).getSymbol().equals(this.startSymbols[index]) && ruleMatches.size() > rLoc.getIndex()) {
            ruleMatches.remove(rLoc.getIndex());
            ruleMatchStack.pop();
            return null;
        }
        ruleMatchStack.push(new SymbolLocator(symbol, ruleMatches.size(), startPos, sentence));
        String otherSymbol = this.findCorrespondingSymbol(symbol);
        String message = MessageFormat.format(this.messages.getString("unpaired_brackets"), otherSymbol);
        StringBuilder fullText = new StringBuilder();
        for (AnalyzedSentence aSentence : sentences) {
            fullText.append(aSentence.getText());
        }
        if (startPos + symbol.length() < fullText.length() && (startPos >= 2 && startPos + symbol.length() < fullText.length() ? (context = fullText.substring(startPos - 2, startPos + symbol.length())).matches("\n[a-zA-Z]\\)") : startPos >= 1 && (context = fullText.substring(startPos - 1, startPos + symbol.length())).matches("[a-zA-Z]\\)"))) {
            return null;
        }
        return new RuleMatch(this, sentence, startPos, startPos + symbol.length(), message);
    }

    private int findSymbolNum(String ch, String[] symbols) {
        for (int i = 0; i < symbols.length; ++i) {
            if (!ch.equals(symbols[i])) continue;
            return i;
        }
        return -1;
    }

    private String findCorrespondingSymbol(String symbol) {
        int idx1 = this.findSymbolNum(symbol, this.startSymbols);
        if (idx1 >= 0) {
            return this.endSymbols[idx1];
        }
        int idx2 = this.findSymbolNum(symbol, this.endSymbols);
        return this.startSymbols[idx2];
    }

    @Override
    public int minToCheckParagraph() {
        return -1;
    }
}

