/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.analysis.AnalyzedSentence;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.language.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.StringTools;

public class UppercaseSentenceStartRule
extends TextLevelRule {
    private static final Pattern NUMERALS_EN = Pattern.compile("[a-z]|(m{0,4}(c[md]|d?c{0,3})(x[cl]|l?x{0,3})(i[xv]|v?i{0,3}))$");
    private static final Pattern WHITESPACE_OR_QUOTE = Pattern.compile("[ \"'\u201e\u00ab\u00bb\u2018\u2019\u201c\u201d\\n]");
    private static final Pattern SENTENCE_END1 = Pattern.compile("[.?!\u2026]|");
    private static final Set<String> EXCEPTIONS = new HashSet<String>(Arrays.asList("iPhone", "iPhones", "iOS", "iLife", "iWork", "iMac", "iMacs", "eBay", "fMRI", "iOS", "iPad", "iPads", "iPod", "iPods", "iCloud", "iRobot", "iRobots", "iTunes", "mRNA"));

    public UppercaseSentenceStartRule(ResourceBundle messages, Language language, IncorrectExample incorrectExample, CorrectExample correctExample) {
        super(messages, language);
        super.setCategory(Categories.CASING.getCategory(messages, language));
        this.setLocQualityIssueType(ITSIssueType.Typographical);
        if (incorrectExample != null && correctExample != null) {
            this.addExamplePair(incorrectExample, correctExample);
        }
        this.setDefaultOff();
    }

    public UppercaseSentenceStartRule(ResourceBundle messages, Language language) {
        this(messages, language, null, null);
    }

    @Override
    public final String getId() {
        return "UPPERCASE_SENTENCE_START";
    }

    @Override
    public final String getDescription() {
        return this.messages.getString("desc_uppercase_sentence");
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        String lastParagraphString = "";
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (sentences.size() == 1 && sentences.get(0).getTokens().length == 2) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int pos = 0;
        boolean isPrevSentenceNumberedList = false;
        for (AnalyzedSentence sentence : sentences) {
            String firstDutchToken;
            AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
            if (tokens.length < 2) {
                return this.toRuleMatchArray(ruleMatches);
            }
            int matchTokenPos = 1;
            AnalyzedTokenReadings firstTokenObj = tokens[matchTokenPos];
            String firstToken = firstTokenObj.getToken();
            String secondToken = null;
            String thirdToken = null;
            if (tokens.length >= 3 && this.isQuoteStart(firstToken)) {
                matchTokenPos = 2;
                secondToken = tokens[matchTokenPos].getToken();
            }
            if ((firstDutchToken = this.dutchSpecialCase(firstToken, secondToken, tokens)) != null) {
                thirdToken = firstDutchToken;
                matchTokenPos = 3;
            }
            String checkToken = firstToken;
            if (thirdToken != null) {
                checkToken = thirdToken;
            } else if (secondToken != null) {
                checkToken = secondToken;
            }
            String lastToken = tokens[tokens.length - 1].getToken();
            if (WHITESPACE_OR_QUOTE.matcher(lastToken).matches()) {
                lastToken = tokens[tokens.length - 2].getToken();
            }
            boolean preventError = false;
            if (lastParagraphString.equals(",") || lastParagraphString.equals(";")) {
                preventError = true;
            }
            if (!SENTENCE_END1.matcher(lastParagraphString).matches() && !this.isSentenceEnd(lastToken)) {
                preventError = true;
            }
            lastParagraphString = lastToken;
            if (matchTokenPos + 1 < tokens.length && NUMERALS_EN.matcher(tokens[matchTokenPos].getToken()).matches() && (tokens[matchTokenPos + 1].getToken().equals(".") || tokens[matchTokenPos + 1].getToken().equals(")"))) {
                preventError = true;
            }
            if (isPrevSentenceNumberedList || this.isUrl(checkToken) || this.isEMail(checkToken) || firstTokenObj.isImmunized()) {
                preventError = true;
            }
            if (checkToken.length() > 0) {
                char firstChar = checkToken.charAt(0);
                if (!preventError && Character.isLowerCase(firstChar) && !EXCEPTIONS.contains(checkToken)) {
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, pos + tokens[matchTokenPos].getStartPos(), pos + tokens[matchTokenPos].getEndPos(), this.messages.getString("incorrect_case"));
                    ruleMatch.setSuggestedReplacement(StringTools.uppercaseFirstChar(checkToken));
                    ruleMatches.add(ruleMatch);
                }
            }
            pos += sentence.getText().length();
            isPrevSentenceNumberedList = sentence.getText().matches("\\d+\\. .*") || sentence.getText().matches(".*\n\\d+\\. ");
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Nullable
    private String dutchSpecialCase(String firstToken, String secondToken, AnalyzedTokenReadings[] tokens) {
        if (!this.language.getShortCode().equals("nl")) {
            return null;
        }
        if (tokens.length > 3 && firstToken.equals("'") && this.isDutchSpecialCase(secondToken)) {
            return tokens[3].getToken();
        }
        return null;
    }

    protected boolean isUrl(String token) {
        return WordTokenizer.isUrl(token);
    }

    protected boolean isEMail(String token) {
        return WordTokenizer.isEMail(token);
    }

    private boolean isDutchSpecialCase(String word) {
        return StringUtils.equalsAny((CharSequence)word, (CharSequence[])new CharSequence[]{"k", "m", "n", "r", "s", "t"});
    }

    private boolean isSentenceEnd(String word) {
        return StringUtils.equalsAny((CharSequence)word, (CharSequence[])new CharSequence[]{".", "?", "!", "\u2026"});
    }

    private boolean isQuoteStart(String word) {
        return StringUtils.equalsAny((CharSequence)word, (CharSequence[])new CharSequence[]{"\"", "'", "\u201e", "\u00bb", "\u00ab", "\u201c", "\u2018"});
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

