/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryMetadata;
import morfologik.stemming.WordData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.analysis.AnalyzedToken;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.tagging.CombiningTagger;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.MorfologikTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tools.StringTools;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ \u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010\u0019\u001a\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017H\u0004J$\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010\u0019\u001a\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0017H\u0004J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'H\u0016J\u001a\u0010(\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u0003H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0003H\u0014J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010,\u001a\u00020\u0007H\u0016J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020$0\u00172\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\r8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00158\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/languagetool/tagging/BaseTagger;", "Lorg/languagetool/tagging/Tagger;", "dictionaryPath", "", "conversionLocale", "Ljava/util/Locale;", "tagLowercaseWithUppercase", "", "internTags", "(Ljava/lang/String;Ljava/util/Locale;ZZ)V", "getConversionLocale", "()Ljava/util/Locale;", "dictionary", "Lmorfologik/stemming/Dictionary;", "getDictionaryPath", "()Ljava/lang/String;", "manualAdditionsFileName", "getManualAdditionsFileName", "manualRemovalsFileName", "getManualRemovalsFileName", "wordTagger", "Lorg/languagetool/tagging/WordTagger;", "additionalTags", "", "Lorg/languagetool/analysis/AnalyzedToken;", "word", "asAnalyzedToken", "wd", "Lmorfologik/stemming/WordData;", "asAnalyzedTokenList", "Ljava/util/ArrayList;", "wdList", "asAnalyzedTokenListForTaggedWords", "taggedWords", "Lorg/languagetool/tagging/TaggedWord;", "createNullToken", "Lorg/languagetool/analysis/AnalyzedTokenReadings;", "token", "startPos", "", "createToken", "posTag", "getAnalyzedTokens", "initWordTagger", "overwriteWithManualTagger", "tag", "sentenceTokens", "languagetool-core"})
public abstract class BaseTagger
implements Tagger {
    @JvmField
    @NotNull
    protected final Dictionary dictionary;
    @JvmField
    @NotNull
    protected final WordTagger wordTagger;
    @Nullable
    private final String manualRemovalsFileName;
    @NotNull
    private final String dictionaryPath;
    @NotNull
    private final Locale conversionLocale;
    private final boolean tagLowercaseWithUppercase;

    @Nullable
    public abstract String getManualAdditionsFileName();

    @Nullable
    public String getManualRemovalsFileName() {
        return this.manualRemovalsFileName;
    }

    public boolean overwriteWithManualTagger() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WordTagger initWordTagger(boolean internTags) {
        WordTagger wordTagger;
        InputStream stream2;
        Throwable throwable;
        boolean bl;
        Closeable closeable;
        String it;
        boolean bl2;
        boolean bl3;
        String string;
        MorfologikTagger tagger2 = new MorfologikTagger(this.dictionary, internTags);
        ManualTagger removalTagger = null;
        String string2 = this.getManualRemovalsFileName();
        if (string2 != null) {
            string = string2;
            bl3 = false;
            bl2 = false;
            it = string;
            boolean bl4 = false;
            closeable = JLanguageTool.Companion.getDataBroker().getFromResourceDirAsStream(it);
            bl = false;
            throwable = null;
            try {
                stream2 = (InputStream)closeable;
                boolean bl5 = false;
                removalTagger = new ManualTagger(stream2, internTags);
                stream2 = Unit.INSTANCE;
            }
            catch (Throwable stream2) {
                throwable = stream2;
                throw stream2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        String string3 = this.getManualAdditionsFileName();
        if (string3 != null) {
            CombiningTagger combiningTagger;
            string = string3;
            bl3 = false;
            bl2 = false;
            it = string;
            boolean bl6 = false;
            closeable = JLanguageTool.Companion.getDataBroker().getFromResourceDirAsStream(it);
            bl = false;
            throwable = null;
            try {
                stream2 = (InputStream)closeable;
                boolean bl7 = false;
                combiningTagger = new CombiningTagger(tagger2, new ManualTagger(stream2, internTags), removalTagger, this.overwriteWithManualTagger());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            wordTagger = combiningTagger;
        } else {
            wordTagger = tagger2;
        }
        return wordTagger;
    }

    @Override
    @NotNull
    public List<AnalyzedTokenReadings> tag(@NotNull List<String> sentenceTokens) throws IOException {
        Intrinsics.checkParameterIsNotNull(sentenceTokens, (String)"sentenceTokens");
        ArrayList<AnalyzedTokenReadings> arrayList = new ArrayList<AnalyzedTokenReadings>();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<AnalyzedTokenReadings> $this$apply = arrayList;
        boolean bl3 = false;
        int pos = 0;
        for (String word : sentenceTokens) {
            $this$apply.add(new AnalyzedTokenReadings(this.getAnalyzedTokens(word), pos));
            pos += word.length();
        }
        return arrayList;
    }

    @NotNull
    protected List<AnalyzedToken> getAnalyzedTokens(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        ArrayList<AnalyzedToken> arrayList = new ArrayList<AnalyzedToken>();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<AnalyzedToken> $this$apply = arrayList;
        boolean bl3 = false;
        String string = word;
        Locale locale = this.conversionLocale;
        boolean bl4 = false;
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        String lowerWord = string2;
        boolean isLowercase = Intrinsics.areEqual((Object)word, (Object)lowerWord);
        ArrayList<AnalyzedToken> taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.wordTagger.tag(word));
        ArrayList<AnalyzedToken> lowerTaggerTokens = !isLowercase ? this.asAnalyzedTokenListForTaggedWords(word, this.wordTagger.tag(lowerWord)) : taggerTokens;
        $this$apply.addAll((Collection)taggerTokens);
        if (!isLowercase && !StringTools.isMixedCase(word)) {
            $this$apply.addAll((Collection)lowerTaggerTokens);
        }
        if (this.tagLowercaseWithUppercase && lowerTaggerTokens.isEmpty() && taggerTokens.isEmpty() && isLowercase) {
            String string3 = StringTools.uppercaseFirstChar(word);
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.addAll((Collection)this.asAnalyzedTokenListForTaggedWords(word, this.wordTagger.tag(string3)));
        }
        if ($this$apply.isEmpty()) {
            List<AnalyzedToken> list = this.additionalTags(word, this.wordTagger);
            $this$apply.addAll(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
        }
        if ($this$apply.isEmpty()) {
            $this$apply.add(new AnalyzedToken(word, null, null));
        }
        return arrayList;
    }

    @NotNull
    protected final ArrayList<AnalyzedToken> asAnalyzedTokenList(@NotNull String word, @NotNull List<WordData> wdList) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        Intrinsics.checkParameterIsNotNull(wdList, (String)"wdList");
        ArrayList<AnalyzedToken> arrayList = new ArrayList<AnalyzedToken>();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<AnalyzedToken> $this$apply = arrayList;
        boolean bl3 = false;
        for (WordData wd : wdList) {
            $this$apply.add(this.asAnalyzedToken(word, wd));
        }
        return arrayList;
    }

    @NotNull
    protected final ArrayList<AnalyzedToken> asAnalyzedTokenListForTaggedWords(@NotNull String word, @NotNull List<TaggedWord> taggedWords) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        Intrinsics.checkParameterIsNotNull(taggedWords, (String)"taggedWords");
        ArrayList<AnalyzedToken> arrayList = new ArrayList<AnalyzedToken>();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<AnalyzedToken> $this$apply = arrayList;
        boolean bl3 = false;
        for (TaggedWord taggedWord : taggedWords) {
            $this$apply.add(new AnalyzedToken(word, taggedWord.getPosTag(), taggedWord.getLemma()));
        }
        return arrayList;
    }

    @NotNull
    protected final AnalyzedToken asAnalyzedToken(@NotNull String word, @NotNull WordData wd) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        Intrinsics.checkParameterIsNotNull((Object)wd, (String)"wd");
        String tag = StringTools.asString(wd.getTag());
        DictionaryMetadata dictionaryMetadata = this.dictionary.metadata;
        Intrinsics.checkExpressionValueIsNotNull((Object)dictionaryMetadata, (String)"dictionary.metadata");
        if (dictionaryMetadata.isFrequencyIncluded()) {
            String string = tag;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (string.length() > 1) {
                String string2 = tag;
                int n = 0;
                int n2 = tag.length() - 1;
                boolean bl = false;
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                tag = string3;
            }
        }
        return new AnalyzedToken(word, tag, StringTools.asString(wd.getStem()));
    }

    @Override
    @NotNull
    public AnalyzedTokenReadings createNullToken(@NotNull String token, int startPos) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        return new AnalyzedTokenReadings(new AnalyzedToken(token, null, null), startPos);
    }

    @Override
    @NotNull
    public AnalyzedToken createToken(@NotNull String token, @Nullable String posTag) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        return new AnalyzedToken(token, posTag, null);
    }

    @Nullable
    protected List<AnalyzedToken> additionalTags(@NotNull String word, @NotNull WordTagger wordTagger) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        Intrinsics.checkParameterIsNotNull((Object)wordTagger, (String)"wordTagger");
        return null;
    }

    @NotNull
    public final String getDictionaryPath() {
        return this.dictionaryPath;
    }

    @NotNull
    protected final Locale getConversionLocale() {
        return this.conversionLocale;
    }

    @JvmOverloads
    public BaseTagger(@NotNull String dictionaryPath, @NotNull Locale conversionLocale, boolean tagLowercaseWithUppercase, boolean internTags) {
        Intrinsics.checkParameterIsNotNull((Object)dictionaryPath, (String)"dictionaryPath");
        Intrinsics.checkParameterIsNotNull((Object)conversionLocale, (String)"conversionLocale");
        this.dictionaryPath = dictionaryPath;
        this.conversionLocale = conversionLocale;
        this.tagLowercaseWithUppercase = tagLowercaseWithUppercase;
        Dictionary dictionary2 = Dictionary.read((URL)JLanguageTool.Companion.getDataBroker().getFromResourceDirAsUrl(this.dictionaryPath));
        Intrinsics.checkExpressionValueIsNotNull((Object)dictionary2, (String)"Dictionary.read(dataBrok\u2026DirAsUrl(dictionaryPath))");
        this.dictionary = dictionary2;
        this.wordTagger = this.initWordTagger(internTags);
    }

    public /* synthetic */ BaseTagger(String string, Locale locale, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.getDefault()");
            locale = locale2;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(string, locale, bl, bl2);
    }

    @JvmOverloads
    public BaseTagger(@NotNull String dictionaryPath, @NotNull Locale conversionLocale, boolean tagLowercaseWithUppercase) {
        this(dictionaryPath, conversionLocale, tagLowercaseWithUppercase, false, 8, null);
    }

    @JvmOverloads
    public BaseTagger(@NotNull String dictionaryPath, @NotNull Locale conversionLocale) {
        this(dictionaryPath, conversionLocale, false, false, 12, null);
    }

    @JvmOverloads
    public BaseTagger(@NotNull String dictionaryPath) {
        this(dictionaryPath, null, false, false, 14, null);
    }
}

