/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.language.Language;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0007J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0012\u0010\u001a\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0016\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0017J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0014\u0010%\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0007J\u001a\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,H\u0007J\u0012\u0010-\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0007J\u0016\u0010.\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u0010/\u001a\u00020\nJ\u0010\u00100\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0007J\u0010\u00101\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0007J\u0014\u00102\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0007J\u001e\u00102\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/languagetool/tools/StringTools;", "", "()V", "SPECIAL_CHARACTERS", "Lkotlin/text/Regex;", "XML_COMMENT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "XML_PATTERN", "addSpace", "", "word", "language", "Lorg/languagetool/language/Language;", "asString", "s", "", "assureSet", "", "varName", "changeFirstCharCase", "str", "toUpperCase", "", "isAllUppercase", "isCapitalizedWord", "isEmpty", "isMixedCase", "isNonBreakingWhitespace", "isNotAllLowercase", "isParagraphEnd", "sentence", "singleLineBreaksMarksPara", "isPositiveNumber", "ch", "", "isWhitespace", "lowercaseFirstChar", "readStream", "stream", "Ljava/io/InputStream;", "encoding", "readerToString", "reader", "Ljava/io/Reader;", "startsWithUppercase", "streamToString", "charsetName", "trimSpecialCharacters", "trimWhitespace", "uppercaseFirstChar", "languagetool-core"})
public final class StringTools {
    private static final Pattern XML_COMMENT_PATTERN;
    private static final Pattern XML_PATTERN;
    private static final Regex SPECIAL_CHARACTERS;
    public static final StringTools INSTANCE;

    @JvmStatic
    public static final void assureSet(@NotNull String s, @NotNull String varName) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)varName, (String)"varName");
        Objects.requireNonNull(varName);
        String $this$trim$iv = s;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        boolean bl = !StringTools.isEmpty(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = varName + " cannot be empty or whitespace only";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final String readStream(@NotNull InputStream stream, @Nullable String encoding) throws IOException {
        InputStreamReader inputStreamReader;
        boolean bl;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl4 = false;
        String string = encoding;
        if (string != null) {
            object = string;
            bl = false;
            boolean bl5 = false;
            String it = object;
            boolean bl6 = false;
            inputStreamReader = new InputStreamReader(stream, it);
        } else {
            inputStreamReader = new InputStreamReader(stream);
        }
        object = inputStreamReader;
        bl = false;
        Throwable throwable = null;
        try {
            InputStreamReader isr = (InputStreamReader)object;
            boolean bl7 = false;
            Closeable closeable = new BufferedReader(isr);
            boolean bl8 = false;
            Throwable throwable2 = null;
            try {
                BufferedReader br = (BufferedReader)closeable;
                boolean bl9 = false;
                br.lines().forEach(new Consumer<String>($this$apply){
                    final /* synthetic */ StringBuilder $this_apply$inlined;
                    {
                        this.$this_apply$inlined = stringBuilder;
                    }

                    public final void accept(String it) {
                        this.$this_apply$inlined.append(it);
                        this.$this_apply$inlined.append('\n');
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply {\n\u2026       }\n    }.toString()");
        return string2;
    }

    @JvmStatic
    public static final boolean isAllUppercase(@NotNull String str) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            CharSequence $this$none$iv = str;
            boolean $i$f$none = false;
            CharSequence charSequence = $this$none$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl2 = false;
                if (!(Character.isLetter(it) && Character.isLowerCase(it))) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isMixedCase(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        return !StringTools.isAllUppercase(str) && !StringTools.isCapitalizedWord(str) && StringTools.isNotAllLowercase(str);
    }

    @JvmStatic
    public static final boolean isNotAllLowercase(@NotNull String str) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            CharSequence $this$any$iv = str;
            boolean $i$f$any = false;
            CharSequence charSequence = $this$any$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl2 = false;
                if (!(Character.isLetter(it) && !Character.isLowerCase(it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isCapitalizedWord(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        CharSequence charSequence = str;
        boolean bl = false;
        if (charSequence.length() > 0 && Character.isUpperCase(str.charAt(0))) {
            boolean bl2;
            block2: {
                CharSequence $this$all$iv = StringsKt.drop((String)str, (int)1);
                boolean $i$f$all = false;
                CharSequence charSequence2 = $this$all$iv;
                for (int i = 0; i < charSequence2.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence2.charAt(i);
                    boolean bl3 = false;
                    if (!Character.isLetter(it) || Character.isLowerCase(it)) continue;
                    bl2 = false;
                    break block2;
                }
                bl2 = true;
            }
            return bl2;
        }
        return false;
    }

    @JvmStatic
    public static final boolean startsWithUppercase(@Nullable String str) {
        CharSequence charSequence = str;
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence == null || charSequence.length() == 0) && Character.isUpperCase(str.charAt(0));
    }

    @JvmStatic
    @Nullable
    public static final String uppercaseFirstChar(@Nullable String str) {
        return INSTANCE.changeFirstCharCase(str, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @Nullable
    public static final String uppercaseFirstChar(@Nullable String str, @Nullable Language language) {
        String string;
        if (language != null && str != null && Intrinsics.areEqual((Object)"nl", (Object)language.getShortCode()) && str.length() > 1) {
            char c = str.charAt(0);
            int n = 0;
            if (Character.toLowerCase(c) == 'i') {
                c = str.charAt(1);
                n = 0;
                if (Character.toLowerCase(c) == 'j') {
                    String string2 = str;
                    n = 2;
                    StringBuilder stringBuilder = new StringBuilder().append("IJ");
                    boolean bl = false;
                    String string3 = string2.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    String string4 = string3;
                    string = stringBuilder.append(string4).toString();
                    return string;
                }
            }
        }
        string = INSTANCE.changeFirstCharCase(str, true);
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String lowercaseFirstChar(@Nullable String str) {
        return INSTANCE.changeFirstCharCase(str, false);
    }

    private final String changeFirstCharCase(String str, boolean toUpperCase) {
        int pos;
        CharSequence charSequence = str;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return str;
        }
        if (str.length() == 1) {
            String string;
            if (toUpperCase) {
                charSequence = str;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
                Locale locale2 = locale;
                bl2 = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)charSequence2).toUpperCase(locale2);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase(locale)");
            } else {
                charSequence = str;
                bl = false;
                CharSequence charSequence3 = charSequence;
                if (charSequence3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)charSequence3).toLowerCase();
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            }
            return string;
        }
        int len = str.length() - 1;
        for (pos = 0; !Character.isLetterOrDigit(str.charAt(pos)) && len > pos; ++pos) {
        }
        String string = str;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, pos);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string6 = string5;
        string = str;
        n = pos + 1;
        stringBuilder = stringBuilder.append(string6).append(toUpperCase ? Character.toUpperCase(str.charAt(pos)) : Character.toLowerCase(str.charAt(pos)));
        bl3 = false;
        String string7 = string;
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
        string6 = string8;
        return stringBuilder.append(string6).toString();
    }

    @JvmStatic
    @NotNull
    public static final String readerToString(@NotNull Reader reader) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        int readBytes = 0;
        char[] chars = new char[4000];
        while (readBytes >= 0 && (readBytes = reader.read(chars, 0, 4000)) > 0) {
            $this$apply.append(chars, 0, readBytes);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply {\n\u2026       }\n    }.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String streamToString(@NotNull InputStream stream, @NotNull String charsetName) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        Intrinsics.checkParameterIsNotNull((Object)charsetName, (String)"charsetName");
        Closeable closeable = new InputStreamReader(stream, charsetName);
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStreamReader isr = (InputStreamReader)closeable;
            boolean bl2 = false;
            String string = StringTools.readerToString(isr);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @JvmStatic
    @NotNull
    public static final String trimWhitespace(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        String $this$trim$iv = s;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl4 = false;
            boolean bl5 = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String str = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        for (int i = 0; i < str.length(); ++i) {
            while (str.charAt(i) <= ' ' && i < str.length() && (str.charAt(i + 1) <= ' ' || i > 1 && str.charAt(i - 1) <= ' ')) {
                ++i;
            }
            char c = str.charAt(i);
            if (c == '\n' || c == '\t' || c == '\r') continue;
            $this$apply.append(c);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply {\n\u2026       }\n    }.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String trimSpecialCharacters(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        CharSequence charSequence = s;
        Regex regex = SPECIAL_CHARACTERS;
        String string = "";
        boolean bl = false;
        return regex.replace(charSequence, string);
    }

    @JvmStatic
    @NotNull
    public static final String addSpace(@NotNull String word, @NotNull Language language) {
        char c;
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        String space = " ";
        if (word.length() == 1 && ((c = word.charAt(0)) == '.' || c == ',' || Intrinsics.areEqual((Object)"fr", (Object)language.getShortCode()) ^ true && (c == ';' || c == ':' || c == '?' || c == '!'))) {
            space = "";
        }
        return space;
    }

    @JvmStatic
    public static final boolean isWhitespace(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        if (Intrinsics.areEqual((Object)"\u0002", (Object)str) || Intrinsics.areEqual((Object)"\u0001", (Object)str)) {
            return false;
        }
        String $this$trim$iv = str;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String trimStr = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        CharSequence charSequence = trimStr;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return true;
        }
        if (trimStr.length() == 1) {
            if (Intrinsics.areEqual((Object)"\u200b", (Object)str) || Intrinsics.areEqual((Object)"\u00a0", (Object)str) || Intrinsics.areEqual((Object)"\u202f", (Object)str)) {
                return true;
            }
            return Character.isWhitespace(trimStr.charAt(0));
        }
        return false;
    }

    @JvmStatic
    public static final boolean isNonBreakingWhitespace(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        return Intrinsics.areEqual((Object)"\u00a0", (Object)str);
    }

    @JvmStatic
    public static final boolean isPositiveNumber(char ch) {
        char c = ch;
        return '1' <= c && '9' >= c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isEmpty(@Nullable String str) {
        if (str == null) return true;
        CharSequence charSequence = str;
        boolean bl = false;
        if (charSequence.length() != 0) return false;
        return true;
    }

    @JvmStatic
    @Nullable
    public static final String asString(@Nullable CharSequence s) {
        CharSequence charSequence = s;
        return charSequence != null ? ((Object)charSequence).toString() : null;
    }

    public final boolean isParagraphEnd(@NotNull String sentence, boolean singleLineBreaksMarksPara) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        boolean isParaEnd = false;
        if (singleLineBreaksMarksPara) {
            if (StringsKt.endsWith$default((String)sentence, (String)"\n", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)sentence, (String)"\n\r", (boolean)false, (int)2, null)) {
                isParaEnd = true;
            }
        } else if (StringsKt.endsWith$default((String)sentence, (String)"\n\n", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)sentence, (String)"\n\r\n\r", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)sentence, (String)"\r\n\r\n", (boolean)false, (int)2, null)) {
            isParaEnd = true;
        }
        return isParaEnd;
    }

    private StringTools() {
    }

    static {
        StringTools stringTools;
        INSTANCE = stringTools = new StringTools();
        XML_COMMENT_PATTERN = Pattern.compile("<!--.*?-->", 32);
        XML_PATTERN = Pattern.compile("(?<!<)<[^<>]+>", 32);
        String string = "(?U)[^\\p{Space}\\p{Alnum}\\p{Punct}]";
        boolean bl = false;
        SPECIAL_CHARACTERS = new Regex(string);
    }
}

