/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.BasePainter;
import com.intellij.codeEditor.printing.FileSeparatorProvider;
import com.intellij.codeEditor.printing.LineWrapper;
import com.intellij.codeEditor.printing.PrintSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.containers.IntArrayList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

class TextPainter
extends BasePainter {
    private final DocumentEx myDocument;
    private RangeMarker myRangeToPrint;
    private int myOffset;
    private int myLineNumber;
    private float myLineHeight;
    private float myDescent;
    private double myCharWidth;
    private final Font myPlainFont;
    private final Font myBoldFont;
    private final Font myItalicFont;
    private final Font myBoldItalicFont;
    private final Font myHeaderFont;
    private final EditorHighlighter myHighlighter;
    private final PrintSettings myPrintSettings;
    private final String myFullFileName;
    private final String myShortFileName;
    private int myPageIndex;
    private int myNumberOfPages;
    private int mySegmentEnd;
    private Project myProject;
    private LineMarkerInfo[] myMethodSeparators;
    private int myCurrentMethodSeparator;
    private final CodeStyleSettings myCodeStyleSettings;
    private final FileType myFileType;
    private final Color myMethodSeparatorColor;
    private boolean myPerformActualDrawing;
    private long myDocumentStamp;
    private final String myPrintDate;
    private final String myPrintTime;
    @NonNls
    private static final String DEFAULT_MEASURE_HEIGHT_TEXT = "A";
    @NonNls
    private static final String DEFAULT_MEASURE_WIDTH_TEXT = "w";
    @NonNls
    private static final String HEADER_TOKEN_PAGE = "PAGE";
    @NonNls
    private static final String HEADER_TOKEN_TOTALPAGES = "TOTALPAGES";
    @NonNls
    private static final String HEADER_TOKEN_FILE = "FILE";
    @NonNls
    private static final String HEADER_TOKEN_FILENAME = "FILENAME";
    @NonNls
    private static final String HEADER_TOKEN_DATE = "DATE";
    @NonNls
    private static final String HEADER_TOKEN_TIME = "TIME";
    @NonNls
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    @NonNls
    private static final String TIME_FORMAT = "HH:mm:ss";
    boolean isPrintingPass;

    TextPainter(@NotNull DocumentEx editorDocument, EditorHighlighter highlighter, String fullFileName, String shortFileName, FileType fileType, Project project, @NotNull CodeStyleSettings codeStyleSettings) {
        if (editorDocument == null) {
            TextPainter.$$$reportNull$$$0(0);
        }
        if (codeStyleSettings == null) {
            TextPainter.$$$reportNull$$$0(1);
        }
        this.myOffset = 0;
        this.myLineNumber = 1;
        this.myLineHeight = -1.0f;
        this.myDescent = -1.0f;
        this.myCharWidth = -1.0;
        this.myPageIndex = -1;
        this.myNumberOfPages = -1;
        this.myMethodSeparators = new LineMarkerInfo[0];
        this.myDocumentStamp = -1L;
        this.isPrintingPass = true;
        this.myCodeStyleSettings = codeStyleSettings;
        this.myDocument = editorDocument;
        this.myPrintSettings = PrintSettings.getInstance();
        String fontName = this.myPrintSettings.FONT_NAME;
        int fontSize = Math.round((float)this.myPrintSettings.FONT_SIZE / UISettings.getDefFontScale());
        this.myPlainFont = new Font(fontName, 0, fontSize);
        this.myBoldFont = new Font(fontName, 1, fontSize);
        this.myItalicFont = new Font(fontName, 2, fontSize);
        this.myBoldItalicFont = new Font(fontName, 3, fontSize);
        this.myHighlighter = highlighter;
        this.myHeaderFont = new Font(this.myPrintSettings.FOOTER_HEADER_FONT_NAME, 0, this.myPrintSettings.FOOTER_HEADER_FONT_SIZE);
        this.myFullFileName = fullFileName;
        this.myShortFileName = shortFileName;
        this.myRangeToPrint = editorDocument.createRangeMarker(0, this.myDocument.getTextLength());
        this.myFileType = fileType;
        this.myProject = project;
        Date date = new Date();
        this.myPrintDate = new SimpleDateFormat(DATE_FORMAT).format(date);
        this.myPrintTime = new SimpleDateFormat(TIME_FORMAT).format(date);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        this.myMethodSeparatorColor = colorsManager.isDarkEditor() ? colorsManager.getScheme("Default").getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR) : null;
    }

    public void setSegment(int segmentStart, int segmentEnd) {
        this.setSegment(this.myDocument.createRangeMarker(segmentStart, segmentEnd));
    }

    private void setSegment(RangeMarker marker) {
        if (this.myRangeToPrint != null) {
            ReadAction.run(() -> this.myRangeToPrint.dispose());
        }
        this.myRangeToPrint = marker;
    }

    private float getLineHeight(Graphics g) {
        if (this.myLineHeight >= 0.0f) {
            return this.myLineHeight;
        }
        FontRenderContext fontRenderContext = ((Graphics2D)g).getFontRenderContext();
        LineMetrics lineMetrics = this.myPlainFont.getLineMetrics(DEFAULT_MEASURE_HEIGHT_TEXT, fontRenderContext);
        this.myLineHeight = lineMetrics.getHeight();
        return this.myLineHeight;
    }

    private float getDescent(Graphics g) {
        if (this.myDescent >= 0.0f) {
            return this.myDescent;
        }
        FontRenderContext fontRenderContext = ((Graphics2D)g).getFontRenderContext();
        LineMetrics lineMetrics = this.myPlainFont.getLineMetrics(DEFAULT_MEASURE_HEIGHT_TEXT, fontRenderContext);
        this.myDescent = lineMetrics.getDescent();
        return this.myDescent;
    }

    private Font getFont(int type) {
        if (type == 1) {
            return this.myBoldFont;
        }
        if (type == 2) {
            return this.myItalicFont;
        }
        if (type == 3) {
            return this.myBoldItalicFont;
        }
        return this.myPlainFont;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        this.myPerformActualDrawing = false;
        if (this.myProgress.isCanceled()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.myNumberOfPages < 0) {
            this.myProgress.setText(EditorBundle.message((String)"print.file.calculating.number.of.pages.progress", (Object[])new Object[0]));
            if (!this.calculateNumberOfPages(g2d, pageFormat)) {
                return 1;
            }
        }
        if (pageIndex >= this.myNumberOfPages) {
            return 1;
        }
        boolean bl = this.isPrintingPass = !this.isPrintingPass;
        if (!this.isPrintingPass) {
            while (++this.myPageIndex < pageIndex) {
                if (this.printPageInReadAction(g2d, pageFormat, "print.skip.page.progress")) continue;
                return 1;
            }
            return (Integer)ReadAction.compute(() -> TextPainter.isValidRange(this.myRangeToPrint) ? 0 : 1);
        }
        this.myPerformActualDrawing = true;
        this.printPageInReadAction(g2d, pageFormat, "print.file.page.progress");
        return 0;
    }

    private boolean printPageInReadAction(Graphics2D g2d, PageFormat pageFormat, @PropertyKey(resourceBundle="messages.EditorBundle") String progressMessageKey) {
        return (Boolean)ReadAction.compute(() -> {
            if (!TextPainter.isValidRange(this.myRangeToPrint)) {
                return false;
            }
            this.myProgress.setText(EditorBundle.message((String)progressMessageKey, (Object[])new Object[]{this.myShortFileName, this.myPageIndex + 1, this.myNumberOfPages}));
            this.setSegment(this.printPage(g2d, pageFormat, this.myRangeToPrint));
            return true;
        });
    }

    private boolean calculateNumberOfPages(Graphics2D g2d, PageFormat pageFormat) {
        this.myNumberOfPages = 0;
        Ref firstPage = new Ref((Object)Boolean.TRUE);
        Ref tmpMarker = new Ref();
        while (((Boolean)ReadAction.compute(() -> {
            RangeMarker range2;
            if (((Boolean)firstPage.get()).booleanValue()) {
                if (!TextPainter.isValidRange(this.myRangeToPrint)) {
                    return false;
                }
                tmpMarker.set((Object)this.myDocument.createRangeMarker(this.myRangeToPrint.getStartOffset(), this.myRangeToPrint.getEndOffset()));
                firstPage.set((Object)Boolean.FALSE);
            }
            if (!TextPainter.isValidRange(range2 = (RangeMarker)tmpMarker.get())) {
                return false;
            }
            tmpMarker.set((Object)this.printPage(g2d, pageFormat, range2));
            range2.dispose();
            return true;
        })).booleanValue()) {
            if (this.myProgress.isCanceled()) {
                return false;
            }
            ++this.myNumberOfPages;
        }
        if (!tmpMarker.isNull()) {
            ((RangeMarker)tmpMarker.get()).dispose();
        }
        return true;
    }

    private static boolean isValidRange(RangeMarker range2) {
        return range2 != null && range2.isValid() && range2.getStartOffset() < range2.getEndOffset();
    }

    private RangeMarker printPage(Graphics2D g2d, PageFormat pageFormat, RangeMarker range2) {
        assert (TextPainter.isValidRange(range2));
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        this.myOffset = startOffset;
        this.mySegmentEnd = endOffset;
        this.myLineNumber = this.myDocument.getLineNumber(this.myOffset) + 1;
        Rectangle2D.Double clip = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        this.updateHighlightingInfoIfNeeded();
        this.draw(g2d, clip);
        return this.myOffset > startOffset && this.myOffset < endOffset ? this.myDocument.createRangeMarker(this.myOffset, endOffset) : null;
    }

    private void updateHighlightingInfoIfNeeded() {
        long documentStamp = this.myDocument.getModificationStamp();
        if (documentStamp == this.myDocumentStamp) {
            return;
        }
        this.myDocumentStamp = documentStamp;
        this.myHighlighter.setText(this.myDocument.getImmutableCharSequence());
        this.myCurrentMethodSeparator = 0;
        if (this.myProject != null) {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)this.myDocument);
            List<LineMarkerInfo> separators = psiFile == null ? Collections.emptyList() : FileSeparatorProvider.getFileSeparators(psiFile, this.myDocument);
            this.myMethodSeparators = separators.toArray(new LineMarkerInfo[0]);
        }
    }

    private void draw(Graphics2D g2D, Rectangle2D.Double clip) {
        double headerHeight = this.drawHeader(g2D, clip);
        clip.y += headerHeight;
        clip.height -= headerHeight;
        double footerHeight = this.drawFooter(g2D, clip);
        clip.height -= footerHeight;
        Rectangle2D.Double border = (Rectangle2D.Double)clip.clone();
        clip.x += this.getCharWidth(g2D) / 2.0;
        clip.width -= this.getCharWidth(g2D);
        if (this.myPrintSettings.PRINT_LINE_NUMBERS) {
            double numbersStripWidth = this.calcNumbersStripWidth(g2D, clip) + this.getCharWidth(g2D) / 2.0;
            clip.x += numbersStripWidth;
            clip.width -= numbersStripWidth;
        }
        clip.x += this.getCharWidth(g2D) / 2.0;
        clip.width -= this.getCharWidth(g2D);
        this.drawText(g2D, clip);
        this.drawBorder(g2D, border);
    }

    private void drawBorder(Graphics2D g, Rectangle2D clip) {
        if (this.myPrintSettings.DRAW_BORDER && this.myPerformActualDrawing) {
            Color save = g.getColor();
            g.setColor(Color.black);
            g.draw(clip);
            g.setColor(save);
        }
    }

    private double getCharWidth(Graphics2D g) {
        if (this.myCharWidth < 0.0) {
            FontRenderContext fontRenderContext = g.getFontRenderContext();
            this.myCharWidth = this.myPlainFont.getStringBounds(DEFAULT_MEASURE_WIDTH_TEXT, fontRenderContext).getWidth();
        }
        return this.myCharWidth;
    }

    private void setForegroundColor(Graphics2D g, Color color) {
        if (color == null || !this.myPrintSettings.COLOR_PRINTING || !this.myPrintSettings.SYNTAX_PRINTING) {
            color = Color.black;
        }
        g.setColor(color);
    }

    private void setBackgroundColor(Graphics2D g, Color color) {
        if (color == null || !this.myPrintSettings.COLOR_PRINTING || !this.myPrintSettings.SYNTAX_PRINTING) {
            color = Color.white;
        }
        g.setColor(color);
    }

    private void setFont(Graphics2D g, Font font) {
        if (!this.myPrintSettings.SYNTAX_PRINTING) {
            font = this.myPlainFont;
        }
        g.setFont(font);
    }

    private void drawText(Graphics2D g, Rectangle2D clip) {
        float lineHeight = this.getLineHeight(g);
        HighlightingAttributesIterator hIterator = new HighlightingAttributesIterator(this.myHighlighter.createIterator(this.myOffset));
        if (hIterator.atEnd()) {
            this.myOffset = this.mySegmentEnd;
            return;
        }
        LineIterator lIterator = this.myDocument.createLineIterator();
        lIterator.start(this.myOffset);
        if (lIterator.atEnd()) {
            this.myOffset = this.mySegmentEnd;
            return;
        }
        TextAttributes attributes = hIterator.getTextAttributes();
        Color currentColor = attributes.getForegroundColor();
        Color backColor = attributes.getBackgroundColor();
        Color underscoredColor = attributes.getEffectColor();
        Font currentFont = this.getFont(attributes.getFontType());
        this.setForegroundColor(g, currentColor);
        this.setFont(g, currentFont);
        g.translate(clip.getX(), 0.0);
        Point2D.Double position = new Point2D.Double(0.0, clip.getY());
        double lineY = ((Point2D)position).getY();
        if (this.myPerformActualDrawing) {
            this.getMethodSeparatorColor(lIterator.getLineNumber());
        }
        char[] text2 = this.myDocument.getCharsSequence().toString().toCharArray();
        while (!hIterator.atEnd() && !lIterator.atEnd()) {
            int hEnd = hIterator.getEnd();
            int lEnd = lIterator.getEnd();
            int lStart = lIterator.getStart();
            if (hEnd >= lEnd) {
                Color markerColor;
                if (!this.drawString(g, text2, lEnd - lIterator.getSeparatorLength(), this.myOffset == lStart, position, clip, backColor, underscoredColor)) {
                    this.drawLineNumber(g, lineY);
                    break;
                }
                this.drawLineNumber(g, lineY);
                lIterator.advance();
                ++this.myLineNumber;
                ((Point2D)position).setLocation(0.0, ((Point2D)position).getY() + (double)lineHeight);
                lineY = ((Point2D)position).getY();
                this.myOffset = lEnd;
                if (this.myPerformActualDrawing && (markerColor = this.getMethodSeparatorColor(lIterator.getLineNumber())) != null) {
                    Color save = g.getColor();
                    this.setForegroundColor(g, markerColor);
                    LinePainter2D.paint((Graphics2D)g, (double)0.0, (double)((int)lineY), (double)((int)clip.getWidth()), (double)((int)lineY));
                    this.setForegroundColor(g, save);
                }
                if (!(((Point2D)position).getY() > clip.getY() + clip.getHeight() - (double)lineHeight)) continue;
                break;
            }
            if (hEnd > lEnd - lIterator.getSeparatorLength()) {
                if (!this.drawString(g, text2, lEnd - lIterator.getSeparatorLength(), this.myOffset == lStart, position, clip, backColor, underscoredColor)) {
                    this.drawLineNumber(g, lineY);
                    break;
                }
            } else if (!this.drawString(g, text2, hEnd, this.myOffset == lStart, position, clip, backColor, underscoredColor)) {
                this.drawLineNumber(g, lineY);
                break;
            }
            hIterator.advance();
            attributes = hIterator.getTextAttributes();
            Color color = attributes.getForegroundColor();
            if (color == null) {
                color = Color.black;
            }
            if (color != currentColor) {
                this.setForegroundColor(g, color);
                currentColor = color;
            }
            backColor = attributes.getBackgroundColor();
            underscoredColor = attributes.getEffectColor();
            Font font = this.getFont(attributes.getFontType());
            if (font != currentFont) {
                this.setFont(g, font);
                currentFont = font;
            }
            this.myOffset = hEnd;
        }
        g.translate(-clip.getX(), 0.0);
    }

    @Nullable
    private Color getMethodSeparatorColor(int line) {
        LineMarkerInfo tmpMarker;
        LineMarkerInfo marker = null;
        while (this.myCurrentMethodSeparator < this.myMethodSeparators.length && (tmpMarker = this.myMethodSeparators[this.myCurrentMethodSeparator]) != null && FileSeparatorProvider.getDisplayLine(tmpMarker, this.myDocument) <= line) {
            marker = tmpMarker;
            ++this.myCurrentMethodSeparator;
        }
        return marker == null ? null : (this.myMethodSeparatorColor == null ? marker.separatorColor : this.myMethodSeparatorColor);
    }

    private double drawHeader(Graphics2D g, Rectangle2D clip) {
        LineMetrics lineMetrics = this.getHeaderFooterLineMetrics(g);
        double w = clip.getWidth();
        double x = clip.getX();
        double y = clip.getY();
        double h = 0.0;
        boolean wasDrawn = false;
        String headerText1 = this.myPrintSettings.FOOTER_HEADER_TEXT1;
        if (!StringUtil.isEmpty((String)headerText1) && this.myPrintSettings.FOOTER_HEADER_PLACEMENT1 == PrintSettings.Placement.Header) {
            h = this.drawHeaderOrFooterLine(g, x, y, w, headerText1, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1);
            wasDrawn = true;
            y += h;
        }
        String headerText2 = this.myPrintSettings.FOOTER_HEADER_TEXT2;
        if (!StringUtil.isEmpty((String)headerText1) && this.myPrintSettings.FOOTER_HEADER_PLACEMENT2 == PrintSettings.Placement.Header) {
            if (this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1 == PrintSettings.Alignment.Left && this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2 == PrintSettings.Alignment.Right && wasDrawn) {
                y -= h;
            }
            h = this.drawHeaderOrFooterLine(g, x, y, w, headerText2, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2);
            y += h;
            wasDrawn = true;
        }
        return wasDrawn ? y - clip.getY() + (double)(lineMetrics.getHeight() / 3.0f) : 0.0;
    }

    private double drawFooter(Graphics2D g, Rectangle2D clip) {
        String headerText1;
        LineMetrics lineMetrics = this.getHeaderFooterLineMetrics(g);
        double w = clip.getWidth();
        double x = clip.getX();
        double y = clip.getY() + clip.getHeight();
        boolean wasDrawn = false;
        double h = 0.0;
        y -= (double)lineMetrics.getHeight();
        String headerText2 = this.myPrintSettings.FOOTER_HEADER_TEXT2;
        if (!StringUtil.isEmpty((String)headerText2) && this.myPrintSettings.FOOTER_HEADER_PLACEMENT2 == PrintSettings.Placement.Footer) {
            h = this.drawHeaderOrFooterLine(g, x, y, w, headerText2, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2);
            wasDrawn = true;
        }
        if (!StringUtil.isEmpty((String)(headerText1 = this.myPrintSettings.FOOTER_HEADER_TEXT1)) && this.myPrintSettings.FOOTER_HEADER_PLACEMENT1 == PrintSettings.Placement.Footer) {
            y -= (double)lineMetrics.getHeight();
            if (this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1 == PrintSettings.Alignment.Left && this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2 == PrintSettings.Alignment.Right && wasDrawn) {
                y += h;
            }
            this.drawHeaderOrFooterLine(g, x, y, w, headerText1, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1);
            wasDrawn = true;
        }
        return wasDrawn ? clip.getY() + clip.getHeight() - y + (double)(lineMetrics.getHeight() / 4.0f) : 0.0;
    }

    private double drawHeaderOrFooterLine(Graphics2D g, double x, double y, double w, String headerText, PrintSettings.Alignment alignment) {
        FontRenderContext fontRenderContext = g.getFontRenderContext();
        LineMetrics lineMetrics = this.getHeaderFooterLineMetrics(g);
        float lineHeight = lineMetrics.getHeight();
        if (this.myPerformActualDrawing) {
            headerText = this.convertHeaderText(headerText);
            g.setFont(this.myHeaderFont);
            g.setColor(Color.black);
            float descent = lineMetrics.getDescent();
            double width = this.myHeaderFont.getStringBounds(headerText, fontRenderContext).getWidth() + this.getCharWidth(g);
            float yPos = (float)((double)(lineHeight - descent) + y);
            switch (alignment) {
                case Left: {
                    this.drawStringToGraphics(g, headerText, x, yPos);
                    break;
                }
                case Center: {
                    this.drawStringToGraphics(g, headerText, (float)(x + (w - width) / 2.0), yPos);
                    break;
                }
                case Right: {
                    this.drawStringToGraphics(g, headerText, (float)(x + w - width), yPos);
                }
            }
        }
        return lineHeight;
    }

    private String convertHeaderText(String s) {
        StringBuilder result2 = new StringBuilder();
        int start2 = 0;
        boolean isExpression = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '$') continue;
            String token = s.substring(start2, i);
            if (isExpression) {
                if (HEADER_TOKEN_PAGE.equals(token)) {
                    result2.append(this.myPageIndex + 1);
                } else if (HEADER_TOKEN_TOTALPAGES.equals(token)) {
                    result2.append(this.myNumberOfPages);
                } else if (HEADER_TOKEN_FILE.equals(token)) {
                    result2.append(this.myFullFileName);
                } else if (HEADER_TOKEN_FILENAME.equals(token)) {
                    result2.append(this.myShortFileName);
                } else if (HEADER_TOKEN_DATE.equals(token)) {
                    result2.append(this.myPrintDate);
                } else if (HEADER_TOKEN_TIME.equals(token)) {
                    result2.append(this.myPrintTime);
                }
            } else {
                result2.append(token);
            }
            isExpression = !isExpression;
            start2 = i + 1;
        }
        if (!isExpression && start2 < s.length()) {
            result2.append(s.substring(start2));
        }
        return result2.toString();
    }

    private LineMetrics getHeaderFooterLineMetrics(Graphics2D g) {
        FontRenderContext fontRenderContext = g.getFontRenderContext();
        return this.myHeaderFont.getLineMetrics(DEFAULT_MEASURE_HEIGHT_TEXT, fontRenderContext);
    }

    private double calcNumbersStripWidth(Graphics2D g, Rectangle2D clip) {
        if (!this.myPrintSettings.PRINT_LINE_NUMBERS) {
            return 0.0;
        }
        int maxLineNumber = this.myLineNumber + (int)(clip.getHeight() / (double)this.getLineHeight(g));
        FontRenderContext fontRenderContext = g.getFontRenderContext();
        double numbersStripWidth = 0.0;
        for (int i = this.myLineNumber; i < maxLineNumber; ++i) {
            double width = this.myPlainFont.getStringBounds(String.valueOf(i), fontRenderContext).getWidth();
            if (!(numbersStripWidth < width)) continue;
            numbersStripWidth = width;
        }
        return numbersStripWidth;
    }

    private void drawLineNumber(Graphics2D g, double y) {
        if (!this.myPrintSettings.PRINT_LINE_NUMBERS || !this.myPerformActualDrawing) {
            return;
        }
        FontRenderContext fontRenderContext = g.getFontRenderContext();
        double width = this.myPlainFont.getStringBounds(String.valueOf(this.myLineNumber), fontRenderContext).getWidth() + this.getCharWidth(g);
        Color savedColor = g.getColor();
        Font savedFont = g.getFont();
        g.setColor(Color.black);
        g.setFont(this.myPlainFont);
        this.drawStringToGraphics(g, String.valueOf(this.myLineNumber), -width, (double)(this.getLineHeight(g) - this.getDescent(g)) + y);
        g.setColor(savedColor);
        g.setFont(savedFont);
    }

    private boolean drawString(Graphics2D g, char[] text2, int end, boolean lineStart, Point2D position, Rectangle2D clip, Color backColor, Color underscoredColor) {
        boolean isInClip;
        boolean toContinue = true;
        if (end >= this.mySegmentEnd) {
            end = this.mySegmentEnd;
            toContinue = false;
        }
        if (this.myOffset >= end) {
            return toContinue;
        }
        boolean bl = isInClip = (double)this.getLineHeight(g) + position.getY() >= clip.getY() && position.getY() <= clip.getY() + clip.getHeight();
        if (!isInClip) {
            return toContinue;
        }
        if (this.myPrintSettings.WRAP) {
            double w = this.getTextSegmentWidth(text2, this.myOffset, end - this.myOffset, position.getX(), g);
            if (position.getX() + w > clip.getWidth()) {
                IntArrayList breakOffsets = LineWrapper.calcBreakOffsets(text2, this.myOffset, end, lineStart, position.getX(), clip.getWidth(), (t, start2, count, x) -> this.getTextSegmentWidth(t, start2, count, x, g));
                for (int i = 0; i < breakOffsets.size(); ++i) {
                    int breakOffset = breakOffsets.get(i);
                    this.drawTabbedString(g, text2, breakOffset - this.myOffset, position, backColor, underscoredColor);
                    position.setLocation(0.0, position.getY() + (double)this.getLineHeight(g));
                    if (!(position.getY() > clip.getY() + clip.getHeight() - (double)this.getLineHeight(g))) continue;
                    return false;
                }
            }
        }
        this.drawTabbedString(g, text2, end - this.myOffset, position, backColor, underscoredColor);
        return toContinue;
    }

    private void drawTabbedString(Graphics2D g, char[] text2, int length, Point2D position, Color backColor, Color underscoredColor) {
        ProgressManager.checkCanceled();
        if (length <= 0) {
            return;
        }
        double xStart = position.getX();
        double x = position.getX();
        double y = (double)(this.getLineHeight(g) - this.getDescent(g)) + position.getY();
        if (backColor != null && this.myPerformActualDrawing) {
            Color savedColor = g.getColor();
            this.setBackgroundColor(g, backColor);
            double w = this.getTextSegmentWidth(text2, this.myOffset, length, position.getX(), g);
            g.fill(new Area(new Rectangle2D.Double(position.getX(), y - (double)this.getLineHeight(g) + (double)this.getDescent(g), w, this.getLineHeight(g))));
            g.setColor(savedColor);
        }
        int start2 = this.myOffset;
        for (int i = this.myOffset; i < this.myOffset + length; ++i) {
            if (text2[i] != '\t') continue;
            if (i > start2) {
                String s = new String(text2, start2, i - start2);
                x += this.drawStringToGraphics(g, s, x, y);
            }
            x = this.nextTabStop(g, x);
            start2 = i + 1;
        }
        if (this.myOffset + length > start2) {
            String s = new String(text2, start2, this.myOffset + length - start2);
            x += this.drawStringToGraphics(g, s, x, y);
        }
        if (underscoredColor != null && this.myPerformActualDrawing) {
            Color savedColor = g.getColor();
            this.setForegroundColor(g, underscoredColor);
            double w = this.getTextSegmentWidth(text2, this.myOffset, length, position.getX(), g);
            LinePainter2D.paint((Graphics2D)g, (double)((int)position.getX()), (double)((int)y + 1), (double)((int)(xStart + w)), (double)((int)(y + 1.0)));
            g.setColor(savedColor);
        }
        position.setLocation(x, position.getY());
        this.myOffset += length;
    }

    private double drawStringToGraphics(Graphics2D g, String s, double x, double y) {
        if (!this.myPrintSettings.PRINT_AS_GRAPHICS) {
            if (this.myPerformActualDrawing) {
                g.drawString(s, (float)x, (float)y);
            }
            return g.getFontMetrics().stringWidth(s);
        }
        GlyphVector v = g.getFont().createGlyphVector(g.getFontRenderContext(), s);
        if (this.myPerformActualDrawing) {
            g.translate(x, y);
            g.fill(v.getOutline());
            g.translate(-x, -y);
        }
        return v.getLogicalBounds().getWidth();
    }

    private double getTextSegmentWidth(char[] text2, int offset, int length, double x, Graphics2D g) {
        int start2 = offset;
        double startX = x;
        for (int i = offset; i < offset + length; ++i) {
            if (text2[i] != '\t') continue;
            if (i > start2) {
                x += TextPainter.getStringWidth(g, text2, start2, i - start2);
            }
            x = this.nextTabStop(g, x);
            start2 = i + 1;
        }
        if (offset + length > start2) {
            x += TextPainter.getStringWidth(g, text2, start2, offset + length - start2);
        }
        return x - startX;
    }

    private static double getStringWidth(Graphics2D g, char[] text2, int start2, int count) {
        String s = new String(text2, start2, count);
        GlyphVector v = g.getFont().createGlyphVector(g.getFontRenderContext(), s);
        return v.getLogicalBounds().getWidth();
    }

    public double nextTabStop(Graphics2D g, double x) {
        double tabSize = this.myCodeStyleSettings.getTabSize(this.myFileType);
        if (tabSize <= 0.0) {
            tabSize = 1.0;
        }
        int nTabs = (int)(x / (tabSize *= g.getFont().getStringBounds(" ", g.getFontRenderContext()).getWidth()));
        return (double)(nTabs + 1) * tabSize;
    }

    @Override
    void dispose() {
        this.setSegment(null);
        this.myProject = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editorDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "codeStyleSettings";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeEditor/printing/TextPainter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HighlightingAttributesIterator {
        @NotNull
        private final HighlighterIterator myDelegate;
        private int myEnd;
        private TextAttributes myAttributes;

        private HighlightingAttributesIterator(@NotNull HighlighterIterator delegate) {
            if (delegate == null) {
                HighlightingAttributesIterator.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
            this.advance();
        }

        public void advance() {
            if (this.myDelegate.atEnd()) {
                this.myEnd = -1;
            } else {
                this.myAttributes = this.myDelegate.getTextAttributes();
                do {
                    this.myEnd = this.myDelegate.getEnd();
                    this.myDelegate.advance();
                } while (!this.myDelegate.atEnd() && Objects.equals(this.myAttributes, this.myDelegate.getTextAttributes()));
            }
        }

        public boolean atEnd() {
            return this.myEnd == -1;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public TextAttributes getTextAttributes() {
            return this.myAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/codeEditor/printing/TextPainter$HighlightingAttributesIterator", "<init>"));
        }
    }
}

