/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptimizeImportsProcessor
extends AbstractLayoutCodeProcessor {
    @Deprecated
    public static final String COMMAND_NAME = "Optimize Imports";
    private final List<NotificationInfo> myOptimizerNotifications;

    public OptimizeImportsProcessor(@NotNull Project project) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(0);
        }
        super(project, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText(), false);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull Project project, Module module) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(1);
        }
        super(project, module, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText(), false);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull Project project, PsiDirectory directory, boolean includeSubdirs) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(2);
        }
        super(project, directory, includeSubdirs, OptimizeImportsProcessor.getProgressText(), OptimizeImportsProcessor.getCommandName(), false);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull Project project, PsiDirectory directory, boolean includeSubdirs, boolean processOnlyVcsChangedFiles) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(3);
        }
        super(project, directory, includeSubdirs, OptimizeImportsProcessor.getProgressText(), OptimizeImportsProcessor.getCommandName(), processOnlyVcsChangedFiles);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull Project project, PsiFile file2) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(4);
        }
        super(project, file2, OptimizeImportsProcessor.getProgressText(), OptimizeImportsProcessor.getCommandName(), false);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull Project project, PsiFile[] files2, Runnable postRunnable) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(5);
        }
        this(project, files2, OptimizeImportsProcessor.getCommandName(), postRunnable);
    }

    public OptimizeImportsProcessor(@NotNull Project project, PsiFile[] files2, String commandName, Runnable postRunnable) {
        if (project == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(6);
        }
        super(project, files2, OptimizeImportsProcessor.getProgressText(), commandName, postRunnable, false);
        this.myOptimizerNotifications = new SmartList();
    }

    public OptimizeImportsProcessor(@NotNull AbstractLayoutCodeProcessor processor2) {
        if (processor2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(7);
        }
        super(processor2, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText());
        this.myOptimizerNotifications = new SmartList();
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(8);
        }
        if (DumbService.isDumb((Project)file2.getProject())) {
            return new FutureTask<Boolean>(EmptyRunnable.INSTANCE, true);
        }
        Set optimizers = LanguageImportStatements.INSTANCE.forFile(file2);
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        List files2 = file2.getViewProvider().getAllFiles();
        for (ImportOptimizer optimizer : optimizers) {
            for (PsiFile psiFile : files2) {
                if (!optimizer.supports(psiFile)) continue;
                runnables.add(optimizer.processFile(psiFile));
            }
        }
        Runnable runnable2 = !runnables.isEmpty() ? () -> {
            CodeStyleManagerImpl.setSequentialProcessingAllowed(false);
            try {
                for (Runnable runnable1 : runnables) {
                    runnable1.run();
                    this.retrieveAndStoreNotificationInfo(runnable1);
                }
                this.putNotificationInfoIntoCollector();
            }
            finally {
                CodeStyleManagerImpl.setSequentialProcessingAllowed(true);
            }
        } : EmptyRunnable.getInstance();
        return new FutureTask<Boolean>(runnable2, true);
    }

    private void retrieveAndStoreNotificationInfo(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            OptimizeImportsProcessor.$$$reportNull$$$0(9);
        }
        if (runnable2 instanceof ImportOptimizer.CollectingInfoRunnable) {
            String optimizerMessage = ((ImportOptimizer.CollectingInfoRunnable)runnable2).getUserNotificationInfo();
            this.myOptimizerNotifications.add(optimizerMessage != null ? new NotificationInfo(optimizerMessage) : NotificationInfo.NOTHING_CHANGED_NOTIFICATION);
        } else if (runnable2 == EmptyRunnable.getInstance()) {
            this.myOptimizerNotifications.add(NotificationInfo.NOTHING_CHANGED_NOTIFICATION);
        } else {
            this.myOptimizerNotifications.add(NotificationInfo.SOMETHING_CHANGED_WITHOUT_MESSAGE_NOTIFICATION);
        }
    }

    private void putNotificationInfoIntoCollector() {
        LayoutCodeInfoCollector collector = this.getInfoCollector();
        if (collector == null) {
            return;
        }
        boolean atLeastOneOptimizerChangedSomething = false;
        for (NotificationInfo info : this.myOptimizerNotifications) {
            atLeastOneOptimizerChangedSomething |= info.isSomethingChanged();
            if (info.getMessage() == null) continue;
            collector.setOptimizeImportsNotification(info.getMessage());
            return;
        }
        collector.setOptimizeImportsNotification(atLeastOneOptimizerChangedSomething ? "imports optimized" : null);
    }

    private static String getProgressText() {
        return CodeInsightBundle.message((String)"progress.text.optimizing.imports", (Object[])new Object[0]);
    }

    public static String getCommandName() {
        return CodeInsightBundle.message((String)"process.optimize.imports", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/actions/OptimizeImportsProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareTask";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "retrieveAndStoreNotificationInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class NotificationInfo {
        public static final NotificationInfo NOTHING_CHANGED_NOTIFICATION = new NotificationInfo(false, null);
        public static final NotificationInfo SOMETHING_CHANGED_WITHOUT_MESSAGE_NOTIFICATION = new NotificationInfo(true, null);
        private final boolean mySomethingChanged;
        private final String myMessage;

        NotificationInfo(@NotNull String message) {
            if (message == null) {
                NotificationInfo.$$$reportNull$$$0(0);
            }
            this(true, message);
        }

        public boolean isSomethingChanged() {
            return this.mySomethingChanged;
        }

        public String getMessage() {
            return this.myMessage;
        }

        private NotificationInfo(boolean isSomethingChanged, @Nullable String message) {
            this.mySomethingChanged = isSomethingChanged;
            this.myMessage = message;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/actions/OptimizeImportsProcessor$NotificationInfo", "<init>"));
        }
    }
}

