/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCodeProcessor
extends AbstractLayoutCodeProcessor {
    private static final Logger LOG = Logger.getInstance(ReformatCodeProcessor.class);
    private final Collection<TextRange> myRanges;
    private SelectionModel mySelectionModel;

    public ReformatCodeProcessor(Project project, boolean processChangedTextOnly) {
        super(project, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText(), processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(0);
        }
        if (selectionModel == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(1);
        }
        super(file2.getProject(), file2, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), false);
        this.myRanges = new ArrayList<TextRange>();
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, @NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(2);
        }
        super(processor2, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText());
        this.myRanges = new ArrayList<TextRange>();
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, boolean processChangedTextOnly) {
        super(processor2, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText());
        this.myRanges = new ArrayList<TextRange>();
        this.setProcessChangedTextOnly(processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, Module module, boolean processChangedTextOnly) {
        super(project, module, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText(), processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiDirectory directory, boolean includeSubdirs, boolean processChangedTextOnly) {
        super(project, directory, includeSubdirs, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiFile file2, @Nullable TextRange range2, boolean processChangedTextOnly) {
        super(project, file2, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
        if (range2 != null) {
            this.myRanges.add(range2);
        }
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(3);
        }
        super(file2.getProject(), file2, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files2, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this(project, files2, ReformatCodeProcessor.getCommandName(), postRunnable, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files2, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        super(project, files2, ReformatCodeProcessor.getProgressText(), commandName, postRunnable, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) throws IncorrectOperationException {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(4);
        }
        return new FutureTask<Boolean>(() -> {
            FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
            try {
                PsiFile fileToProcess = ReformatCodeProcessor.ensureValid(file2);
                if (fileToProcess == null) {
                    Boolean bl = false;
                    return bl;
                }
                CharSequence before = null;
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(fileToProcess);
                if (this.getInfoCollector() != null) {
                    LOG.assertTrue(document != null);
                    before = document.getImmutableCharSequence();
                }
                EditorScrollingPositionKeeper.perform(document, true, () -> {
                    if (processChangedTextOnly) {
                        ChangedRangesInfo info = FormatChangedTextUtil.getInstance().getChangedRangesInfo(fileToProcess);
                        if (info != null) {
                            ReformatCodeProcessor.assertFileIsValid(fileToProcess);
                            CodeStyleManager.getInstance((Project)this.myProject).reformatTextWithContext(fileToProcess, info);
                        }
                    } else {
                        Collection<TextRange> ranges = this.getRangesToFormat(fileToProcess);
                        CodeStyleManager.getInstance((Project)this.myProject).reformatText(fileToProcess, ranges);
                    }
                });
                if (before != null) {
                    this.prepareUserNotificationMessage(document, before);
                }
                Boolean bl = FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get() == false;
                return bl;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                this.myRanges.clear();
            }
        });
    }

    @Nullable
    private static PsiFile ensureValid(@NotNull PsiFile file2) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(5);
        }
        if (file2.isValid()) {
            return file2;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (!virtualFile.isValid()) {
            return null;
        }
        FileViewProvider provider = file2.getManager().findViewProvider(virtualFile);
        if (provider == null) {
            return null;
        }
        Language language = file2.getLanguage();
        return provider.hasLanguage(language) ? provider.getPsi(language) : provider.getPsi(provider.getBaseLanguage());
    }

    private static void assertFileIsValid(@NotNull PsiFile file2) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(6);
        }
        if (!file2.isValid()) {
            LOG.error("Invalid Psi file, name: " + file2.getName() + " , class: " + file2.getClass().getSimpleName() + " , " + PsiInvalidElementAccessException.findOutInvalidationReason((PsiElement)file2));
        }
    }

    private void prepareUserNotificationMessage(@NotNull Document document, @NotNull CharSequence before) {
        if (document == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(7);
        }
        if (before == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(this.getInfoCollector() != null);
        int number = FormatChangedTextUtil.getInstance().calculateChangedLinesNumber(document, before);
        if (number > 0) {
            String message = "formatted " + number + " line" + (number > 1 ? "s" : "");
            this.getInfoCollector().setReformatCodeNotification(message);
        }
    }

    @NotNull
    private Collection<TextRange> getRangesToFormat(PsiFile file2) {
        if (this.mySelectionModel != null) {
            List<TextRange> list2 = ReformatCodeProcessor.getSelectedRanges(this.mySelectionModel);
            if (list2 == null) {
                ReformatCodeProcessor.$$$reportNull$$$0(9);
            }
            return list2;
        }
        ArrayList arrayList = !this.myRanges.isEmpty() ? this.myRanges : ContainerUtil.newArrayList((Object[])new TextRange[]{file2.getTextRange()});
        if (arrayList == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static String getProgressText() {
        return CodeInsightBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
    }

    public static String getCommandName() {
        return CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/ReformatCodeProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/ReformatCodeProcessor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesToFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareTask";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertFileIsValid";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareUserNotificationMessage";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

